/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.dataModel;

import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.interfaces.VisibleObject;
import com.elluminate.util.log.LogSupport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.util.Iterator;

public class ImageWriterGraphics {
    public static BufferedImage processToolToImage(String title, Iterator tools, int x, int y, int width, int height, boolean fill, BufferedImage image, ProgressUpdate progress) {
        if (image != null) {
            if (image.getWidth() != width || image.getHeight() != height) {
                image = null;
            } else if (image.getType() != (fill ? 1 : 2)) {
                image = null;
            }
        }
        if (image == null) {
            image = fill ? new BufferedImage(width, height, 1) : new BufferedImage(width, height, 2);
        }
        Graphics2D g2Local = image.createGraphics();
        g2Local.setClip(0, 0, width, height);
        g2Local.translate(-x, -y);
        if (fill) {
            g2Local.setColor(Color.white);
            g2Local.fill(new Rectangle(x, y, width, height));
        }
        g2Local.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        g2Local.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        while (tools.hasNext()) {
            Object obj = tools.next();
            if (!(obj instanceof VisibleObject)) continue;
            VisibleObject vObj = (VisibleObject)obj;
            try {
                vObj.render(g2Local);
            }
            catch (Exception ex) {
                LogSupport.exception(ImageWriterGraphics.class, (String)"processToolToImage", (Throwable)ex, (boolean)true);
            }
            if (progress == null) continue;
            progress.setValue(progress.getValue() + 1);
        }
        g2Local.setColor(Color.black);
        g2Local.setStroke(new BasicStroke(1.0f));
        g2Local.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (title != null && title.length() > 0) {
            g2Local.setColor(Color.black);
            g2Local.setStroke(new BasicStroke(1.0f));
            FontRenderContext fontContext = g2Local.getFontRenderContext();
            Font font = new Font("Dialog", 1, 20);
            float ascent = font.getLineMetrics(title, fontContext).getAscent();
            g2Local.setColor(Color.blue);
            TextLayout textLayout = new TextLayout(title, font, fontContext);
            textLayout.draw(g2Local, 1.0f, (float)height - ascent);
        }
        g2Local.dispose();
        return image;
    }
}

