/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.dataModel;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.dataModel.ObjectIDs;
import com.elluminate.groupware.whiteboard.dataModel.ObjectUID;
import com.elluminate.util.log.LogSupport;
import java.util.Iterator;
import java.util.LinkedList;

public class DataUtilities {
    private static final boolean DEBUG = false;

    private DataUtilities() {
    }

    public static LinkedList readObjectUIDs(WBInputStream istr) throws Exception {
        int count = istr.readShort();
        LinkedList<ObjectIDs> ids = new LinkedList<ObjectIDs>();
        for (int i = 0; i < count; ++i) {
            Long uid = ObjectUID.objectUIDFromStream(istr);
            short revision = WBUtils.readShort(istr, "ScreenUtilities read revision");
            if (uid != null) {
                ids.add(new ObjectIDs(uid, revision));
                continue;
            }
            LogSupport.error((Object)"DataUtilities", (String)"readObjectUIDs", (String)"DataUtilties.readObjectUIDs: Null uid read from stream");
            Thread.dumpStack();
        }
        return ids;
    }

    public static String objectIDsToString(WhiteboardContext context, LinkedList ids) {
        StringBuffer buf = new StringBuffer();
        Iterator iter = ids.iterator();
        try {
            while (iter.hasNext()) {
                Object object = iter.next();
                if (object instanceof ObjectIDs) {
                    ObjectIDs objI = (ObjectIDs)object;
                    buf.append(WBUtils.objectName(new Long(objI.getUID()), context));
                } else {
                    buf.append("Not ObjectIDs: " + object.getClass().getName());
                }
                if (!iter.hasNext()) continue;
                buf.append("\n   ");
            }
        }
        catch (Exception ex) {
            LogSupport.exception(DataUtilities.class, (String)"objectIDsToString", (Throwable)ex, (boolean)true);
        }
        return buf.toString();
    }
}

