/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.dataModel;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.ObjectIDs;
import com.elluminate.groupware.whiteboard.dataModel.ObjectUID;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.util.log.LogSupport;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DataModelData {
    private static final boolean DEBUG = false;
    private static final int PUBLIC_OBJECTS = 1;
    private static final int PRIVATE_OBJECTS = 2;
    private static final int SCREENS = 4;
    private static final int TOOLS = 8;
    private static final int PROXIES = 16;
    private WhiteboardContext context;
    private HashMap screenMap = new HashMap();
    private HashMap toolMap = new HashMap();
    private HashMap proxyMap = new HashMap();
    private boolean publicObjects;
    private boolean privateObjects;
    private boolean screens = true;
    private boolean tools = true;
    private boolean proxies = true;
    private boolean values = false;

    public DataModelData(WhiteboardContext context, boolean publicObjects, boolean privateObjects, DataModelData filterData, short targetClient) {
        this.context = context;
        this.publicObjects = publicObjects;
        this.privateObjects = privateObjects;
        this.processModel(filterData, targetClient);
        this.values = true;
    }

    public DataModelData(WhiteboardContext context, WBInputStream istr) {
        this.context = context;
        try {
            byte mode = istr.readByte();
            this.publicObjects = (mode & 1) != 0;
            this.privateObjects = (mode & 2) != 0;
            this.screens = (mode & 4) != 0;
            this.tools = (mode & 8) != 0;
            boolean bl = this.proxies = (mode & 0x10) != 0;
            if (this.screens) {
                this.read(this.screenMap, istr);
            }
            if (this.tools) {
                this.read(this.toolMap, istr);
            }
            if (this.proxies) {
                this.read(this.proxyMap, istr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void read(HashMap map, WBInputStream istr) throws Exception {
        int count = istr.readShort();
        for (int i = 0; i < count; ++i) {
            Long uid = ObjectUID.objectUIDFromStream(istr);
            short revision = WBUtils.readShort(istr, "ScreenUtilities read revision");
            if (uid != null) {
                ObjectIDs objectIDs = new ObjectIDs(uid, revision);
                map.put(objectIDs, null);
                continue;
            }
            LogSupport.error((Object)"DataModelData", (String)"read", (String)"DataModelData.read: Null uid read from stream");
            Thread.dumpStack();
        }
    }

    public static String streamToString(WBInputStream istr) throws IOException {
        StringBuffer buf = new StringBuffer();
        byte mode = istr.readByte();
        if ((mode & 4) != 0) {
            DataModelData.readDataModel(buf, istr, "DataModelData.SCREENS");
        }
        if ((mode & 8) != 0) {
            DataModelData.readDataModel(buf, istr, "DataModelData.TOOLS");
        }
        if ((mode & 0x10) != 0) {
            DataModelData.readDataModel(buf, istr, "DataModelData.PROXIES");
        }
        return buf.toString();
    }

    private static void readDataModel(StringBuffer buf, WBInputStream istr, String modelName) throws IOException {
        int count = istr.readShort();
        buf.append(modelName + " count  = " + count);
        for (int i = 0; i < count; ++i) {
            Long uid = ObjectUID.objectUIDFromStream(istr);
            short revision = WBUtils.readShort(istr, "ScreenUtilities read revision");
            buf.append(" uid = " + uid + " ScreenUtilities read revision = " + revision);
        }
        buf.append("\n");
    }

    public void emitDataModel(WBOutputStream ostr, boolean screens, boolean tools, boolean proxies) throws Exception {
        int mode = 0;
        if (this.publicObjects) {
            mode = 1;
        }
        if (this.privateObjects) {
            mode += 2;
        }
        if (screens) {
            mode += 4;
        }
        if (tools) {
            mode += 8;
        }
        if (proxies) {
            mode += 16;
        }
        ostr.writeByte(mode);
        if (screens) {
            this.emit(this.screenMap, ostr);
        }
        if (tools) {
            this.emit(this.toolMap, ostr);
        }
        if (proxies) {
            this.emit(this.proxyMap, ostr);
        }
    }

    private void emit(HashMap map, WBOutputStream ostr) throws Exception {
        ostr.writeShort(map.size());
        for (WBNode node : map.values()) {
            ObjectUID.objectUIDToStream(node.getObjectID(), ostr);
            ostr.writeShort(node.getRevision());
            ObjectIDs objectIDs = new ObjectIDs(node.getObjectID(), node.getRevision());
        }
    }

    private void processModel(DataModelData filterData, short targetClient) {
        Iterator iter = this.context.getDataModel().getRoot().iterateScreens();
        while (iter.hasNext()) {
            WBNode node = (WBNode)iter.next();
            boolean accept = false;
            accept = node.getRoot() == this.context.getDataModel().getPrivateScreens() && this.privateObjects ? ((ScreenModel)node).canDistributeTo(targetClient) : (accept |= this.publicObjects);
            if (!accept) continue;
            ObjectIDs objectIDs = new ObjectIDs(node.getObjectID(), node.getRevision());
            if (node.isProxy()) {
                this.proxyMap.put(objectIDs, node);
                continue;
            }
            if (filterData == null || !filterData.screenMap.containsKey(objectIDs)) {
                this.screenMap.put(objectIDs, node);
            }
            this.screenSet(node, filterData, targetClient);
        }
    }

    private void screenSet(WBNode node, DataModelData filterData, short targetClient) {
        Iterator toolIterator = node.iterateTools();
        while (toolIterator.hasNext()) {
            WBNode toolNode = (WBNode)toolIterator.next();
            this.toolSet(toolNode, filterData);
        }
        Iterator iter = node.iterateScreens();
        while (iter.hasNext()) {
            WBNode nextNode = (WBNode)iter.next();
            boolean accept = false;
            accept = nextNode.getRoot() == this.context.getDataModel().getPrivateScreens() && this.privateObjects ? ((ScreenModel)nextNode).canDistributeTo(targetClient) : (accept |= this.publicObjects);
            if (!accept) continue;
            ObjectIDs objectIDs = new ObjectIDs(nextNode.getObjectID(), nextNode.getRevision());
            if (nextNode.isProxy()) {
                this.proxyMap.put(objectIDs, nextNode);
                continue;
            }
            if (filterData == null || !filterData.screenMap.containsKey(objectIDs)) {
                this.screenMap.put(objectIDs, nextNode);
            }
            this.screenSet(nextNode, filterData, targetClient);
        }
    }

    private void toolSet(WBNode node, DataModelData filterData) {
        boolean accept = false;
        accept = node.getRoot() == this.context.getDataModel().getPrivateScreens() && this.privateObjects ? true : (accept |= this.publicObjects);
        if (accept && node.getObjectID() != null) {
            ObjectIDs objectIDs = new ObjectIDs(node.getObjectID(), node.getRevision());
            if (node.isProxy()) {
                this.proxyMap.put(objectIDs, node);
            } else {
                if (filterData == null || !filterData.toolMap.containsKey(objectIDs)) {
                    this.toolMap.put(objectIDs, node);
                }
                Iterator toolIterator = node.iterateTools();
                while (toolIterator.hasNext()) {
                    WBNode toolNode = (WBNode)toolIterator.next();
                    this.toolSet(toolNode, filterData);
                }
            }
        }
    }

    public Iterator screenEntryIterator() {
        return this.screenMap.entrySet().iterator();
    }

    public Iterator toolEntryIterator() {
        return this.toolMap.entrySet().iterator();
    }

    public Iterator proxyEntryIterator() {
        return this.proxyMap.entrySet().iterator();
    }

    public boolean hasPublicObjects() {
        return this.publicObjects;
    }

    public boolean hasPrivateObjects() {
        return this.privateObjects;
    }

    public boolean hasProxies() {
        return this.proxies;
    }

    public boolean hasScreens() {
        return this.screens;
    }

    public boolean hasTools() {
        return this.tools;
    }

    public boolean hasValues() {
        return this.values;
    }

    public List getDeleteList(boolean publicObjects, boolean privateObjects) {
        LinkedList deleteList = new LinkedList();
        Iterator iter = this.context.getDataModel().screenGroups.iterateScreens();
        while (iter.hasNext()) {
            WBNode screenNode = (WBNode)iter.next();
            this.testNodeDelete(deleteList, screenNode, publicObjects, privateObjects);
        }
        return deleteList;
    }

    private void testNodeDelete(LinkedList deleteList, WBNode node, boolean publicObjects, boolean privateObjects) {
        boolean processNode = node.getRoot() == this.context.getDataModel().privateRoot ? privateObjects : publicObjects;
        if (processNode) {
            ObjectIDs objectID = new ObjectIDs(node.getObjectID(), node.getRevision());
            if (!this.screenMap.containsKey(objectID) && !this.toolMap.containsKey(objectID)) {
                if (!this.proxyMap.containsKey(objectID)) {
                    deleteList.addFirst(node);
                    return;
                }
                return;
            }
            Iterator iter = node.iterateScreens();
            while (iter.hasNext()) {
                WBNode childScreen = (WBNode)iter.next();
                this.testNodeDelete(deleteList, childScreen, publicObjects, privateObjects);
            }
            iter = node.iterateTools();
            while (iter.hasNext()) {
                WBNode childTool = (WBNode)iter.next();
                this.testNodeDelete(deleteList, childTool, publicObjects, privateObjects);
            }
        }
    }

    public Collection getScreenCollection() {
        return this.screenMap.values();
    }

    public Collection getToolCollection() {
        return this.toolMap.values();
    }

    public Collection getProxyCollection() {
        return this.proxyMap.values();
    }

    public void clear() {
        this.screenMap.clear();
        this.toolMap.clear();
        this.proxyMap.clear();
        this.screens = false;
        this.tools = false;
        this.proxies = false;
        this.values = false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("publicObjects: " + this.publicObjects + ", privateObjects: " + this.privateObjects + "\n");
        buf.append("Screens: (" + this.screenMap.size() + "):\n");
        for (Map.Entry entry : this.screenMap.entrySet()) {
            if (entry.getValue() != null) {
                buf.append("  " + entry.getValue());
                continue;
            }
            buf.append("  " + entry.getKey() + "\n");
        }
        buf.append("Tools: (" + this.toolMap.size() + "):\n");
        for (Map.Entry entry : this.toolMap.entrySet()) {
            if (entry.getValue() != null) {
                buf.append("  " + entry.getValue());
                continue;
            }
            buf.append("  " + entry.getKey() + "\n");
        }
        buf.append("Proxies: (" + this.proxyMap.size() + "):\n");
        for (Map.Entry entry : this.proxyMap.entrySet()) {
            if (entry.getValue() != null) {
                buf.append("  " + entry.getValue());
                continue;
            }
            buf.append("  " + entry.getKey() + "\n");
        }
        return buf.toString();
    }
}

