/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.conference;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.WhiteboardProtocol;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.util.ShortList;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class WBInputStream
extends DataInputStream {
    ChannelDataEvent cde = null;
    Short originatorAddress = null;
    Short originatorId = null;
    WhiteboardContext context = null;
    InputStream istr = null;

    private WBInputStream(InputStream istr, WhiteboardContext context, ChannelDataEvent cde) {
        super(istr);
        this.istr = istr;
        this.context = context;
        this.setCde(cde);
    }

    public static WBInputStream inputStreamFactory(InputStream istr, WhiteboardContext context, ChannelDataEvent cde) {
        ChannelDataEvent cdeClone = null;
        if (cde != null) {
            cdeClone = (ChannelDataEvent)cde.clone();
        }
        return new WBInputStream(istr, context, cdeClone);
    }

    public static WBInputStream inputStreamFactory(WhiteboardContext context, ChannelDataEvent cde) {
        ChannelDataEvent cdeClone = (ChannelDataEvent)cde.clone();
        return new WBInputStream(cdeClone.read(), context, cdeClone);
    }

    public ChannelDataEvent getCde() {
        return this.cde;
    }

    public InputStream getInputStream() {
        return this.istr;
    }

    public void setCde(ChannelDataEvent cde) {
        this.cde = cde;
        if (cde != null) {
            this.setAddress(ShortList.get((short)cde.getSourceAddress()));
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.cde != null) {
            this.cde.dispose();
        }
    }

    public WhiteboardContext getContext() {
        return this.context;
    }

    public Short getAddress() {
        return this.originatorAddress;
    }

    public void setAddress(Short originatorAddress) {
        this.originatorAddress = originatorAddress;
        if (this.context != null) {
            this.originatorId = this.context.getIDProcessor().getClientId(originatorAddress);
        }
    }

    public Short getOriginatorId() {
        return this.originatorId;
    }

    public void setOriginatorId(Short clientId) {
        this.originatorId = clientId;
    }

    public String toString() {
        try {
            StringBuffer msg = new StringBuffer(this.istr.available());
            byte[] strData = new byte[this.istr.available()];
            this.istr.read(strData);
            this.istr.close();
            msg.append(strData.length + " bytes\n");
            msg.append(WhiteboardProtocol.arrayToString(strData));
            this.istr = new DataInputStream(new ByteArrayInputStream(strData));
            return msg.toString();
        }
        catch (Exception e) {
            return "WBInputStream.toString: Exception: " + e.getMessage();
        }
    }
}

