/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.conference;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.comm.AbstractCommContainer;
import com.elluminate.groupware.whiteboard.conference.ProxyReceipt;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.ObjectUID;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.dataModel.WBNodeProxy;
import com.elluminate.groupware.whiteboard.tools.GroupToolModel;
import com.elluminate.util.log.LogSupport;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class ProxyTransfer
extends AbstractCommContainer {
    private static final boolean DEBUG = false;
    private static final byte HAVE_SCREEN_PROXIES = -128;
    private static final byte HAVE_TOOL_PROXIES = 64;
    private static final byte HAVE_GROUP_PROXIES = 32;
    private static final byte COUNT_IN_HEADER = 16;
    private static final byte COUNT_MASK = 15;
    private LinkedList screenProxies = null;
    private LinkedList toolProxies = null;
    private LinkedList groupToolProxyLists = null;
    private Long lastGroupObjectID = null;
    private ProxyReceipt proxyReceipt = null;

    public ProxyTransfer(WhiteboardContext context) {
        super(context, "_ProxyTransfer");
    }

    public ProxyTransfer(WhiteboardContext context, WBInputStream istr) {
        this(context);
        try {
            this.streamToObject(istr);
        }
        catch (Exception e) {
            LogSupport.exception((Object)this, (String)"ProxyTransfer", (Throwable)e, (boolean)true);
        }
    }

    public void addScreen(WBNode screenProxy, Integer index) {
        if (this.screenProxies == null) {
            this.screenProxies = new LinkedList();
        }
        this.screenProxies.add(new NodeHolder(screenProxy, index));
    }

    public void addTool(WBNode toolProxy, Integer index) {
        if (toolProxy.getParent() instanceof GroupToolModel) {
            LinkedList group;
            if (this.groupToolProxyLists == null) {
                this.groupToolProxyLists = new LinkedList();
                group = new LinkedList();
                this.groupToolProxyLists.add(group);
                this.lastGroupObjectID = toolProxy.getParentUID();
            } else if (!this.lastGroupObjectID.equals(toolProxy.getParentUID())) {
                group = new LinkedList();
                this.groupToolProxyLists.add(group);
                this.lastGroupObjectID = toolProxy.getParentUID();
            } else {
                group = (LinkedList)this.groupToolProxyLists.getLast();
            }
            group.add(new NodeHolder(toolProxy, index));
        } else {
            if (this.toolProxies == null) {
                this.toolProxies = new LinkedList();
            }
            this.toolProxies.add(new NodeHolder(toolProxy, index));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        try {
            int count;
            this.context.getDataExporter().blockCodecs();
            if (!this.context.isClient()) {
                this.proxyReceipt = new ProxyReceipt(this.context);
            }
            super.streamToObject(istr);
            byte flags = WBUtils.readByte(istr, "ProxyTransfer reads flags");
            int n = count = (flags & 0x10) != 0 ? flags & 0xF : -1;
            if ((flags & 0xFFFFFF80) != 0) {
                this.readProxies(istr, false, count);
                count = -1;
            }
            if ((flags & 0x40) != 0) {
                this.readProxies(istr, true, count);
                count = -1;
            }
            if ((flags & 0x20) != 0) {
                this.readGroupProxies(istr, count);
            }
        }
        catch (IOException ioe) {
            LogSupport.exception((Object)this, (String)"streamToObject", (Throwable)ioe, (boolean)true);
        }
        finally {
            this.context.getDataExporter().unblockCodecs();
        }
        if (this.proxyReceipt != null) {
            this.context.getDataExporter().addProxyReceipt(this.proxyReceipt, istr.getOriginatorId());
        }
        this.proxyReceipt = null;
        return null;
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        byte flags = 0;
        boolean emittedFlags = false;
        if (this.screenProxies == null && this.toolProxies == null && this.groupToolProxyLists == null) {
            throw new Exception("ProxyTransfer with no proxies.");
        }
        try {
            super.objectToStream(ostr);
            if (this.screenProxies != null) {
                flags = (byte)(flags | 0xFFFFFF80);
            }
            if (this.toolProxies != null) {
                flags = (byte)(flags | 0x40);
            }
            if (this.groupToolProxyLists != null) {
                flags = (byte)(flags | 0x20);
            }
            emittedFlags |= this.emitProxyList(ostr, this.screenProxies, flags, emittedFlags);
            emittedFlags |= this.emitProxyList(ostr, this.toolProxies, flags, emittedFlags);
            emittedFlags |= this.emitGroupProxyLists(ostr, this.groupToolProxyLists, flags, emittedFlags);
        }
        catch (IOException ioe) {
            LogSupport.exception((Object)this, (String)"objectToStream", (Throwable)ioe, (boolean)true);
        }
    }

    private boolean emitProxyList(WBOutputStream ostr, List list, byte flags, boolean headerEmitted) throws Exception {
        if (list == null || list.isEmpty()) {
            return false;
        }
        if (headerEmitted) {
            ostr.writeShort(list.size());
        } else if (list.size() <= 15) {
            flags = (byte)(flags | 0x10);
            flags = (byte)(flags | (byte)list.size());
            ostr.writeByte(flags);
        } else {
            ostr.writeByte(flags);
            ostr.writeShort(list.size());
        }
        boolean emittedParentHeader = false;
        ListIterator iter = list.listIterator();
        while (iter.hasNext()) {
            NodeHolder nodeHolder = (NodeHolder)iter.next();
            WBNode node = nodeHolder.node;
            if (!emittedParentHeader) {
                ObjectUID.objectUIDToStream(node.getParentUID(), ostr);
                emittedParentHeader = true;
            }
            int index = nodeHolder.index;
            ostr.writeShort(index);
            WBNodeProxy.nodeToStream(ostr, node);
        }
        return true;
    }

    private void readProxies(WBInputStream istr, boolean tools, int count) throws Exception {
        boolean accept = true;
        if (count < 0) {
            count = WBUtils.readShort(istr, "ProxyTransfer reads proxy count");
        }
        Long parentUID = ObjectUID.objectUIDFromStream(istr);
        WBNode parent = (WBNode)istr.getContext().getObjectManager().getObjectFromMap(parentUID);
        if (parent == null) {
            LogSupport.error((Object)this, (String)"readProxies", (String)("unknown parent (" + WBUtils.uniqueIDAsHex(parentUID) + ") for proxies: " + WBUtils.uniqueIDAsHex(parentUID)));
            accept = false;
        }
        for (int i = 0; i < count; ++i) {
            short index = WBUtils.readShort(istr, "ProxyTransfer reads proxy index");
            WBNodeProxy proxy = (WBNodeProxy)istr.getContext().getNodeProxy().streamToObject(istr);
            if (accept) {
                proxy.setOriginator(istr.getOriginatorId());
                proxy.setAsTool(tools);
                if (!proxy.proxyReparentsNode(parent, index, count) && istr.getContext().getObjectManager().setObjectInMap(proxy, proxy.getObjectID(), false) > 0L) {
                    parent.insert(proxy, index);
                }
                if (this.proxyReceipt == null) continue;
                this.proxyReceipt.add(proxy);
                continue;
            }
            LogSupport.error((Object)this, (String)"readProxies", (String)("reject proxy " + proxy));
        }
    }

    private boolean emitGroupProxyLists(WBOutputStream ostr, List list, byte flags, boolean headerEmitted) throws Exception {
        if (list == null || list.isEmpty()) {
            return false;
        }
        if (headerEmitted) {
            ostr.writeShort(list.size());
        } else if (list.size() <= 15) {
            flags = (byte)(flags | 0x10);
            flags = (byte)(flags | (byte)list.size());
            ostr.writeByte(flags);
        } else {
            ostr.writeShort(list.size());
        }
        for (List proxyList : list) {
            this.emitProxyList(ostr, proxyList, flags, true);
        }
        return true;
    }

    private void readGroupProxies(WBInputStream istr, int count) throws Exception {
        if (count < 0) {
            count = WBUtils.readShort(istr, "ProxyTransfer reads Group Proxy List count");
        }
        int dummyCount = -1;
        for (int i = 0; i < count; ++i) {
            this.readProxies(istr, true, dummyCount);
        }
    }

    @Override
    public String streamToString(WBInputStream istr) {
        StringBuffer buf = new StringBuffer(super.streamToString(istr));
        try {
            while (istr.available() > 0) {
                Long objectUID = ObjectUID.objectUIDFromStream(istr);
                RegisteredTemplate uidObject = (RegisteredTemplate)this.context.getObjectManager().getObjectFromMap(objectUID);
                if (uidObject != null) {
                    buf.append(uidObject.getName());
                } else {
                    LogSupport.error((String)("Cannot find object: " + WBUtils.uniqueIDAsHex(objectUID) + " to process name it.\n" + this.context.getObjectManager().toStaticString()));
                }
                if (istr.available() <= 0) continue;
                buf.append(", ");
            }
        }
        catch (Exception ioe) {
            LogSupport.exception((Object)this, (String)"streamToString", (Throwable)ioe, (boolean)true);
            buf.append("\n  Exception: " + ioe.getMessage());
        }
        return buf.toString();
    }

    class NodeHolder {
        Integer index;
        WBNode node;

        public NodeHolder(WBNode node, Integer index) {
            this.node = node;
            this.index = index;
        }
    }
}

