/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.conference;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.comm.AbstractCommContainer;
import com.elluminate.groupware.whiteboard.conference.ClientIdentification;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.ObjectUID;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.util.log.LogSupport;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;

public class ProxyReceipt
extends AbstractCommContainer {
    private static final String PROXY_RECEIPT = "_ProxyReceipt";
    private static final boolean DEBUG = false;
    private LinkedList uidList = new LinkedList();

    public ProxyReceipt(WhiteboardContext context) {
        super(context, PROXY_RECEIPT);
    }

    public ProxyReceipt(WhiteboardContext context, WBInputStream istr) {
        this(context);
        try {
            this.streamToObject(istr);
        }
        catch (Exception e) {
            LogSupport.exception((Object)this, (String)"ProxyReceipt", (Throwable)e, (boolean)true);
        }
    }

    public void add(WBNode node) {
        this.uidList.add(node.getObjectID());
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
        ostr.writeShort(this.uidList.size());
        for (Long uid : this.uidList) {
            try {
                WBNode node = (WBNode)this.context.getObjectManager().getObjectFromMap(uid);
                ObjectUID.objectUIDToStream(uid, ostr);
                ostr.writeShort(node.getIndex());
            }
            catch (Exception e) {
                ObjectUID.objectUIDToStream(null, ostr);
                ostr.writeShort(-1);
            }
        }
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        HashMap parents = new HashMap();
        super.streamToObject(istr);
        int uidCount = WBUtils.readShort(istr, "ProxyReceipt reads uid count");
        for (int i = 0; i < uidCount; ++i) {
            Long uid = ObjectUID.objectUIDFromStream(istr);
            short index = WBUtils.readShort(istr, "ProxyReceipt reads node index");
            try {
                WBNode parent;
                WBNode node = (WBNode)this.context.getObjectManager().getObjectFromMap(uid);
                if (node == null || node.getIndex() == index || (parent = node.getParent()) == null) continue;
                LinkedList nodeList = (LinkedList)parents.get(parent);
                if (nodeList == null) {
                    nodeList = new LinkedList();
                    parents.put(parent, nodeList);
                }
                NodeEntry entry = new NodeEntry(node, index);
                nodeList.add(entry);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        for (LinkedList nodeList : parents.values()) {
            Collections.sort(nodeList);
            for (NodeEntry entry : nodeList) {
                if (entry.index > entry.node.getIndex()) {
                    entry.index = (short)(entry.index + 1);
                }
                boolean wasSelected = false;
                entry.node.setOriginator(ClientIdentification.SERVER_ID);
                if (entry.node.isTool()) {
                    wasSelected = ((AbstractToolModel)entry.node).isSelected();
                    ((AbstractToolModel)entry.node).setZOrder(entry.index);
                }
                if (entry.node.getIndex() == entry.index) continue;
                entry.node.getParent().insert(entry.node, entry.index);
                if (!wasSelected) continue;
                entry.node.findScreenParent().selectTool((AbstractToolModel)entry.node);
            }
        }
        return null;
    }

    @Override
    public String streamToString(WBInputStream istr) {
        StringBuffer buf = new StringBuffer(super.streamToString(istr));
        try {
            int uidCount = WBUtils.readShort(istr, "ProxyReceipt reads uid count");
            for (int i = 0; i < uidCount; ++i) {
                Long uid = ObjectUID.objectUIDFromStream(istr);
                short index = WBUtils.readShort(istr, "ProxyReceipt receipts node index");
                buf.append(this.getName() + " receipts node: " + WBUtils.objectName(uid, this.context) + ", at index: " + index);
            }
        }
        catch (Exception e) {
            buf.append(this.getName() + " gets Exception: " + e.getMessage());
        }
        return buf.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName() + ", entries: " + this.uidList.size() + "\n");
        for (Long uid : this.uidList) {
            try {
                WBNode node = (WBNode)this.context.getObjectManager().getObjectFromMap(uid);
                buf.append(WBUtils.uniqueIDAsHex(uid) + ", node: " + node + ", index: " + node.getIndex() + "\n");
            }
            catch (Exception ex) {
                buf.append(WBUtils.uniqueIDAsHex(uid) + ", Cannot Resolve\n");
            }
        }
        return buf.toString();
    }

    class NodeEntry
    implements Comparable {
        WBNode node;
        short index;

        public NodeEntry(WBNode node, short index) {
            this.node = node;
            this.index = index;
        }

        public int compareTo(Object o) {
            return this.index - ((NodeEntry)o).index;
        }

        public String toString() {
            return "Node: " + this.node + ", index: " + this.index;
        }
    }
}

