/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.conference;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.WhiteboardProtocol;
import com.elluminate.groupware.whiteboard.conference.ClientIdentification;
import com.elluminate.groupware.whiteboard.conference.DataBlock;
import com.elluminate.groupware.whiteboard.conference.ParticipantData;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.MediaData;
import com.elluminate.groupware.whiteboard.dataModel.ObjectUID;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.util.log.LogSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class ItemData {
    private static final boolean DEBUG = false;
    private static final int REQUIRED_SPACE = 12;
    private static final int SCREEN_UID_BYTES = 8;
    public static final int UID_REQUIRED_SPACE = 20;
    static final int QUENCH_ITEM_LENGTH = 3;
    private Short key = null;
    private ChannelDataEvent cde = null;
    private RegisteredTemplate item = null;
    private WBInputStream byteStream = null;
    ParticipantData data = null;
    private StackTraceElement[] constructorStack = null;
    private boolean disposed = false;
    private boolean removedFromInTransit = true;
    private LinkedList<ParticipantData> inTransitList = new LinkedList();
    private long serial = 0L;
    private static long SERIAL = 0L;
    private byte[] inBuffer = null;
    private byte[] outBuffer = null;
    private ArrayList<byte[]> blocks = new ArrayList();
    int itemLength = 0;
    int itemDataSent = 0;
    int itemByteOffset = 0;
    short revision = 0;
    boolean needsQuench = false;
    Long screenUID = null;
    boolean firstBlock = true;
    boolean noteDataDispose = false;
    Short originator = null;
    Short clientId = null;
    WhiteboardContext context = null;

    public ItemData(Short key, WhiteboardContext context, ParticipantData data, ChannelDataEvent cde) {
        this.serial = SERIAL++;
        this.key = key;
        this.context = context;
        this.data = data;
        this.cde = (ChannelDataEvent)cde.clone();
        this.screenUID = null;
        this.firstBlock = true;
    }

    public boolean readItem(WBInputStream istr) {
        boolean complete = false;
        this.inBuffer = null;
        try {
            int lengthInBlock;
            byte b = istr.readByte();
            if (b == -2) {
                this.dispose();
                return true;
            }
            if (b == -1) {
                b = istr.readByte();
                this.inBuffer = this.firstBlock ? new byte[istr.available() - 8] : new byte[istr.available()];
            } else {
                lengthInBlock = (b & 0x7F) << 8;
                this.inBuffer = new byte[lengthInBlock |= istr.readByte() & 0xFF];
                complete = true;
            }
            if (this.firstBlock) {
                this.screenUID = ObjectUID.longObjectUIDFromStream(istr);
                this.originator = istr.getOriginatorId();
                this.firstBlock = false;
                if (this.screenUID != null) {
                    this.noteDataDispose = true;
                    try {
                        this.context.getDataExporter().noteDataInTransit(this.screenUID, istr.getOriginatorId(), this.clientId, this);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
            lengthInBlock = istr.read(this.inBuffer);
            this.blocks.add(this.inBuffer);
            this.itemLength += this.inBuffer.length;
        }
        catch (IOException ioe) {
            LogSupport.exception((Object)this, (String)"readItem", (Throwable)ioe, (boolean)true);
            throw new RuntimeException(ioe.getMessage());
        }
        return complete;
    }

    public WBInputStream getDataStream() {
        if (this.byteStream == null) {
            if (this.blocks != null) {
                int offset = 0;
                this.inBuffer = new byte[this.itemLength];
                for (byte[] block : this.blocks) {
                    System.arraycopy(block, 0, this.inBuffer, offset, block.length);
                    offset += block.length;
                }
                this.blocks.clear();
                this.blocks = null;
            }
            this.byteStream = WBInputStream.inputStreamFactory(new ByteArrayInputStream(this.inBuffer), this.context, this.cde);
        }
        return this.byteStream;
    }

    public WBInputStream getStreamCopy() {
        if (this.inBuffer != null) {
            Short originator = ClientIdentification.CLIENT_LOCAL;
            short address = this.context.getIDProcessor().getClientAddress(originator);
            byte cmd = 7;
            ChannelDataEvent cde = ChannelDataEvent.getInstance((Object)this, (short)address, (byte)cmd);
            WBInputStream str = WBInputStream.inputStreamFactory(new ByteArrayInputStream(this.inBuffer), this.context, cde);
            str.setAddress(originator);
            return str;
        }
        return null;
    }

    public boolean isQuenched() {
        return this.blocks == null || this.blocks.isEmpty() || this.disposed;
    }

    public ItemData(RegisteredTemplate item, Short key, Long screenUID, Short clientId, ParticipantData data) {
        if (item == null) {
            throw new RuntimeException("Null item to ItemData Constructor.");
        }
        this.serial = SERIAL++;
        this.item = item;
        this.context = item.getContext();
        this.screenUID = screenUID;
        this.data = data;
        this.generateBuffer();
        this.key = key;
        this.clientId = clientId;
        if (screenUID != null) {
            this.noteDataDispose = true;
            try {
                this.context.getDataExporter().noteDataInTransit(screenUID, null, clientId, this);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public void regenerateItem() {
        this.needsQuench = true;
        this.dropOutputBuffer();
        this.generateBuffer();
    }

    private void generateBuffer() {
        this.revision = this.item instanceof WBNode ? ((WBNode)this.item).getRevision() : (short)0;
        this.outBuffer = this.context.getItemCache().refBuffer(this.item, this.revision);
        if (this.outBuffer == null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                WBOutputStream outStr = new WBOutputStream(out, this.context);
                this.item.objectToStream(outStr);
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"generateBuffer", (Throwable)ex, (boolean)true);
            }
            this.outBuffer = out.toByteArray();
            this.context.getItemCache().putBuffer(this.item, this.outBuffer);
        }
        this.itemByteOffset = 0;
        this.itemDataSent = 0;
        this.firstBlock = true;
    }

    public short getRevision() {
        return this.revision;
    }

    public Long getScreenUID() {
        return this.screenUID;
    }

    public boolean addItemToBlock(DataBlock dataBlock) {
        int pad;
        DataBlock.DataBlockEntry entry;
        boolean emittedLength = false;
        if (this.needsQuench) {
            this.addItemQuench(dataBlock);
            this.needsQuench = false;
        }
        if ((entry = dataBlock.getDataBlockEntry()).getSpace() < this.headerSpace()) {
            return false;
        }
        entry.putShort(this.getKey());
        int n = pad = this.firstBlock ? 8 : 0;
        if (entry.getSpace() < this.itemLengthRemaining() + 2 + pad) {
            entry.putByte((byte)-1);
            entry.putByte((byte)-1);
        } else {
            entry.putShort((short)this.itemLengthRemaining());
        }
        if (this.firstBlock) {
            if (this.screenUID == null || !(this.item instanceof WBNode) && !(this.item instanceof MediaData)) {
                entry.putInt(0);
                entry.putInt(0);
            } else if ((this.screenUID & Long.MIN_VALUE) != 0L) {
                entry.putLong(this.screenUID);
            } else {
                entry.putInt(ObjectUID.decodeClientId(this.screenUID));
                entry.putInt(ObjectUID.decodeSequence(this.screenUID));
            }
            this.firstBlock = false;
        }
        int emitted = entry.putBytes(this.outBuffer, this.itemByteOffset);
        this.itemByteOffset += emitted;
        this.itemDataSent += emitted;
        boolean result = this.itemLengthRemaining() <= 0;
        return result;
    }

    public int headerSpace() {
        int pad = this.firstBlock ? 8 : 0;
        return 12 + pad;
    }

    private int itemLengthRemaining() {
        if (this.outBuffer == null) {
            Thread.dumpStack();
        }
        int left = this.outBuffer.length - this.itemDataSent;
        return left;
    }

    public boolean addItemQuench(DataBlock dataBlock) {
        DataBlock.DataBlockEntry entry = dataBlock.getDataBlockEntry();
        if (entry.getSpace() < 3) {
            return false;
        }
        entry.putShort(this.getKey());
        entry.putByte((byte)-2);
        return true;
    }

    private void dropOutputBuffer() {
        if (this.outBuffer != null) {
            this.context.getItemCache().disposeBuffer(this.item, this.revision);
            this.outBuffer = null;
        }
    }

    private void dropInput() {
        this.firstBlock = true;
        this.inBuffer = null;
        if (this.byteStream != null) {
            try {
                this.byteStream.close();
            }
            catch (Exception e) {
                LogSupport.exception((Object)this, (String)"dispose", (Throwable)e, (boolean)true);
            }
            this.byteStream = null;
        }
        if (this.blocks != null) {
            this.blocks.clear();
        }
    }

    public void dispose() {
        Iterator pdIter = this.inTransitList.iterator();
        while (pdIter.hasNext()) {
            ParticipantData pd = (ParticipantData)pdIter.next();
            pdIter.remove();
            pd.doneDataInTransit(this);
        }
        this.dropOutputBuffer();
        this.dropInput();
        this.blocks = null;
        if (this.screenUID != null && this.noteDataDispose) {
            try {
                this.context.getDataExporter().doneDataInTransit(this.screenUID, this.originator, this.clientId, false, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.cde != null) {
            this.cde.dispose();
            this.cde = null;
        }
        this.disposed = true;
    }

    public Short getKey() {
        return this.key;
    }

    public RegisteredTemplate getItem() {
        return this.item;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Item #" + this.key + ", created from: " + (this.item == null ? "Stream" : this.item.toString()) + ", originator: " + this.originator + ", client: " + this.clientId + ", serial: " + this.serial + ", Disposed: " + this.disposed + ", Removed: " + this.removedFromInTransit + "\n");
        return buf.toString();
    }

    public String toFullString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.toString());
        if (this.inBuffer != null) {
            buf.append("\nInBuffer: ");
            buf.append(WhiteboardProtocol.arrayToString(this.inBuffer));
        }
        if (this.outBuffer != null) {
            buf.append("\nOutBuffer: ");
            buf.append(WhiteboardProtocol.arrayToString(this.outBuffer));
        }
        buf.append("\n serial: " + this.serial + ", Client: " + this.data.getClientId() + ", Disposed: " + this.disposed + ", Removed: " + this.removedFromInTransit);
        return buf.toString();
    }

    public boolean wasDisposed() {
        return this.disposed;
    }

    long getSerial() {
        return this.serial;
    }

    public String getConstructorStackTrace() {
        StringBuilder str = new StringBuilder();
        str.append("\nConstruct: serial: " + this.serial + ", clientId: ");
        str.append(this.data.getClientId());
        str.append(", key: ");
        str.append(this.key);
        str.append("\n");
        for (int i = 0; i < this.constructorStack.length; ++i) {
            str.append(this.constructorStack[i].toString());
            str.append('\n');
        }
        return str.toString();
    }

    public void noteInTransitFor(ParticipantData participantData) {
        this.inTransitList.add(participantData);
    }
}

