/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.conference;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.ObjectUID;
import com.elluminate.groupware.whiteboard.interfaces.UniqueObjectID;
import java.io.IOException;

public class DeleteUID {
    Long UID;
    short revision;
    WhiteboardContext context;

    public DeleteUID(Long UID, short revision, WhiteboardContext context) {
        this.UID = UID;
        this.revision = revision;
        this.context = context;
    }

    public DeleteUID(UniqueObjectID object, WhiteboardContext context) {
        if (object == null || object.getObjectID() == null) {
            throw new RuntimeException("Uninitialized UniqueObjectID sent to DeleteUID.");
        }
        this.UID = object.getObjectID();
        this.revision = object.getRevision();
        this.context = context;
    }

    public DeleteUID(WBInputStream istr) throws IOException {
        this.context = istr.getContext();
        this.UID = ObjectUID.objectUIDFromStream(istr);
    }

    public void objectToStream(WBOutputStream ostr) throws IOException {
        ObjectUID.objectUIDToStream(this.UID, ostr);
    }

    public Long getUID() {
        return this.UID;
    }

    public short getRevision() {
        return this.revision;
    }

    public String toString() {
        return "DeleteUID: revision: " + this.revision + "\n   Node: " + WBUtils.objectName(this.UID, this.context);
    }
}

