/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.conference;

import com.elluminate.groupware.whiteboard.ShutdownListener;
import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.conference.ClientIdentification;
import com.elluminate.groupware.whiteboard.conference.DataCodec;
import com.elluminate.groupware.whiteboard.conference.ItemData;
import com.elluminate.groupware.whiteboard.conference.NoteScreenViewing;
import com.elluminate.groupware.whiteboard.conference.ParticipantData;
import com.elluminate.groupware.whiteboard.conference.ProxyReceipt;
import com.elluminate.groupware.whiteboard.conference.ScreenExportData;
import com.elluminate.groupware.whiteboard.conference.ViewedScreens;
import com.elluminate.groupware.whiteboard.conference.ViewedScreensListener;
import com.elluminate.groupware.whiteboard.conference.Viewing;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.DataModel;
import com.elluminate.groupware.whiteboard.dataModel.MediaData;
import com.elluminate.groupware.whiteboard.dataModel.MediaEvent;
import com.elluminate.groupware.whiteboard.dataModel.MediaID;
import com.elluminate.groupware.whiteboard.dataModel.MediaItem;
import com.elluminate.groupware.whiteboard.dataModel.MediaListener;
import com.elluminate.groupware.whiteboard.dataModel.MediaListenersListener;
import com.elluminate.groupware.whiteboard.dataModel.ObjectUID;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.dataModel.Validator;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.dataModel.WBNodeContainer;
import com.elluminate.groupware.whiteboard.dataModel.WBNodeProxy;
import com.elluminate.groupware.whiteboard.interfaces.StreamableObject;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ConnectionEvent;
import com.elluminate.jinx.Transceiver;
import com.elluminate.util.Debug;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.ShortList;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DataExporter
implements MediaListener,
MediaListenersListener,
ViewedScreensListener {
    private static final short END_OF_SCREENLIST_MARKER = -1;
    public static final boolean DEBUG_MEDIA = false;
    private LightweightTimer aggregationTimer = null;
    private NoteScreenViewing screenViewingAggregation = null;
    private LinkedList<Viewing> viewList = null;
    private HashMap<Short, ParticipantData> participants;
    private int blocker = 0;
    private HashSet blockedCodecs = new HashSet();
    private ViewedScreens viewedScreens;
    private Long leavingScreenUID = null;
    private Long joiningScreenUID = null;
    private WhiteboardContext context;
    private ViewListProcessor viewListProcessor;

    public DataExporter(WhiteboardContext context) {
        this.context = context;
        this.participants = new HashMap();
        this.viewedScreens = new ViewedScreens(context);
        context.getMediaCache().addMediaListener(this);
        this.viewedScreens.addViewedListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockCodecs() {
        Debug.lockEnter((Object)this, (String)"DataExporter.blockCodecs", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            ++this.blocker;
        }
        Debug.lockLeave((Object)this, (String)"DataExporter.blockCodecs", (String)"DataModel", (Object)this.context.getDataModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unblockCodecs() {
        Debug.lockEnter((Object)this, (String)"DataExporter.unblockCodecs", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            --this.blocker;
            if (this.blocker < 0) {
                Thread.dumpStack();
            }
            Iterator iter = this.blockedCodecs.iterator();
            while (!this.isBlocked() && iter.hasNext()) {
                DataCodec codec = (DataCodec)iter.next();
                codec.doWork();
                iter.remove();
            }
        }
        Debug.lockLeave((Object)this, (String)"DataExporter.unblockCodecs", (String)"DataModel", (Object)this.context.getDataModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteBlockedCodec(DataCodec codec) {
        Debug.lockEnter((Object)this, (String)"DataExporter.noteBlockedCodec", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            this.blockedCodecs.add(codec);
        }
        Debug.lockLeave((Object)this, (String)"DataExporter.noteBlockedCodec", (String)"DataModel", (Object)this.context.getDataModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChannelSpeed(ConnectionEvent event) {
        Debug.lockEnter((Object)this, (String)"DataExporter.setChannelSpeed", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            Transceiver transceiver = event.getTransceiver();
            Short clientAddress = ShortList.get((short)event.getAddress());
            Short clientId = this.context.getIDProcessor().getClientId(clientAddress);
            ParticipantData data = this.getParticipantData(clientId);
            if (data != null) {
                data.getDataCodec().evaluateSpeed(transceiver);
            }
        }
        Debug.lockLeave((Object)this, (String)"DataExporter.setChannelSpeed", (String)"DataModel", (Object)this.context.getDataModel());
    }

    public boolean isBlocked() {
        return this.blocker != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParticipant(Short clientId, Collection screens, Collection tools, Collection proxySet) {
        Debug.lockEnter((Object)this, (String)"DataExporter.addParticipant", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            ParticipantData data = this.getParticipantData(clientId);
            if (data == null) {
                data = new ParticipantData(this.context, screens, tools, proxySet, clientId);
                this.participants.put(clientId, data);
            } else {
                data.initialize(screens, tools, proxySet);
            }
            data.onLine();
        }
        Debug.lockLeave((Object)this, (String)"DataExporter.addParticipant", (String)"DataModel", (Object)this.context.getDataModel());
    }

    public void clearMediaCounts(Short clientId) {
        ParticipantData data = this.getParticipantData(clientId);
        if (data != null) {
            data.clearMediaCounts();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offLineParticipant(Short clientAddress) {
        Debug.lockEnter((Object)this, (String)"DataExporter.offLineParticipant", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            Short clientId = this.context.getIDProcessor().getClientId(clientAddress);
            ParticipantData data = this.getParticipantData(clientId);
            if (data != null) {
                data.offLine();
            }
            if (clientId != null && clientId.equals(ClientIdentification.CLIENT_LOCAL)) {
                this.viewedScreens.clear();
            }
        }
        Debug.lockLeave((Object)this, (String)"DataExporter.offLineParticipant", (String)"DataModel", (Object)this.context.getDataModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParticipant(Short clientId) {
        Debug.lockEnter((Object)this, (String)"DataExporter.removeParticipant", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            ParticipantData data = this.getParticipantData(clientId);
            if (data != null) {
                data.dispose();
                if (this.participants.remove(clientId) == null) {
                    LogSupport.message((Object)this, (String)"removeParticipant", (String)("client not removed from participants: " + clientId));
                }
            }
        }
        Debug.lockLeave((Object)this, (String)"DataExporter.removeParticipant", (String)"DataModel", (Object)this.context.getDataModel());
    }

    private void addScreen(ParticipantData[] datas, WBNode node, boolean createProxy) {
        WBNode parentScreen = node.getParent();
        if (node instanceof ScreenRoot) {
            node.setRoot((ScreenRoot)node);
        } else {
            node.setRoot(node.getParent().getRoot());
        }
        node.propagateRooting();
        for (int i = 0; i < datas.length; ++i) {
            ParticipantData data = datas[i];
            if (!data.isOnline()) continue;
            if (node instanceof WBNodeContainer) {
                data.getContainersToSend().put(node.getObjectID(), node);
            }
            if (node instanceof ScreenRoot || !data.isContainerSent(node.getParent())) continue;
            node.setNodeReparenting(false);
            if (parentScreen instanceof ScreenModel) {
                ScreenExportData sExport = data.getScreenExportData(parentScreen, true);
                if (sExport.addScreenProxy(node)) continue;
                sExport.cleanExportData();
                continue;
            }
            Validator.logAlways("Added screen with no parent: " + WBUtils.objectName(node));
        }
        if (!node.isReparenting()) {
            WBNode child;
            Iterator iter = node.iterateScreens();
            while (iter.hasNext()) {
                child = (WBNode)iter.next();
                if (!(child instanceof ScreenModel)) continue;
                this.addScreen(datas, child, false);
            }
            iter = node.iterateTools();
            while (iter.hasNext()) {
                child = (WBNode)iter.next();
                if (!(child instanceof AbstractToolModel)) continue;
                this.addTool(datas, child, false);
            }
        }
        node.setNodeReparenting(false);
    }

    private void removeScreen(ParticipantData[] datas, WBNode node, Short originatorId, boolean supressDelete) {
        WBNode child;
        node.setOriginator();
        boolean newSupressDelete = node.autoDeletesChildren() || supressDelete;
        Iterator iter = node.iterateScreens();
        while (iter.hasNext()) {
            child = (WBNode)iter.next();
            if (!(child instanceof ScreenModel)) continue;
            this.removeScreen(datas, child, originatorId, newSupressDelete);
        }
        iter = node.iterateTools();
        while (iter.hasNext()) {
            child = (WBNode)iter.next();
            if (!(child instanceof AbstractToolModel)) continue;
            this.removeTool(datas, child, originatorId, newSupressDelete);
        }
        for (int i = 0; i < datas.length; ++i) {
            ParticipantData data;
            data.addDeletion(node, originatorId.equals((data = datas[i]).getClientId()) || supressDelete);
            ScreenExportData sExport = data.getScreenProxyData(node.getParent());
            if (sExport == null) continue;
            sExport.removeScreenProxy(node);
            sExport.removeAttributes(node);
        }
        node.removeFromConference();
    }

    private void addTool(ParticipantData[] datas, WBNode tool, boolean createProxy) {
        ScreenModel screen = tool.findScreenParent();
        if (screen == null) {
            Validator.logAlways("DataExporter.addTool: no screenParent for: " + WBUtils.objectName(tool));
            return;
        }
        for (int i = 0; i < datas.length; ++i) {
            ScreenExportData screenExportData;
            ParticipantData data = datas[i];
            if (!data.isOnline()) continue;
            if (tool instanceof WBNodeContainer) {
                data.getContainersToSend().put(tool.getObjectID(), tool);
            }
            if (tool.isReparenting()) {
                if (!data.isContainerSent(tool.getParent()) || (screenExportData = data.getScreenExportData(tool, true)).addTool(tool, createProxy)) continue;
                screenExportData.cleanExportData();
                continue;
            }
            if (tool.isProxy()) {
                WBNode toolParent = tool.getParent();
                if (!toolParent.isContainer() || !data.isContainerSent(toolParent) || (screenExportData = data.getScreenExportData(tool, true)).addToolProxy(tool)) continue;
                screenExportData.cleanExportData();
                continue;
            }
            screenExportData = data.getScreenExportData(tool, true);
            boolean childrenReparenting = tool.isReparenting();
            screenExportData.addTool(tool, createProxy);
            screenExportData.cleanExportData();
        }
        Iterator iter = tool.iterateTools();
        while (iter.hasNext()) {
            WBNode node = (WBNode)iter.next();
            if (!(node instanceof AbstractToolModel)) continue;
            this.addTool(datas, node, false);
        }
    }

    private void removeTool(ParticipantData[] datas, WBNode tool, Short originatorId, boolean supressDelete) {
        tool.setOriginator();
        boolean newSupressDelete = tool.autoDeletesChildren() || supressDelete;
        Iterator iter = tool.iterateTools();
        while (iter.hasNext()) {
            WBNode child = (WBNode)iter.next();
            if (!(child instanceof AbstractToolModel)) continue;
            this.removeTool(datas, child, originatorId, newSupressDelete);
        }
        for (int i = 0; i < datas.length; ++i) {
            ParticipantData data = datas[i];
            ScreenExportData sExport = data.getScreenExportData(tool.getScreenParent(), false);
            if (sExport != null) {
                sExport.removeTool(tool);
            }
            data.addDeletion(tool, data.getClientId().equals(originatorId) || newSupressDelete);
        }
        tool.removeFromConference();
    }

    private void addAttribute(ParticipantData[] datas, AbstractAttribute attribute) {
        WBNode node = attribute.getParent();
        ScreenModel screen = node.findScreenParent();
        for (int i = 0; i < datas.length; ++i) {
            ParticipantData data = datas[i];
            if (!data.isOnline()) continue;
            ScreenExportData screenExportData = data.getScreenExportData(screen, true);
            screenExportData.addAttribute(attribute);
        }
    }

    private void removeAttribute(ParticipantData[] datas, AbstractAttribute attribute) {
        WBNode node = attribute.getParent();
        ScreenModel screen = node.findScreenParent();
        LogSupport.message((Object)this, (String)"removeAttribute", (String)("data exporter removing attribute: " + attribute + ", on parent: " + node));
        for (int i = 0; i < datas.length; ++i) {
            ParticipantData data = datas[i];
            ScreenExportData screenExportData = data.getScreenExportData(screen, false);
            if (screenExportData != null && !screenExportData.removeAttribute(attribute)) continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParticipantData getParticipantData(Short clientId) {
        try {
            Debug.lockEnter((Object)this, (String)"DataExporter.getParticipantData", (String)"DataModel", (Object)this.context.getDataModel());
            DataModel dataModel = this.context.getDataModel();
            synchronized (dataModel) {
                ParticipantData participantData = this.participants.get(clientId);
                return participantData;
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"DataExporter.getParticipantData", (String)"DataModel", (Object)this.context.getDataModel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveData(ChannelDataEvent cde) {
        Debug.lockEnter((Object)this, (String)"DataExporter.receiveData", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            Short clientId = this.context.getIDProcessor().getClientId(ShortList.get((short)cde.getSourceAddress()));
            ParticipantData data = this.getParticipantData(clientId);
            if (data == null) {
                this.addParticipant(clientId, null, null, null);
            } else {
                DataCodec codec = data.getDataCodec();
                codec.processChannelData(cde);
            }
        }
        Debug.lockLeave((Object)this, (String)"DataExporter.receiveData", (String)"DataModel", (Object)this.context.getDataModel());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("\n\nDataExporter:");
        if (this.participants != null) {
            for (Short client : this.participants.keySet()) {
                buf.append("\n Participant: " + client + this.participants.get(client));
            }
        }
        if (buf.length() > 0) {
            buf.append("\n");
        }
        buf.append(this.viewedScreens.toString());
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToConference(RegisteredTemplate template) {
        Debug.lockEnter((Object)this, (String)"DataExporter.addToConference1", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            if (this.context.getClientList() != null) {
                if (template.getOriginator() == null) {
                    template.setOriginator();
                }
                this.addToConference(template, template.getOriginator());
            }
        }
        Debug.lockLeave((Object)this, (String)"DataExporter.addToConference1", (String)"DataModel", (Object)this.context.getDataModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToConference(RegisteredTemplate template, Short originatorId) {
        ParticipantData[] datas;
        if (!this.context.isPlayback() && (datas = this.getDistributionDatas(template, originatorId)).length > 0) {
            if (template instanceof WBNode) {
                ((WBNode)template).propagateRooting();
                ((WBNode)template).propagateInConference();
            }
            this.blockCodecs();
            try {
                Debug.lockEnter((Object)this, (String)"DataExporter.addToConference2", (String)"DataModel", (Object)this.context.getDataModel());
                DataModel dataModel = this.context.getDataModel();
                synchronized (dataModel) {
                    this.addToConference(template, datas);
                }
            }
            finally {
                Debug.lockLeave((Object)this, (String)"DataExporter.addToConference2", (String)"DataModel", (Object)this.context.getDataModel());
                for (int i = 0; i < datas.length; ++i) {
                    datas[i].getDataCodec().doWork();
                }
                this.unblockCodecs();
            }
        }
    }

    private void addToConference(RegisteredTemplate template, ParticipantData[] datas) {
        boolean createProxies = true;
        if (template instanceof WBNode) {
            WBNode node = (WBNode)template;
            node.setInConference(true);
            node.setOriginator();
            if (node.isTool()) {
                this.addTool(datas, node, createProxies);
            } else {
                this.addScreen(datas, node, createProxies);
            }
        } else if (template instanceof AbstractAttribute) {
            this.addAttribute(datas, (AbstractAttribute)template);
        } else {
            Validator.logAlways("DataExporter.addToConference: cannot add: " + template.getName());
        }
    }

    private ParticipantData[] getDistributionDatas(RegisteredTemplate template, Short originatorId) {
        ScreenModel screen = null;
        RegisteredTemplate nodeTemplate = template;
        if (template instanceof AbstractAttribute) {
            nodeTemplate = ((AbstractAttribute)template).getParent();
        }
        if (nodeTemplate instanceof ScreenModel) {
            screen = (ScreenModel)nodeTemplate;
        } else if (nodeTemplate instanceof AbstractToolModel) {
            screen = ((AbstractToolModel)nodeTemplate).findScreenParent();
        } else if (nodeTemplate instanceof WBNodeProxy) {
            screen = ((WBNodeProxy)nodeTemplate).isTool() ? ((WBNodeProxy)nodeTemplate).findScreenParent() : (ScreenModel)((WBNodeProxy)nodeTemplate).getParent();
        }
        if (screen == null) {
            if (!(nodeTemplate instanceof WBNode) || ((WBNode)nodeTemplate).isConferenceNode()) {
                LogSupport.error((Object)this, (String)"getDistributionDatas", (String)("template: " + template + ", has null screen"));
            }
            return new ParticipantData[0];
        }
        Short[] participantIds = screen.getDistribution();
        ArrayList<ParticipantData> participants = new ArrayList<ParticipantData>(participantIds.length);
        for (int i = 0; i < participantIds.length; ++i) {
            ParticipantData participantData;
            if (participantIds[i].equals(originatorId) || (participantData = this.getParticipantData(participantIds[i])) == null) continue;
            participants.add(participantData);
        }
        ParticipantData[] datas = new ParticipantData[participants.size()];
        datas = participants.toArray(datas);
        return datas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProxyReceipt(ProxyReceipt proxyReceipt, Short clientId) {
        this.blockCodecs();
        try {
            Debug.lockEnter((Object)this, (String)"DataExporter.removeFromConference1", (String)"DataModel", (Object)this.context.getDataModel());
            DataModel dataModel = this.context.getDataModel();
            synchronized (dataModel) {
                ParticipantData data = this.getParticipantData(clientId);
                if (data != null) {
                    data.addProxyReceipt(proxyReceipt);
                }
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"DataExporter.removeFromConference1", (String)"DataModel", (Object)this.context.getDataModel());
            this.unblockCodecs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromConference(RegisteredTemplate template) {
        Debug.lockEnter((Object)this, (String)"DataExporter.removeFromConference1", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            if (this.context.getClientList() != null) {
                if (template.getOriginator() == null) {
                    template.setOriginator();
                }
                this.removeFromConference(template, template.getOriginator());
            }
        }
        Debug.lockLeave((Object)this, (String)"DataExporter.removeFromConference1", (String)"DataModel", (Object)this.context.getDataModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeFromConference(RegisteredTemplate template, Short originatorId) {
        if (this.context.isPlayback()) {
            return;
        }
        ParticipantData[] datas = this.getDistributionDatas(template, ScreenModel.BROADCAST_ADDRESS);
        this.blockCodecs();
        try {
            Debug.lockEnter((Object)this, (String)"DataExporter.removeFromConference2", (String)"DataModel", (Object)this.context.getDataModel());
            DataModel dataModel = this.context.getDataModel();
            synchronized (dataModel) {
                if (template instanceof WBNode) {
                    WBNode node = (WBNode)template;
                    if (node.isReparenting()) return;
                    if (!node.isConferenceNode()) {
                        return;
                    }
                    if (node.isTool()) {
                        this.removeTool(datas, node, originatorId, false);
                    } else {
                        this.removeScreen(datas, node, originatorId, false);
                    }
                } else if (template instanceof AbstractAttribute) {
                    this.removeAttribute(datas, (AbstractAttribute)template);
                } else {
                    Validator.logAlways("DataExporter.removeFromConference: Unknown template: " + template.getName());
                }
                return;
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"DataExporter.removeFromConference2", (String)"DataModel", (Object)this.context.getDataModel());
            int i = 0;
            while (true) {
                if (i >= datas.length) {
                    this.unblockCodecs();
                }
                datas[i].getDataCodec().doWork();
                ++i;
            }
        }
    }

    public void noteDataInTransit(Long mediaID, Short originator, Short clientId, ItemData itemData) {
        if (this.context.getStatus() == null) {
            return;
        }
        if (this.context.getStatus() != null && mediaID != null) {
            if ((mediaID & Long.MIN_VALUE) == 0L) {
                this.addScreenReference(mediaID, originator, clientId, itemData);
            } else {
                MediaID id = new MediaID(mediaID);
                this.context.getMediaCache().incrementInTransit(id);
                HashSet screenUIDSet = this.context.getMediaCache().getScreenUIDSet(mediaID);
                if (screenUIDSet != null) {
                    for (Long screenUID : screenUIDSet) {
                        this.addScreenReference(screenUID, originator, clientId, itemData);
                    }
                } else {
                    WBUtils.timedLog("DataExporter", "noteDataInTransit, no screens for mediaItem: " + WBUtils.uniqueLongID(mediaID));
                }
            }
        }
    }

    private void addScreenReference(Long screenUID, Short originator, Short clientId, ItemData itemData) {
        if (clientId != null) {
            ParticipantData data = this.getParticipantData(clientId);
            if (data != null) {
                data.noteDataInTransit(itemData);
            }
        } else {
            try {
                ScreenModel screen = (ScreenModel)this.context.getObjectManager().getObjectFromMap(screenUID);
                Short[] distribution = screen.getDistribution();
                for (int i = 0; i < distribution.length; ++i) {
                    ParticipantData data;
                    if (distribution[i].equals(this.context.getIDProcessor().getMyId()) || distribution[i].equals(originator) || (data = this.getParticipantData(distribution[i])) == null) continue;
                    data.noteDataInTransit(itemData);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public void doneDataInTransit(Long mediaID, Short originator, Short clientId, boolean allRefs, ItemData itemData) {
        if (mediaID == null || this.context.getStatus() == null) {
            return;
        }
        if ((mediaID & Long.MIN_VALUE) == 0L) {
            this.removeScreenReference(mediaID, originator, clientId, allRefs, itemData, mediaID);
        } else {
            MediaID id = new MediaID(mediaID);
            if (!this.context.getMediaCache().isInTransit(id)) {
                return;
            }
            this.context.getMediaCache().decrementInTransit(id);
            HashSet screenUIDSet = this.context.getMediaCache().getScreenUIDSet(mediaID);
            if (screenUIDSet != null) {
                for (Long screenUID : screenUIDSet) {
                    this.removeScreenReference(screenUID, originator, clientId, allRefs, itemData, mediaID);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransitRefs(Long screenUID) {
        this.removeScreenReference(screenUID, null, null, true, null, screenUID);
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            for (ParticipantData data : this.participants.values()) {
                data.removeTransitRefs();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTransitRefs() {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            for (ParticipantData data : this.participants.values()) {
                data.invalidateTransitEntries();
            }
        }
    }

    private void removeScreenReference(Long screenUID, Short originator, Short clientId, boolean allRefs, ItemData itemData, Long mediaID) {
        if (clientId != null) {
            ParticipantData data = this.getParticipantData(clientId);
            if (data != null) {
                if (itemData == null) {
                    itemData = data.getMediaItem(mediaID);
                }
                data.doneDataInTransit(itemData);
            }
        } else {
            try {
                ScreenModel screen = (ScreenModel)this.context.getObjectManager().getObjectFromMap(screenUID);
                Short[] distribution = screen.getDistribution();
                for (int i = 0; i < distribution.length; ++i) {
                    if (!allRefs && (distribution[i].equals(this.context.getIDProcessor().getMyId()) || distribution[i].equals(originator))) continue;
                    ParticipantData data = this.getParticipantData(distribution[i]);
                    if (itemData == null) {
                        itemData = data.getMediaItem(mediaID);
                    }
                    if (data == null) continue;
                    data.doneDataInTransit(itemData);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    @Override
    public void onMediaListenersChange(MediaData mediaData, MediaListener l, boolean added) {
    }

    void noteClientScreen(Long screenUID, Short originator) {
        try {
            ScreenModel screen = (ScreenModel)this.context.getObjectManager().getObjectFromMap(screenUID);
            Short[] participants = screen.getDistribution();
            for (int i = 0; i < participants.length; ++i) {
                if (participants[i].equals(this.context.getIDProcessor().getMyId()) || originator != null && participants[i].equals(originator)) continue;
                ParticipantData data = this.getParticipantData(participants[i]);
                if (data != null) {
                    data.noteStatusChange();
                    continue;
                }
                WBUtils.timedLog("DataExporter", "noteClientScreen, bad participant data for client: " + participants[i]);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    @Override
    public void onAddViewedScreensChange(Long screenUID, ViewedScreens.ScreenViewerList viewedScreensViewers, Short clientId) {
        ParticipantData data;
        if (!clientId.equals(ClientIdentification.SERVER_ID) && !clientId.equals(ClientIdentification.CLIENT_LOCAL) && (data = this.getParticipantData(clientId)) != null) {
            data.noteStatusChange();
        }
    }

    @Override
    public void onRemoveViewedScreensChange(Long screenUID, ViewedScreens.ScreenViewerList viewedScreensViewers, Short clientId) {
        ParticipantData data;
        if (!clientId.equals(ClientIdentification.SERVER_ID) && !clientId.equals(ClientIdentification.CLIENT_LOCAL) && (data = this.getParticipantData(clientId)) != null) {
            data.noteStatusChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onViewedChange() {
        ParticipantData[] partDatas = null;
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            partDatas = new ParticipantData[this.participants.size()];
            partDatas = this.participants.values().toArray(partDatas);
        }
        for (int i = 0; i < partDatas.length; ++i) {
            ParticipantData data = partDatas[i];
            if (!data.isOnline()) continue;
            data.invalidateTransitEntries();
            data.invalidateLastBest(null);
        }
    }

    public void processViewList(List<Viewing> viewList) {
        if (this.viewListProcessor == null) {
            this.viewListProcessor = new ViewListProcessor();
            this.viewListProcessor.start();
        }
        this.viewListProcessor.addViewList(viewList);
    }

    public void goneToScreen(Long leavingScreenUID, Long joiningScreenUID) {
        Long leaving = null;
        Long joining = null;
        if (leavingScreenUID != null && joiningScreenUID != null && leavingScreenUID.equals(joiningScreenUID)) {
            return;
        }
        if (leavingScreenUID != null && !leavingScreenUID.equals(this.leavingScreenUID)) {
            leaving = leavingScreenUID;
        }
        if (joiningScreenUID != null && !joiningScreenUID.equals(this.joiningScreenUID)) {
            joining = joiningScreenUID;
        }
        this.addAggregateScreenViewing(ClientIdentification.CLIENT_LOCAL, leaving, joining);
        this.leavingScreenUID = leavingScreenUID;
        this.joiningScreenUID = joiningScreenUID;
    }

    public void addAggregateScreenViewing(Short clientId, ScreenModel joining, ScreenModel leaving) {
        Long leavingUID = leaving != null && leaving.isConferenceNode() ? leaving.getObjectID() : null;
        Long joiningUID = joining != null && joining.isConferenceNode() ? joining.getObjectID() : null;
        this.addAggregateScreenViewing(clientId, leavingUID, joiningUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAggregateScreenViewing(Short clientId, Long leavingUID, Long joiningUID) {
        WhiteboardContext whiteboardContext = this.context;
        synchronized (whiteboardContext) {
            if (!this.context.isOnline() || this.context.isServer(clientId)) {
                return;
            }
            if (this.screenViewingAggregation == null) {
                this.screenViewingAggregation = new NoteScreenViewing(this.context);
                this.viewList = new LinkedList();
            }
            this.screenViewingAggregation.addViewing(leavingUID, joiningUID, clientId);
            this.viewList.add(new Viewing(leavingUID, joiningUID, clientId));
            if (this.screenViewingAggregation.entryCount() > 200 || this.context.isClient()) {
                this.sendAggregation();
            } else {
                if (this.aggregationTimer == null) {
                    this.aggregationTimer = new LightweightTimer(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            WhiteboardContext whiteboardContext = DataExporter.this.context;
                            synchronized (whiteboardContext) {
                                DataExporter.this.sendAggregation();
                            }
                        }
                    });
                }
                if (!this.aggregationTimer.isScheduled()) {
                    this.aggregationTimer.scheduleIn(1000L);
                }
            }
        }
    }

    private void sendAggregation() {
        NoteScreenViewing tmpAggregation = this.screenViewingAggregation;
        LinkedList<Viewing> tmpViewList = this.viewList;
        this.viewList = null;
        this.screenViewingAggregation = null;
        this.sendAggregate(tmpAggregation, tmpViewList);
    }

    private void sendAggregate(NoteScreenViewing aggregation, List<Viewing> viewingList) {
        if (aggregation == null || aggregation.isEmpty()) {
            return;
        }
        if (this.context.isClient()) {
            this.context.getDataProcessor().sendDirective((byte)5, (StreamableObject)aggregation, (short)0);
        } else {
            this.context.getDataProcessor().sendDirective((byte)5, (StreamableObject)aggregation, (short)-2);
        }
        if (viewingList != null && !viewingList.isEmpty()) {
            this.processViewList(viewingList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMedia(Short clientId, Short originatorId, ScreenModel screen, MediaData mediaData) {
        Debug.lockEnter((Object)this, (String)"DataExporter.addMedia", (String)"DataModel", (Object)this.context.getDataModel());
        try {
            DataModel dataModel = this.context.getDataModel();
            synchronized (dataModel) {
                Short[] participants;
                block12: {
                    if (screen != null) break block12;
                    Validator.logAlways("DataExporter.addMedia: no screen for: " + mediaData);
                    return;
                }
                if (clientId.equals(ScreenModel.BROADCAST_ADDRESS)) {
                    participants = screen.getDistribution();
                } else {
                    participants = new Short[]{clientId};
                    if (originatorId.equals(clientId)) {
                        originatorId = null;
                    }
                }
                for (int i = 0; i < participants.length; ++i) {
                    ParticipantData data;
                    if (originatorId != null && participants[i].shortValue() == originatorId.shortValue() || (data = this.getParticipantData(participants[i])) == null || !data.isOnline() || this.context.isPlayback()) continue;
                    boolean idle = !data.hasMoreWork();
                    data.addMedia(screen, mediaData);
                    if (!idle) continue;
                    data.getDataCodec().doWork();
                }
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"DataExporter.addMedia", (String)"DataModel", (Object)this.context.getDataModel());
        }
    }

    public void incrementMediaReceived(MediaData mediaData, Short clientId) {
        ParticipantData data = this.getParticipantData(clientId);
        if (data != null) {
            data.addToMediaSent(mediaData.getMediaID(), null);
        }
    }

    public void mediaReceived(MediaData mediaData, Short clientId) {
        ParticipantData data = this.getParticipantData(clientId);
        if (data != null) {
            data.mediaReceived(mediaData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeMedia(HashMap mediaMap, Short originatorId) {
        Debug.lockEnter((Object)this, (String)"DataExporter.defineMedia", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            ParticipantData data = this.getParticipantData(originatorId);
            if (data != null) {
                data.initializeMedia(mediaMap);
            } else {
                LogSupport.error((Object)this, (String)"defineMedia", (String)("DataExporter.initializeMedia: cannot find: " + originatorId));
            }
        }
        Debug.lockLeave((Object)this, (String)"DataExporter.defineMedia", (String)"DataModel", (Object)this.context.getDataModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defineMedia(MediaID mediaID, Short originatorId, boolean forceSent, boolean zeroRefCount) {
        Debug.lockEnter((Object)this, (String)"DataExporter.defineMedia", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            ParticipantData data = this.getParticipantData(originatorId);
            if (data != null) {
                MediaData mediaData;
                MediaItem mediaItem = this.context.getMediaCache().getMediaItem(mediaID);
                if (mediaItem != null && (mediaData = mediaItem.getMediaData()) != null && mediaData.getMedia() != null) {
                    data.mediaReceived(mediaID, forceSent, zeroRefCount);
                }
            } else {
                LogSupport.error((Object)this, (String)"defineMedia", (String)("DataExporter.defineMedia: cannot find: " + originatorId + " for media: " + mediaID));
            }
        }
        Debug.lockLeave((Object)this, (String)"DataExporter.defineMedia", (String)"DataModel", (Object)this.context.getDataModel());
    }

    @Override
    public boolean onMedia(MediaEvent mediaEvent) {
        this.updateTransitRefs();
        if (mediaEvent.getEventType() == 2) {
            this.removeMedia(mediaEvent.getMediaItem().getMediaData());
        }
        return false;
    }

    @Override
    public ScreenModel getMediaScreen() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMedia(MediaData mediaData) {
        Debug.lockEnter((Object)this, (String)"DataExporter.removeMedia", (String)"DataModel", (Object)this.context.getDataModel());
        try {
            DataModel dataModel = this.context.getDataModel();
            synchronized (dataModel) {
                for (ParticipantData data : this.participants.values()) {
                    data.flushMediaSent(mediaData.getMediaID());
                    try {
                        this.doneDataInTransit(mediaData.getMediaID().getMediaIDLong(), null, null, true, null);
                    }
                    catch (Exception ex) {}
                }
                return;
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"DataExporter.removeMedia", (String)"DataModel", (Object)this.context.getDataModel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushMedia(Short clientId, MediaID mediaID) {
        Debug.lockEnter((Object)this, (String)"DataExporter.flushMedia", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            ParticipantData data = this.getParticipantData(clientId);
            if (data != null) {
                data.flushMediaSent(mediaID);
            }
        }
        Debug.lockLeave((Object)this, (String)"DataExporter.flushMedia", (String)"DataModel", (Object)this.context.getDataModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emitDeletes(WBOutputStream ostr, Short targetClientId) {
        Debug.lockEnter((Object)this, (String)"DataExporter.emitDeletes", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            ParticipantData data = this.participants.get(targetClientId);
            if (data != null) {
                data.sendDeletions(ostr);
            } else {
                ParticipantData.sendEmptyDeletions(ostr);
            }
        }
        Debug.lockLeave((Object)this, (String)"DataExporter.emitDeletes", (String)"DataModel", (Object)this.context.getDataModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveDeletes(WBInputStream istr, boolean process) {
        Debug.lockEnter((Object)this, (String)"DataExporter.receiveDeletes", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            ParticipantData data = this.participants.get(istr.getOriginatorId());
            if (data != null) {
                data.receiveDeletions(istr, process);
            } else {
                ParticipantData.receiveEmptyDeletions(istr, process);
            }
        }
        Debug.lockLeave((Object)this, (String)"DataExporter.receiveDeletes", (String)"DataModel", (Object)this.context.getDataModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emitMyViewedScreens(WBOutputStream ostr) {
        Debug.lockEnter((Object)this, (String)"DataExporter.emitMyViewedScreens", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            this.emitClientViewedScreens(ostr, ClientIdentification.CLIENT_LOCAL);
        }
        Debug.lockLeave((Object)this, (String)"DataExporter.emitMyViewedScreens", (String)"DataModel", (Object)this.context.getDataModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emitClientViewedScreens(WBOutputStream ostr, Short clientId) {
        Debug.lockEnter((Object)this, (String)"DataExporter.emitClientViewedScreens", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            this.emitViewedScreens(ostr, clientId, null);
        }
        Debug.lockLeave((Object)this, (String)"DataExporter.emitClientViewedScreens", (String)"DataModel", (Object)this.context.getDataModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emitViewedScreens(WBOutputStream ostr, Short acceptClient, Short omitClient) {
        Debug.lockEnter((Object)this, (String)"DataExporter.emitViewedScreens", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            try {
                List screenList = this.viewedScreens.getViewedScreens();
                for (ViewedScreens.ScreenViewerList viewerList : screenList) {
                    Iterator iter2;
                    if (acceptClient != null && !viewerList.contains(acceptClient)) continue;
                    int includeCount = viewerList.size();
                    if (omitClient != null) {
                        iter2 = viewerList.iterator();
                        includeCount = 0;
                        while (iter2.hasNext()) {
                            if (((Short)iter2.next()).shortValue() == omitClient.shortValue()) continue;
                            ++includeCount;
                        }
                    }
                    if (includeCount <= 0) continue;
                    ObjectUID.objectUIDToStream(viewerList.getUID(), ostr);
                    iter2 = viewerList.iterator();
                    while (iter2.hasNext()) {
                        short clientId = (Short)iter2.next();
                        if (omitClient != null && clientId == omitClient) continue;
                        ostr.writeShort(clientId);
                    }
                    ostr.writeShort(-1);
                }
                ObjectUID.objectUIDToStream(null, ostr);
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"emitViewedScreens", (Throwable)ex, (boolean)true);
            }
        }
        Debug.lockLeave((Object)this, (String)"DataExporter.emitViewedScreens", (String)"DataModel", (Object)this.context.getDataModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveViewedScreens(WBInputStream istr) {
        Long screenUID = null;
        Debug.lockEnter((Object)this, (String)"DataExporter.receiveViewedScreens", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            try {
                screenUID = ObjectUID.objectUIDFromStream(istr);
                while (screenUID != null) {
                    short clientId;
                    while ((clientId = WBUtils.readShort(istr, "DataExporter.receiveViewedScreen: read clientId")) != -1) {
                        short localClient = this.context.getIDProcessor().conferenceToLocal(clientId, istr.getAddress());
                        if (0 == localClient) continue;
                        this.addViewedScreen(screenUID, localClient);
                    }
                    screenUID = ObjectUID.objectUIDFromStream(istr);
                }
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"receiveViewedScreens", (Throwable)ex, (boolean)true);
            }
            this.invalidateBestScreen(screenUID);
        }
        Debug.lockLeave((Object)this, (String)"DataExporter.receiveViewedScreens", (String)"DataModel", (Object)this.context.getDataModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveViewedScreensString(WBInputStream istr, StringBuffer buf) {
        Long screenUID = null;
        Debug.lockEnter((Object)this, (String)"DataExporter.receiveViewedScreensString", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            try {
                screenUID = ObjectUID.objectUIDFromStream(istr);
                while (screenUID != null) {
                    short clientId;
                    while ((clientId = WBUtils.readShort(istr, "DataExporter.receiveViewedScreen: read clientId")) != -1) {
                        buf.append("DataExport.receiveViewedScreenString: receives screen: " + WBUtils.objectName(screenUID, this.context) + ", clientId: " + clientId);
                    }
                    screenUID = ObjectUID.objectUIDFromStream(istr);
                }
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"receiveViewedScreensString", (Throwable)ex, (boolean)true);
            }
        }
        Debug.lockLeave((Object)this, (String)"DataExporter.receiveViewedScreensString", (String)"DataModel", (Object)this.context.getDataModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addViewedScreen(Long screenUID) {
        Debug.lockEnter((Object)this, (String)"DataExporter.addViewedScreen1", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            this.addViewedScreen(screenUID, (short)0);
        }
        Debug.lockLeave((Object)this, (String)"DataExporter.addViewedScreen1", (String)"DataModel", (Object)this.context.getDataModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addViewedScreen(Long screenUID, short clientId) {
        Debug.lockEnter((Object)this, (String)"DataExporter.addViewedScreen2", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            this.viewedScreens.addViewedScreen(screenUID, ShortList.get((short)clientId));
            this.invalidateBestScreen(screenUID);
        }
        Debug.lockLeave((Object)this, (String)"DataExporter.addViewedScreen2", (String)"DataModel", (Object)this.context.getDataModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeViewedScreen(Long screenUID) {
        Debug.lockEnter((Object)this, (String)"DataExporter.removeViewedScreen1", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            this.removeViewedScreen(screenUID, (short)0);
        }
        Debug.lockLeave((Object)this, (String)"DataExporter.removeViewedScreen1", (String)"DataModel", (Object)this.context.getDataModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeViewedScreen(Long screenUID, short clientId) {
        Debug.lockEnter((Object)this, (String)"DataExporter.removeViewedScreen2", (String)"DataModel", (Object)this.context.getDataModel());
        try {
            DataModel dataModel = this.context.getDataModel();
            synchronized (dataModel) {
                block8: {
                    if (!this.viewedScreens.isEmpty()) break block8;
                    return;
                }
                this.viewedScreens.removeViewedScreen(screenUID, ShortList.get((short)clientId));
                this.invalidateBestScreen(screenUID);
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"DataExporter.removeViewedScreen2", (String)"DataModel", (Object)this.context.getDataModel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeViewer(Short clientId) {
        Debug.lockEnter((Object)this, (String)"DataExporter.removeViewer", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            this.viewedScreens.removeViewer(clientId);
            this.invalidateBestScreen(null);
        }
        Debug.lockLeave((Object)this, (String)"DataExporter.removeViewer", (String)"DataModel", (Object)this.context.getDataModel());
    }

    public ViewedScreens getViewedScreens() {
        return this.viewedScreens;
    }

    public Set getClientsScreens(Short clientId) {
        return this.viewedScreens.getScreensForClient(clientId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateBestScreen(Long screenUID) {
        Debug.lockEnter((Object)this, (String)"DataExporter.invalidateBestScreen", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            try {
                ScreenModel screen = (ScreenModel)this.context.getObjectManager().getObjectFromMap(screenUID);
                for (ParticipantData data : this.participants.values()) {
                    data.invalidateLastBest(screen);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        Debug.lockLeave((Object)this, (String)"DataExporter.invalidateBestScreen", (String)"DataModel", (Object)this.context.getDataModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate() {
        Debug.lockEnter((Object)this, (String)"DataExporter.validate", (String)"DataModel", (Object)this.context.getDataModel());
        try {
            DataModel dataModel = this.context.getDataModel();
            synchronized (dataModel) {
                boolean valid = true;
                if (this.participants == null) {
                    Validator.logAlways("DataExport participants is null, should be a HashMap.");
                    valid = Validator.setValid(valid, false);
                } else {
                    for (Map.Entry<Short, ParticipantData> entry : this.participants.entrySet()) {
                        if (entry.getKey() == null) {
                            Validator.log("DataExporter.participants has null key as ParticipantId.");
                            valid = Validator.setValid(valid, false);
                        }
                        if (entry.getValue() == null) {
                            Validator.log("DataExporter.participants has null value as ParticipantData.");
                            valid = Validator.setValid(valid, false);
                            continue;
                        }
                        ParticipantData data = entry.getValue();
                        Short participantId = entry.getKey();
                        valid &= data.validate(participantId);
                    }
                }
                boolean bl = valid;
                return bl;
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"DataExporter.loadTemplate", (String)"DataModel", (Object)this.context.getDataModel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exportStatus() {
        Debug.lockEnter((Object)this, (String)"DataExporter.loadTemplate", (String)"DataModel", (Object)this.context.getDataModel());
        try {
            DataModel dataModel = this.context.getDataModel();
            synchronized (dataModel) {
                StringBuffer buf = new StringBuffer("\n DATA EXPORTER: codecBlock count:" + this.blocker + "\n");
                for (DataCodec codec : this.blockedCodecs) {
                    buf.append("\n Codec blocked for lock for participant: " + codec.getParticipantData().getClientAddress());
                }
                for (ParticipantData data : this.participants.values()) {
                    buf.append(data.getDataCodec().toString() + "\nParticipant: " + data.getClientAddress() + ", is blocked: " + data.getDataCodec().isBlocked() + ", has data: " + data.toString());
                    data.getDataCodec().doWork();
                }
                buf.append("\n");
                buf.append(this.viewedScreens.toString());
                String string = buf.toString();
                return string;
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"DataExporter.validate", (String)"DataModel", (Object)this.context.getDataModel());
        }
    }

    class MediaRef {
        HashSet screens;
        MediaID mediaID;
        Long mediaIDLong;

        public MediaRef(Long mediaID) {
            this.mediaIDLong = mediaID;
            this.mediaID = new MediaID(mediaID);
            this.screens = null;
        }

        public boolean isEmpty() {
            return this.screens == null || this.screens.isEmpty();
        }

        public void addRef() {
        }

        public boolean containsScreen(Long screenUID) {
            return this.screens == null || this.screens.contains(screenUID);
        }

        public int getRefCount() {
            return this.screens == null ? 0 : this.screens.size();
        }
    }

    class ViewListProcessor
    extends WorkerThread
    implements ShutdownListener {
        private LinkedList<List<Viewing>> viewChangeList;

        public ViewListProcessor() {
            super("View List Processor", 1);
            this.viewChangeList = new LinkedList();
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addViewList(List<Viewing> viewList) {
            LinkedList<List<Viewing>> linkedList = this.viewChangeList;
            synchronized (linkedList) {
                this.viewChangeList.add(viewList);
                if (this.viewChangeList.size() == 1) {
                    this.viewChangeList.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onShutdown() {
            LinkedList<List<Viewing>> linkedList = this.viewChangeList;
            synchronized (linkedList) {
                this.interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DataExporter.this.context.addShutdownListener(this);
            try {
                while (!ViewListProcessor.interrupted()) {
                    List<Viewing> viewList;
                    LinkedList<List<Viewing>> linkedList = this.viewChangeList;
                    synchronized (linkedList) {
                        if (this.viewChangeList.isEmpty()) {
                            try {
                                this.viewChangeList.wait();
                            }
                            catch (InterruptedException ex) {
                                break;
                            }
                        }
                        viewList = this.viewChangeList.removeFirst();
                    }
                    DataExporter.this.viewedScreens.processViewList(viewList);
                }
                DataExporter.this.viewListProcessor = null;
            }
            finally {
                DataExporter.this.context.removeShutdownListener(this);
                DataExporter.this.viewListProcessor = null;
            }
        }
    }
}

