/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.conference;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.comm.AbstractCommContainer;
import com.elluminate.groupware.whiteboard.conference.AcknowledgeBlock;
import com.elluminate.groupware.whiteboard.conference.AddObject;
import com.elluminate.groupware.whiteboard.conference.DataBlock;
import com.elluminate.groupware.whiteboard.conference.ItemData;
import com.elluminate.groupware.whiteboard.conference.ParticipantData;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.dataModel.DataModel;
import com.elluminate.groupware.whiteboard.dataModel.MediaData;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.interfaces.StreamableObject;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.Transceiver;
import com.elluminate.util.Debug;
import com.elluminate.util.ShortList;
import com.elluminate.util.log.LogSupport;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class DataCodec {
    private static final double WINDOW_TIME = 0.75;
    private static final int WINDOW_MAX = 10;
    private static final double ACK_TIME = 0.2;
    private static final int ACK_WINDOW_MAX = 5;
    private static final int BLOCK_SIZE = 400;
    private static final int MAX_SPEED = 33600;
    private static final boolean DEBUG = false;
    public static final short FLAG_ATOMIC = Short.MIN_VALUE;
    public static final short ATOMIC_DELETE = -32767;
    private static final int SEARCH_LIMIT = Short.MAX_VALUE;
    private short window_size = (short)10;
    private short ack_trigger = (short)5;
    private HashMap<RegisteredTemplate, ItemData> fragmentMap = new HashMap();
    private LinkedList<Short> fragmentFreeKeySet = new LinkedList();
    private HashMap<Short, ItemData> assemblyMap = new HashMap();
    private HashMap<Short, ItemData> assemblyMapString = null;
    private volatile short windowSent = 0;
    private volatile short lastAckedBlock = (short)4095;
    private volatile int outstandingAcks = 0;
    private DataBlock dataBlock = null;
    private short maxItemUID = 0;
    private ParticipantData data = null;
    private boolean online = false;
    private Transceiver transceiver = null;
    private WhiteboardContext context = null;

    public DataCodec(ParticipantData data, WhiteboardContext context) {
        this.data = data;
        this.context = context;
        this.dataBlock = new DataBlock(context);
    }

    public void evaluateSpeed(Transceiver transceiver) {
        this.transceiver = transceiver;
        if (transceiver != null) {
            double speed = Math.min(transceiver.getMaxXmitSpeed(), 33600);
            this.window_size = (short)Math.ceil(speed * 0.75 / 3200.0);
            this.ack_trigger = (short)Math.ceil(speed * 0.2 / 3200.0);
            System.out.println("evaluateSpeed: Window=" + this.window_size + ", ack=" + this.ack_trigger + ", speed=" + speed);
            this.window_size = (short)Math.min(10, this.window_size);
            this.ack_trigger = (short)Math.min(5, this.ack_trigger);
        } else {
            this.window_size = (short)10;
            this.ack_trigger = (short)5;
        }
    }

    void dispose() {
        this.quenchFragments();
        for (ItemData itemData : this.assemblyMap.values()) {
            itemData.dispose();
        }
        this.assemblyMap.clear();
        if (this.assemblyMapString != null) {
            for (ItemData itemData : this.assemblyMapString.values()) {
                itemData.dispose();
            }
            this.assemblyMapString.clear();
            this.assemblyMapString = null;
        }
    }

    synchronized boolean isBlocked() {
        boolean blocked;
        boolean bl = blocked = this.windowSent >= this.window_size;
        if (!blocked && this.context.getDataExporter().isBlocked()) {
            blocked = true;
            this.context.getDataExporter().noteBlockedCodec(this);
        }
        return blocked;
    }

    ParticipantData getParticipantData() {
        return this.data;
    }

    synchronized void onLine(boolean online) {
        if (!online) {
            for (ItemData itemData : this.fragmentMap.values()) {
                itemData.dispose();
            }
            this.fragmentMap.clear();
            for (ItemData itemData : this.assemblyMap.values()) {
                itemData.dispose();
            }
            this.assemblyMap.clear();
            if (this.assemblyMapString != null) {
                for (ItemData itemData : this.assemblyMap.values()) {
                    itemData.dispose();
                }
                this.assemblyMapString.clear();
                this.assemblyMapString = null;
            }
            this.windowSent = 0;
            this.lastAckedBlock = (short)4095;
            this.outstandingAcks = 0;
            this.dataBlock = new DataBlock(this.context);
        }
        this.online = online;
    }

    public boolean isOnline() {
        return this.online;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doWork() {
        boolean result = true;
        Debug.lockEnter((Object)this, (String)"TemplateRegistry.loadTemplate", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            if (!this.isBlocked() && this.context.getDataProcessor().areChannelsUp()) {
                this.getWork();
                result = !this.isBlocked();
            }
        }
        Debug.lockLeave((Object)this, (String)"TemplateRegistry.loadTemplate", (String)"DataModel", (Object)this.context.getDataModel());
        return result;
    }

    private void getWork() {
        boolean triggerBlockDump = false;
        boolean oldItem = false;
        ItemData itemData = null;
        int bestItemLimiter = 0;
        while (!this.isBlocked() && this.data.hasMoreWork()) {
            if (this.data.proxiesComplete() && this.data.deletionsComplete(this.dataBlock) && this.data.hasMoreWork()) {
                RegisteredTemplate item = this.data.getBestItem(this.dataBlock);
                if (item != null) {
                    bestItemLimiter = 0;
                    itemData = this.fragmentMap.get(item);
                    boolean bl = oldItem = itemData != null;
                    if (!oldItem) {
                        Long screenUID = null;
                        if (item instanceof WBNode && ((WBNode)item).getScreenParent() != null) {
                            screenUID = ((WBNode)item).getScreenParent().getObjectID();
                        } else if (item instanceof MediaData) {
                            screenUID = ((MediaData)item).getMediaID().getMediaIDLong();
                        }
                        itemData = new ItemData(item, this.consumeItemUID(), screenUID, this.data.getClientId(), this.data);
                    } else if (item instanceof WBNode && itemData.getRevision() != ((WBNode)item).getRevision()) {
                        itemData.regenerateItem();
                    }
                    if (itemData.addItemToBlock(this.dataBlock)) {
                        if (itemData.getItem() instanceof WBNode) {
                            ((WBNode)itemData.getItem()).addMediaRequest(this.data.getClientId());
                        }
                        if (oldItem && this.fragmentMap.remove(item) == null) {
                            LogSupport.message((Object)this, (String)"processChannelData", (String)("item not removed from fragmentMap: " + item));
                        }
                        this.releaseItemUID(itemData.getKey());
                        this.data.removeItem(item);
                        itemData.dispose();
                    } else if (!oldItem) {
                        this.fragmentMap.put(item, itemData);
                    }
                } else {
                    LogSupport.message((Object)this, (String)"processChannelData", (String)("DataCodec.getWork: getBestItem returns null.\n" + this.data.hasMoreWorkString()));
                    if (++bestItemLimiter > 5) {
                        throw new RuntimeException("bestItem returns null");
                    }
                }
            }
            if (this.dataBlock.isFull(20)) {
                if (triggerBlockDump) {
                    System.out.println(this.dataBlock);
                    triggerBlockDump = false;
                }
                this.sendBlock(this.dataBlock, false);
            }
            this.data.invalidateTransitEntries();
        }
        if (!this.data.hasMoreWork()) {
            this.quenchFragments();
        }
        if (!this.dataBlock.isEmpty()) {
            if (triggerBlockDump) {
                System.out.println(this.dataBlock);
                triggerBlockDump = false;
            }
            this.sendBlock(this.dataBlock, false);
        }
    }

    void forceItemData(RegisteredTemplate item, boolean flush) {
        Long screenUID = null;
        if (item instanceof WBNode && ((WBNode)item).getScreenParent() != null) {
            screenUID = ((WBNode)item).getScreenParent().getObjectID();
        }
        ItemData itemData = new ItemData(item, this.consumeItemUID(), screenUID, this.data.getClientId(), this.data);
        while (!itemData.addItemToBlock(this.dataBlock)) {
            if (!this.dataBlock.isFull(itemData.headerSpace())) continue;
            this.sendBlock(this.dataBlock, false);
        }
        if (!this.dataBlock.isEmpty() && flush) {
            this.sendBlock(this.dataBlock, true);
        }
        this.releaseItemUID(itemData.getKey());
        itemData.dispose();
    }

    private void quenchFragments() {
        for (ItemData itemData : this.fragmentMap.values()) {
            this.quenchFragment(itemData);
        }
        this.fragmentMap.clear();
        if (!this.dataBlock.isEmpty()) {
            this.sendBlock(this.dataBlock, false);
        }
    }

    private void quenchFragment(ItemData itemData) {
        while (!itemData.addItemQuench(this.dataBlock)) {
            this.sendBlock(this.dataBlock, false);
        }
        itemData.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void acknowledgeBlock(short blockNumber) {
        int acknowledgeSpan;
        int n = acknowledgeSpan = blockNumber < this.lastAckedBlock ? blockNumber + 4095 + 1 - this.lastAckedBlock : blockNumber - this.lastAckedBlock;
        if (this.online && (acknowledgeSpan < 1 || acknowledgeSpan > this.window_size)) {
            PrintStream printStream = System.out;
            synchronized (printStream) {
                LogSupport.exception((Object)this, (String)("acknowledgeBlock, clientId: " + this.data.getClientId()), (Throwable)new Throwable("acknowledgeSpan out of range: " + acknowledgeSpan + ", blockNumber: " + blockNumber + ", lastAckedBlock: " + this.lastAckedBlock), (boolean)true);
            }
        }
        this.lastAckedBlock = blockNumber;
        this.windowSent = (short)(this.windowSent - acknowledgeSpan);
        this.outstandingAcks = (int)Math.ceil(this.windowSent / this.ack_trigger);
        if (!this.isBlocked()) {
            this.getWork();
        }
    }

    private synchronized void sendBlock(DataBlock dataBlock, boolean forceAck) {
        boolean needAck;
        this.windowSent = (short)(this.windowSent + 1);
        boolean bl = needAck = !this.data.hasMoreWork() || forceAck;
        if (Math.ceil(this.windowSent / this.ack_trigger) > (double)this.outstandingAcks) {
            needAck = true;
        }
        if (needAck) {
            this.outstandingAcks = (int)Math.ceil(this.windowSent / this.ack_trigger);
        }
        dataBlock.setNeedsAck(needAck);
        this.context.getDataProcessor().sendNegotiatedData(dataBlock, this.data.getClientAddress());
        this.isBlocked();
        dataBlock.clear();
        if (this.context.getController() != null) {
            this.context.getController().noteActivity(this.context.getIDProcessor().getMyId(), null);
        }
    }

    private void clearFreeKeys() {
        this.fragmentFreeKeySet.clear();
        this.maxItemUID = 0;
    }

    private Short consumeItemUID() {
        Short s;
        Short itemUID;
        if (this.fragmentFreeKeySet.isEmpty()) {
            short s2 = this.maxItemUID;
            this.maxItemUID = (short)(s2 + 1);
            s = itemUID = ShortList.get((short)s2);
        } else {
            s = this.fragmentFreeKeySet.removeFirst();
        }
        itemUID = s;
        return itemUID;
    }

    private void releaseItemUID(Short itemUID) {
        this.fragmentFreeKeySet.add(itemUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processChannelData(ChannelDataEvent cde) {
        Debug.lockEnter((Object)this, (String)"TemplateRegistry.loadTemplate", (String)"DataModel", (Object)this.context.getDataModel());
        try {
            DataModel dataModel = this.context.getDataModel();
            synchronized (dataModel) {
                WBInputStream istr;
                block35: {
                    istr = null;
                    if (this.online) break block35;
                    return;
                }
                istr = WBInputStream.inputStreamFactory(this.context, cde);
                try {
                    short blockNumber = WBUtils.readShort(istr, "Assembler reads blockNumber");
                    if ((blockNumber & Short.MIN_VALUE) != 0) {
                        blockNumber = (short)(blockNumber & 0xFFFF7FFF);
                        AcknowledgeBlock ack = new AcknowledgeBlock(this.context, blockNumber);
                        this.context.getDataProcessor().sendDirective((byte)5, (StreamableObject)ack, cde.getSourceAddress());
                    }
                    block24: while (istr.available() > 0) {
                        boolean oldItem;
                        short itemUIDshort = WBUtils.readShort(istr, "DataBlock reads itemUID");
                        if ((itemUIDshort & Short.MIN_VALUE) != 0) {
                            switch (itemUIDshort) {
                                case -32767: {
                                    this.data.receiveDeletions(istr, true);
                                    continue block24;
                                }
                            }
                            LogSupport.message((Object)this, (String)"processChannelData", (String)("Unknown Atomic: " + itemUIDshort));
                            continue;
                        }
                        Short itemUID = ShortList.get((short)itemUIDshort);
                        ItemData item = this.assemblyMap.get(itemUID);
                        boolean bl = oldItem = item != null;
                        if (!oldItem) {
                            item = new ItemData(itemUID, this.context, this.data, cde);
                        }
                        if (item.readItem(istr)) {
                            if (oldItem && this.assemblyMap.remove(itemUID) == null) {
                                LogSupport.message((Object)this, (String)"processChannelData", (String)("itemUID not removed from assemblyMap: " + itemUID));
                            }
                            if (!item.isQuenched()) {
                                WBInputStream itemStr = item.getDataStream();
                                try {
                                    RegisteredTemplate node = AddObject.recoverObject(itemStr, this.context);
                                    if (node instanceof WBNode) {
                                        AddObject.addObject(node, itemStr.getOriginatorId(), this.context);
                                    } else if (!(node instanceof AbstractCommContainer)) {
                                        LogSupport.message((Object)this, (String)"processChannelData", (String)("DataCodec: non-node/comm: " + item + "\n  istr data:\n" + istr));
                                    }
                                }
                                catch (Exception ex) {
                                    LogSupport.exception((Object)this, (String)"processChannelData", (Throwable)ex, (boolean)true, (String)("Exception in processing recoverObject." + item));
                                }
                            }
                            item.dispose();
                            continue;
                        }
                        this.assemblyMap.put(itemUID, item);
                    }
                }
                catch (Exception ioe) {
                    ioe.printStackTrace();
                    LogSupport.exception((Object)this, (String)"processChannelData", (Throwable)ioe, (boolean)true);
                }
                finally {
                    if (istr != null) {
                        try {
                            istr.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"TemplateRegistry.loadTemplate", (String)"DataModel", (Object)this.context.getDataModel());
        }
    }

    private String itemStreamToString(WBInputStream istr) {
        StringBuffer msg = new StringBuffer("Decoded stream: ");
        try {
            if (istr.available() > 0) {
                RegisteredTemplate temp = this.context.getTemplateRegistry().templateLocator(istr);
                if (temp != null) {
                    msg.append(temp.streamToString(istr));
                } else {
                    msg.append("Null template");
                }
            }
            istr.close();
        }
        catch (Exception ex) {
            msg.append(" Exception: " + ex.getMessage());
        }
        msg.append("\n");
        return msg.toString();
    }

    String streamToString(WBInputStream istr) {
        StringBuffer buf = new StringBuffer(512);
        buf.append("DataBlock");
        boolean needsAck = false;
        if (this.assemblyMapString == null) {
            this.assemblyMapString = new HashMap();
        }
        try {
            short blockNumber = WBUtils.readShort(istr, "Assembler reads blockNumber");
            if ((blockNumber & Short.MIN_VALUE) != 0) {
                blockNumber = (short)(blockNumber & 0xFFFF7FFF);
                needsAck = true;
            }
            buf.append(": " + blockNumber);
            if (needsAck) {
                buf.append(" NeedsAck:");
            }
            block5: while (istr.available() > 0) {
                short itemUIDshort = WBUtils.readShort(istr, "Assembler reads itemUID");
                if ((itemUIDshort & Short.MIN_VALUE) != 0) {
                    switch (itemUIDshort) {
                        case -32767: {
                            ParticipantData.receiveDeletionsString(istr, buf);
                            continue block5;
                        }
                    }
                    continue;
                }
                Short itemUID = ShortList.get((short)itemUIDshort);
                ItemData item = this.assemblyMapString.get(itemUID);
                if (item == null) {
                    item = new ItemData(itemUID, this.context, this.data, null);
                }
                if (item.readItem(istr)) {
                    if (this.assemblyMapString.remove(itemUID) == null) {
                        LogSupport.message((Object)this, (String)"streamToString", (String)("itemUID not removed from assemblyMapString: " + itemUID));
                    }
                    if (!item.isQuenched()) {
                        AddObject.recoverObjectString(item.getDataStream(), buf);
                    } else {
                        buf.append("Assembler Quenches Item.");
                    }
                    item.dispose();
                    continue;
                }
                this.assemblyMapString.put(itemUID, item);
            }
        }
        catch (IOException ioe) {
            LogSupport.exception((Object)this, (String)"streamToString", (Throwable)ioe, (boolean)true);
        }
        return buf.toString();
    }

    public synchronized String toString() {
        StringBuffer buf = new StringBuffer();
        try {
            buf.append("DataCodec: online: " + this.online + ", windowSent: " + this.windowSent + ", window_size: " + this.window_size + ", lastAckedBlock: " + this.lastAckedBlock + ", maxItemUID: " + this.maxItemUID + "\n\tFragments(" + this.fragmentMap.size() + "): \n");
            Iterator<Object> iter = this.fragmentMap.keySet().iterator();
            while (iter.hasNext()) {
                buf.append(iter.next() + "\n");
            }
            buf.append("\tFree Fragemnt itemUIDs(" + this.fragmentFreeKeySet.size() + "): ");
            iter = this.fragmentFreeKeySet.iterator();
            while (iter.hasNext()) {
                buf.append((Short)((Object)iter.next()));
                if (!iter.hasNext()) continue;
                buf.append(", ");
            }
            buf.append("\n\tAssemblyMap(" + this.assemblyMap.size() + "): \n");
            iter = this.assemblyMap.keySet().iterator();
            while (iter.hasNext()) {
                buf.append(iter.next() + "\n");
            }
        }
        catch (Exception ex) {
            buf.append("Exception: " + ex.getMessage());
        }
        buf.append("\n");
        return buf.toString();
    }
}

