/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.conference;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.WhiteboardProtocol;
import java.io.DataOutputStream;

public class DataBlock {
    static final int BLOCK_MODULUS = 4095;
    static final int BLOCK_SIZE = 400;
    public static final short NEEDS_ACK = Short.MIN_VALUE;
    public static final byte FLAG_INCOMPLETE = -1;
    public static final byte FLAG_QUENCH = -2;
    boolean needsAck = false;
    short blockNumber = 0;
    int maxIndex = 0;
    private byte[] buffer = null;
    WhiteboardContext context;

    public DataBlock(WhiteboardContext context) {
        this.context = context;
    }

    public void clear() {
        this.maxIndex = 0;
        this.buffer = null;
        this.needsAck = false;
    }

    public void addByte(byte data) {
        this.validateIndex("DataBlock.addByte", this.maxIndex);
        this.putByte(data, this.maxIndex++);
    }

    public byte getByte(int index) {
        this.validateIndex("DataBlock.getByte", index);
        if (index >= this.maxIndex) {
            this.maxIndex = index + 1;
        }
        return this.buffer[index];
    }

    public void putByte(byte data, int index) {
        this.validateIndex("DataBlock.putByte", index);
        if (index >= this.maxIndex) {
            this.maxIndex = index + 1;
        }
        this.buffer[index] = data;
    }

    public int putByte(byte data) {
        this.putByte(data, this.maxIndex);
        return this.maxIndex;
    }

    public int putBytes(byte[] buffer, int base) {
        int length = Math.min(this.getSpace(), buffer.length - base);
        int last = base + length;
        System.arraycopy(buffer, base, this.buffer, this.maxIndex, length);
        this.maxIndex += length;
        return length;
    }

    public void putShort(short value, int index) {
        this.validateIndex("DataBlock.putShort", index + 1);
        this.putByte((byte)(value >> 8 & 0xFF), index);
        this.putByte((byte)(value & 0xFF), index + 1);
    }

    public int putShort(short value) {
        int result = this.maxIndex;
        this.putShort(value, this.maxIndex);
        return result;
    }

    public void putInt(int value, int index) {
        this.validateIndex("DataBlock.putInt", index + 3);
        this.putByte((byte)(value >> 24 & 0xFF), index);
        this.putByte((byte)(value >> 16 & 0xFF), index + 1);
        this.putByte((byte)(value >> 8 & 0xFF), index + 2);
        this.putByte((byte)(value & 0xFF), index + 3);
    }

    public int putInt(int value) {
        int result = this.maxIndex;
        this.putInt(value, this.maxIndex);
        return result;
    }

    public void putLong(long value, int index) {
        this.validateIndex("DataBlock.putLong", index + 7);
        this.putByte((byte)(value >> 56 & 0xFFL), index);
        this.putByte((byte)(value >> 48 & 0xFFL), index + 1);
        this.putByte((byte)(value >> 40 & 0xFFL), index + 2);
        this.putByte((byte)(value >> 32 & 0xFFL), index + 3);
        this.putByte((byte)(value >> 24 & 0xFFL), index + 4);
        this.putByte((byte)(value >> 16 & 0xFFL), index + 5);
        this.putByte((byte)(value >> 8 & 0xFFL), index + 6);
        this.putByte((byte)(value & 0xFFL), index + 7);
    }

    public int putLong(long value) {
        int result = this.maxIndex;
        this.putLong(value, this.maxIndex);
        return result;
    }

    private int getSize() {
        return 400;
    }

    private int getSpace() {
        return this.getSize() - this.maxIndex;
    }

    private void validateIndex(String originator, int index) {
        if (index >= 400 || index < 0) {
            throw new RuntimeException(originator + " index < 0 or >= " + 400);
        }
        if (this.buffer == null) {
            this.buffer = new byte[400];
            this.maxIndex = 0;
        }
    }

    public DataBlockEntry getDataBlockEntry() {
        return new DataBlockEntry(this.maxIndex, this);
    }

    public boolean isFull(int guard) {
        return this.getSpace() <= guard;
    }

    public boolean isEmpty() {
        return this.maxIndex == 0;
    }

    public void setNeedsAck(boolean needsAck) {
        this.needsAck = needsAck;
    }

    public void objectToStream(DataOutputStream ostr) throws Exception {
        short blockNum = this.blockNumber;
        if (this.needsAck) {
            blockNum = (short)(blockNum | Short.MIN_VALUE);
        }
        ostr.writeShort(blockNum);
        ostr.write(this.buffer, 0, this.maxIndex);
        this.blockNumber = (short)(this.blockNumber + 1);
        if (this.blockNumber > 4095) {
            this.blockNumber = 0;
        }
    }

    public String toString() {
        return "DataBlock: blockNumber: " + this.blockNumber + ", needs Ack: " + this.needsAck + ", maxIndex: " + this.maxIndex + "\n" + WhiteboardProtocol.arrayToString(this.buffer);
    }

    public class DataBlockEntry {
        DataBlock block;
        int entryBase;

        public DataBlockEntry(int entryBase, DataBlock block) {
            this.block = block;
            this.entryBase = entryBase;
        }

        public void addByte(byte data) {
            this.block.addByte(data);
        }

        public byte getByte(int index) {
            return this.block.getByte(index + this.entryBase);
        }

        public void putByte(byte data, int index) {
            this.block.putByte(data, index + this.entryBase);
        }

        public void putByte(byte data) {
            this.block.putByte(data);
        }

        public int putBytes(byte[] buffer, int base) {
            return this.block.putBytes(buffer, base);
        }

        public void putShort(short value, int index) {
            this.block.putShort(value, index + this.entryBase);
        }

        public int putShort(short value) {
            return this.block.putShort(value) - this.entryBase;
        }

        public void putInt(int value, int index) {
            this.block.putInt(value, index + this.entryBase);
        }

        public int putInt(int value) {
            return this.block.putInt(value) - this.entryBase;
        }

        public void putLong(long value, int index) {
            this.block.putLong(value, index + this.entryBase);
        }

        public int putLong(long value) {
            return this.block.putLong(value) - this.entryBase;
        }

        public int getSize() {
            return this.block.getSize() - this.entryBase;
        }

        public int getSpace() {
            return this.block.getSpace();
        }
    }
}

