/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.conference;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.comm.AbstractCommContainer;
import com.elluminate.groupware.whiteboard.conference.RecognizeClient;
import com.elluminate.groupware.whiteboard.conference.ServerSendsScreenSynch;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.DataModelData;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.interfaces.StreamableObject;
import com.elluminate.util.ShortList;
import com.elluminate.util.log.LogSupport;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;

public class ClientSendsScreenSynch
extends AbstractCommContainer {
    static final String DATA_NAME = "clientSynch";
    static final String MEDIA_LIST = "mediaList";
    Short clientId;
    long clientConferenceId;
    String clientName;
    LinkedList clientServedScreens = null;
    LinkedList clientServedTools = null;

    public ClientSendsScreenSynch(WhiteboardContext context) {
        super(context, "_ClientSendsScreenSynch");
    }

    public void setOnline(Short clientId, long clientConferenceId, String clientName) {
        this.clientId = clientId;
        this.clientConferenceId = clientConferenceId;
        this.clientName = clientName;
        if (!this.context.isPlayback()) {
            this.context.getCommStateData().put(DATA_NAME, this);
        }
    }

    public LinkedList getClientServedScreens() {
        return this.clientServedScreens;
    }

    public LinkedList getClientServedTools() {
        return this.clientServedTools;
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        this.context.getDataExporter().blockCodecs();
        super.objectToStream(ostr);
        ostr.writeShort(this.clientId.shortValue());
        ostr.writeLong(this.clientConferenceId);
        ostr.writeUTF(this.clientName);
        DataModelData objectSet = new DataModelData(this.context, true, true, null, 1);
        objectSet.emitDataModel(ostr, true, true, true);
        if (this.context.getController() != null) {
            this.context.getController().initializeViewedScreens();
        }
        this.context.getMediaCache().emitDefinedMedia(ostr);
        this.context.getDataExporter().unblockCodecs();
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        boolean clientRejoins = true;
        try {
            this.context.getDataExporter().blockCodecs();
            super.streamToObject(istr);
            Short clientAddress = ShortList.get((short)istr.getCde().getSourceAddress());
            Short clientId = ShortList.get((short)WBUtils.readShort(istr, "ClientSendsScreenSynch reads clientId"));
            long clientConferenceId = WBUtils.readLong(istr, "ClientSendsScreenSynch reads previous clientConferenceId");
            String clientName = WBUtils.readUTF(istr, "ClientSendsScreenSynch reads clientName");
            if (this.context.getConferenceUID() != clientConferenceId) {
                clientId = null;
                clientRejoins = false;
            }
            this.context.getIDProcessor().addClient(clientAddress, clientId, clientName);
            RecognizeClient recognize = new RecognizeClient(this.context);
            recognize.bindID(clientAddress, this.context.getIDProcessor().getClientId(clientAddress), clientName);
            this.context.getDataProcessor().sendDirective((byte)5, (StreamableObject)recognize, this.context.participantsExcept(clientAddress));
            this.context.getIDProcessor().sendParticipantData(new short[]{clientAddress});
            DataModelData clientObjects = new DataModelData(this.context, istr);
            if (!clientRejoins) {
                clientObjects.clear();
            }
            this.context.getDataExporter().removeViewer(this.context.getIDProcessor().getClientId(clientAddress));
            clientId = this.context.getIDProcessor().getClientId(clientAddress);
            HashMap clientMedia = this.context.getMediaCache().readDefinedMedia(istr);
            if (!clientRejoins) {
                clientMedia.clear();
            }
            ServerSendsScreenSynch serverSendsSynch = new ServerSendsScreenSynch(this.context, clientMedia);
            serverSendsSynch.noteClientServedScreens(clientObjects, clientAddress, clientId);
            this.context.getDataProcessor().sendDirective((byte)5, (StreamableObject)serverSendsSynch, (short)clientAddress);
        }
        catch (IOException ioe) {
            LogSupport.exception((Object)this, (String)"streamToObject", (Throwable)ioe, (boolean)true);
        }
        this.context.getDataExporter().unblockCodecs();
        return null;
    }

    @Override
    public String streamToString(WBInputStream istr) {
        StringBuffer buf = new StringBuffer(super.streamToString(istr));
        try {
            boolean clientRejoins;
            Short clientId = ShortList.get((short)WBUtils.readShort(istr, "ClientSendsScreenSynch reads clientId"));
            long clientConferenceId = WBUtils.readLong(istr, "ClientSendsScreenSynch reads previous clientConferenceId");
            String clientName = WBUtils.readUTF(istr, "ClientSendsScreenSynch reads clientName");
            buf.append(", clientId=" + clientId);
            buf.append(", clientConferenceId=" + clientConferenceId);
            buf.append(", clientName='" + clientName + "'");
            buf.append(DataModelData.streamToString(istr));
            boolean bl = clientRejoins = this.context.getConferenceUID() != clientConferenceId;
            if (clientRejoins) {
                buf.append("\n   CLIENT JOINS FRESH CONFERENCE\n");
            } else {
                buf.append("\n   CLIENT REJOINS CONFERENCE\n");
            }
            HashMap clientMedia = this.context.getMediaCache().readDefinedMedia(istr);
            for (Object id : clientMedia.keySet()) {
                buf.append(" \n Client has media: " + id + " data: " + clientMedia.get(id));
            }
        }
        catch (Exception e) {
            LogSupport.exception((Object)this, (String)"streamToString", (Throwable)e, (boolean)true);
            buf.append("\n  Exception: " + e.getMessage());
        }
        return buf.toString();
    }
}

