/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.conference;

import com.elluminate.groupware.whiteboard.conference.ViewedScreen;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import java.util.LinkedList;

class AvailableScreenEntry {
    ScreenModel screen = null;
    LinkedList viewersList = null;
    AvailableScreenEntry next = null;
    AvailableScreenEntry prev = null;

    public AvailableScreenEntry(ScreenModel screen) {
        this.screen = screen;
        this.next = null;
        this.prev = null;
        this.viewersList = null;
    }

    public void addViewer(ViewedScreen viewedScreen) {
        if (this.viewersList == null) {
            this.viewersList = new LinkedList();
        }
        this.viewersList.add(viewedScreen);
    }

    public void removeViewer(ViewedScreen viewedScreen) {
        if (this.viewersList != null) {
            this.viewersList.remove(viewedScreen);
            if (this.viewersList.isEmpty()) {
                this.viewersList = null;
            }
        }
    }

    public void moveViewerList(AvailableScreenEntry entry) {
        if (this.viewersList == null) {
            this.viewersList = entry.viewersList;
        } else {
            if (this.viewersList.removeAll(entry.viewersList)) {
                throw new RuntimeException("ViewedScreen entry duplication in AvailableScreenEntry ViewersList");
            }
            this.viewersList.addAll(entry.viewersList);
        }
        entry.viewersList = null;
    }

    public void dispose() {
        if (this.viewersList != null) {
            this.viewersList.clear();
            this.viewersList = null;
        }
        this.next = null;
        this.prev = null;
    }
}

