/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.conference;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.comm.AbstractCommContainer;
import com.elluminate.groupware.whiteboard.conference.ParticipantData;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.ObjectUID;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.util.log.LogSupport;
import java.io.IOException;

public class AcknowledgeDeletion
extends AbstractCommContainer {
    private Long uid = null;
    private short revision = 0;

    public AcknowledgeDeletion(WhiteboardContext context) {
        super(context, "_AckDeletion");
    }

    public AcknowledgeDeletion(WhiteboardContext context, Long uid, short revision) {
        this(context);
        this.uid = uid;
        this.revision = revision;
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        try {
            super.streamToObject(istr);
            Long uid = ObjectUID.objectUIDFromStream(istr);
            short revision = WBUtils.readShort(istr, "AckDeletion reads revision");
            ParticipantData data = this.context.getDataExporter().getParticipantData(istr.getOriginatorId());
            if (data != null) {
                data.acknowledgeDeletion(uid, revision);
            }
        }
        catch (IOException ioe) {
            LogSupport.exception((Object)this, (String)"streamToObject", (Throwable)ioe, (boolean)true);
        }
        return null;
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
        ObjectUID.objectUIDToStream(this.uid, ostr);
        ostr.writeShort(this.revision);
    }

    @Override
    public String streamToString(WBInputStream istr) {
        StringBuffer buf = new StringBuffer(super.streamToString(istr));
        try {
            Long uid = ObjectUID.objectUIDFromStream(istr);
            short revision = WBUtils.readShort(istr, "AckDeletion reads revision");
            buf.append("Acknowledge Deletion: " + revision + ":" + uid + " from clientId: " + istr.getOriginatorId() + "\n");
        }
        catch (IOException ioe) {
            LogSupport.exception((Object)this, (String)"streamToString", (Throwable)ioe, (boolean)true);
            buf.append("\n  Exception: " + ioe.getMessage());
        }
        return buf.toString();
    }
}

