/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.comm;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.acl.ACLEntry;
import com.elluminate.groupware.whiteboard.comm.AbstractCommContainer;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.ObjectUID;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.interfaces.StreamableObject;
import com.elluminate.util.ShortList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class GoToScreen
extends AbstractCommContainer {
    static final String GOTO_NAME = "_GoToScreen";
    static final boolean DEBUG = false;
    Long screenUID;
    Short groupId;

    public GoToScreen(WhiteboardContext context) {
        this(context, null, ACLEntry.ALL_GROUPS);
    }

    public GoToScreen(WhiteboardContext context, Long screenUID) {
        this(context, screenUID, ACLEntry.ALL_GROUPS);
    }

    public GoToScreen(WhiteboardContext context, Long screenUID, Short groupId) {
        super(context, GOTO_NAME);
        this.screenUID = screenUID;
        this.groupId = groupId == null ? ACLEntry.NULL_GROUP : groupId;
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
        ObjectUID.objectUIDToStream(this.screenUID, ostr);
        ostr.writeShort(this.groupId.shortValue());
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        LinkedList<Short> targets = new LinkedList<Short>();
        super.streamToObject(istr);
        Long screenUID = ObjectUID.objectUIDFromStream(istr);
        Short groupId = ShortList.get((short)WBUtils.readShort(istr, "GoToScreen reads client groupId"));
        if (this.context.isClient()) {
            this.context.getGroupManager().setScreenUID(groupId, screenUID);
            this.context.gotoScreen(screenUID, true);
        } else {
            try {
                GoToScreen gotoScreen = new GoToScreen(this.context, screenUID, groupId);
                if (this.context.getIDProcessor().isChair(istr.getOriginatorId())) {
                    this.context.getGroupManager().setFollowInstructor(groupId, screenUID);
                    Iterator iter = this.context.getIDProcessor().getClientIdEntryIterator();
                    while (iter.hasNext()) {
                        Short clientAddress;
                        Map.Entry entry = (Map.Entry)iter.next();
                        Short clientId = (Short)entry.getValue();
                        Short clientGroup = this.context.getIDProcessor().getGroupId(clientId);
                        if (!groupId.equals(ACLEntry.ALL_GROUPS) && !groupId.equals(clientGroup) || (clientAddress = this.context.getIDProcessor().getClientAddress(clientId)) == 0) continue;
                        targets.add(clientAddress);
                    }
                    short[] targetArray = new short[targets.size()];
                    int index = 0;
                    iter = targets.iterator();
                    while (iter.hasNext()) {
                        targetArray[index++] = (Short)iter.next();
                    }
                    this.context.getDataProcessor().sendDirective((byte)5, (StreamableObject)gotoScreen, targetArray);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String streamToString(WBInputStream istr) {
        StringBuffer buf = new StringBuffer(super.streamToString(istr));
        try {
            Long screenUID = ObjectUID.objectUIDFromStream(istr);
            Short groupId = ShortList.get((short)WBUtils.readShort(istr, "GoToScreen reads client groupId"));
            buf.append(this.getName() + " reads goto: " + screenUID + ", for group: " + groupId);
        }
        catch (Exception e) {
            buf.append(this.getName() + " gets Exception: " + e.getMessage());
        }
        return buf.toString();
    }
}

