/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.attributes.subattributes;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.attributes.subattributes.StyleSubAttribute;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import java.io.IOException;
import org.jdom.Attribute;
import org.jdom.Content;

public class FontSubAttribute
extends StyleSubAttribute {
    static final String toolName = "FontSubAttribute";
    private String fontName = new String();
    private int fontStyle = 0;
    private int fontSize = 0;
    private boolean underline = false;

    public FontSubAttribute(WhiteboardContext context) {
        this(context, toolName);
    }

    public FontSubAttribute(WhiteboardContext context, String name) {
        super(context, name);
    }

    public FontSubAttribute(WhiteboardContext context, String name, int id) {
        super(context, name, id);
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public void setFontStyle(int fontStyle) {
        this.fontStyle = fontStyle;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public void setUnderline(boolean underline) {
        this.underline = underline;
    }

    public String getFontName() {
        return this.fontName;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    @Override
    public void merge(AbstractAttribute newAttribute) {
        if (newAttribute instanceof FontSubAttribute) {
            super.merge(newAttribute);
            this.setAttributeNotificationSuppression();
            FontSubAttribute newSubAttr = (FontSubAttribute)newAttribute;
            this.setFontName(newSubAttr.getFontName());
            this.setFontSize(newSubAttr.getFontSize());
            this.setFontStyle(newSubAttr.getFontStyle());
            this.setUnderline(newSubAttr.isUnderline());
            this.clearAttributeNotificationSuppression(true);
        }
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        super.streamToObject(istr);
        String name = WBUtils.readUTF(istr, "FontSubAttribute Name");
        int size = WBUtils.readInt(istr, "FontSubAttribute Size");
        int style = WBUtils.readInt(istr, "FontSubAttribute Style");
        boolean underline = WBUtils.readBoolean(istr, "FontSubAttribute underline");
        this.setFontName(name);
        this.setFontSize(size);
        this.setFontStyle(style);
        this.setUnderline(underline);
        return null;
    }

    @Override
    public String streamToString(WBInputStream istr) {
        try {
            String name = WBUtils.readUTF(istr, "FontSubAttribute Name");
            int size = WBUtils.readInt(istr, "FontSubAttribute Size");
            int style = WBUtils.readInt(istr, "FontSubAttribute Style");
            boolean underline = WBUtils.readBoolean(istr, "FontSubAttribute underline");
            return this.getName() + ": Font Name=" + name + ", Size=" + Integer.toHexString(size) + ", Style=" + Integer.toHexString(style) + ", Underline=" + Boolean.toString(underline);
        }
        catch (IOException ioe) {
            return this.getName() + " IOException: " + ioe.getMessage();
        }
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
        ostr.writeUTF(this.getFontName());
        ostr.writeInt(this.getFontSize());
        ostr.writeInt(this.getFontStyle());
        ostr.writeBoolean(this.isUnderline());
    }

    @Override
    public RegisteredTemplate elementToObject(WBElement element, ProgressUpdate progress) throws Exception {
        super.elementToObject(element, progress);
        this.fontSize = 18;
        this.fontStyle = 0;
        this.fontName = "Serif";
        this.underline = false;
        String fontNameString = element.getAttributeValue("name");
        if (fontNameString != null && !fontNameString.equals("")) {
            this.fontName = fontNameString;
        }
        String fontStyleString = element.getAttributeValue("style");
        try {
            if (fontStyleString != null && !fontStyleString.equals("")) {
                this.fontStyle = Integer.valueOf(fontStyleString);
            }
        }
        catch (Exception e) {
            throw new Exception(this.getName() + ": Invalid integer value for style: " + fontStyleString);
        }
        String fontSizeString = element.getAttributeValue("size");
        try {
            if (fontSizeString != null && !fontSizeString.equals("")) {
                this.fontSize = Integer.valueOf(fontSizeString);
            }
        }
        catch (Exception e) {
            throw new Exception(this.getName() + ": Invalid integer value for size: " + fontSizeString);
        }
        String underlineString = element.getAttributeValue("underline");
        try {
            if (underlineString != null && !underlineString.equals("")) {
                this.underline = Boolean.valueOf(underlineString);
            }
        }
        catch (Exception e) {
            throw new Exception(this.getName() + ": Invalid boolean value for Underline: " + underlineString);
        }
        return null;
    }

    @Override
    public WBElement objectToElement(WBElement parent, ProgressUpdate progress) throws Exception {
        WBElement tf = new WBElement(this.getName());
        super.objectToElement(parent, tf, progress);
        if (!this.fontName.equals("Serif")) {
            tf.setAttribute(new Attribute("name", this.fontName));
        }
        if (this.fontStyle != 0) {
            tf.setAttribute(new Attribute("style", Integer.toString(this.fontStyle)));
        }
        if (this.fontSize != 18) {
            tf.setAttribute(new Attribute("size", Integer.toString(this.fontSize)));
        }
        if (this.underline) {
            tf.setAttribute(new Attribute("underline", Boolean.toString(this.underline)));
        }
        parent.addContent((Content)tf);
        return null;
    }

    @Override
    public WBElement objectToElement(WBElement parent, WBElement tf, ProgressUpdate progress) throws Exception {
        super.objectToElement(parent, tf, progress);
        if (!this.fontName.equals("Serif")) {
            tf.setAttribute(new Attribute("name", this.fontName));
        }
        if (this.fontStyle != 0) {
            tf.setAttribute(new Attribute("style", Integer.toString(this.fontStyle)));
        }
        if (this.fontSize != 18) {
            tf.setAttribute(new Attribute("size", Integer.toString(this.fontSize)));
        }
        if (this.underline) {
            tf.setAttribute(new Attribute("underline", Boolean.toString(this.underline)));
        }
        return null;
    }

    @Override
    public String toString() {
        return super.toString() + ", fontName: " + this.fontName + ", Style: " + this.fontStyle + " Size: " + this.fontSize + ", underline: " + this.underline;
    }
}

