/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.attributes.subattributes;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import java.io.IOException;
import org.jdom.Attribute;
import org.jdom.Content;

public abstract class AbstractSubAttribute
extends AbstractAttribute {
    static final String toolName = "SubAttribute";
    private int saId = 1;

    public AbstractSubAttribute(WhiteboardContext context) {
        this(context, toolName);
    }

    public AbstractSubAttribute(WhiteboardContext context, String name) {
        super(context, name);
    }

    public AbstractSubAttribute(WhiteboardContext context, String name, int id) {
        this(context, name);
        this.saId = id;
    }

    public void setSaId(int id) {
        this.saId = id;
    }

    public int getSaId() {
        return this.saId;
    }

    @Override
    public void merge(AbstractAttribute newAttribute) {
        if (newAttribute instanceof AbstractSubAttribute) {
            this.setAttributeNotificationSuppression();
            AbstractSubAttribute newSubAttr = (AbstractSubAttribute)newAttribute;
            this.setSaId(newSubAttr.getSaId());
            this.clearAttributeNotificationSuppression(true);
        }
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        super.streamToObject(istr);
        int id = WBUtils.readInt(istr, "StyleSubAttribute Style Id");
        this.setSaId(id);
        return null;
    }

    @Override
    public String streamToString(WBInputStream istr) {
        try {
            int id = WBUtils.readInt(istr, "StyleSubAttribute Style Id");
            return this.getName() + ": StyleId=" + Integer.toHexString(id);
        }
        catch (IOException ioe) {
            return this.getName() + " IOException: " + ioe.getMessage();
        }
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
        ostr.writeInt(this.getSaId());
    }

    @Override
    public RegisteredTemplate elementToObject(WBElement element, ProgressUpdate progress) throws Exception {
        int id = 0;
        String idString = element.getAttributeValue("id");
        if (idString != null && !idString.equals("")) {
            try {
                id = Integer.parseInt(idString);
            }
            catch (Exception e) {
                throw new Exception(this.getName() + ": Invalid integer value for StyleId: " + idString);
            }
        }
        this.setSaId(id);
        return null;
    }

    @Override
    public WBElement objectToElement(WBElement parent, ProgressUpdate progress) throws Exception {
        WBElement tf = new WBElement(this.getName());
        tf.setAttribute(new Attribute("id", Integer.toString(this.saId)));
        parent.addContent((Content)tf);
        return null;
    }

    public WBElement objectToElement(WBElement parent, WBElement tf, ProgressUpdate progress) throws Exception {
        tf.setAttribute(new Attribute("id", Integer.toString(this.saId)));
        return null;
    }

    @Override
    public String toString() {
        return this.getName() + ", id: " + this.saId;
    }
}

