/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.attributes;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.attributes.ImageTooBigException;
import com.elluminate.groupware.whiteboard.attributes.StringsProperties;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.MediaData;
import com.elluminate.groupware.whiteboard.dataModel.MediaEvent;
import com.elluminate.groupware.whiteboard.dataModel.MediaID;
import com.elluminate.groupware.whiteboard.dataModel.MediaItem;
import com.elluminate.groupware.whiteboard.dataModel.MediaListener;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.ImageToolModel;
import com.elluminate.groupware.whiteboard.xml.DeferredImageContent;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import com.elluminate.platform.Platform;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.StringUtils;
import com.elluminate.util.image.ImageInfo;
import com.elluminate.util.image.ImageMimeUtilities;
import com.elluminate.util.image.ImageSupport;
import com.elluminate.util.image.gif.AnimationFrame;
import com.elluminate.util.image.gif.AnimationInstance;
import com.elluminate.util.image.gif.GifFile;
import com.elluminate.util.image.gif.ImageObject;
import com.elluminate.util.io.IOUtilities;
import com.elluminate.util.log.LogSupport;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import org.jdom.Attribute;
import org.jdom.Content;

public class WBImage
extends AbstractAttribute
implements Cloneable,
MediaListener {
    private MediaData mediaData = null;
    private String imageFilename = null;
    private String imageFileMimeType = null;
    private Dimension imageSize = null;
    private AnimationInstance animationInstance = null;
    private String errorMessage = null;
    private PaletteType paletteType;

    public WBImage(WhiteboardContext context) {
        super(context, "Image");
        this.eraseImage();
    }

    public WBImage(WhiteboardContext context, File file) {
        this(context);
        this.loadImage(file);
    }

    public WBImage(WhiteboardContext context, String filename) {
        this(context);
        this.loadImage(filename);
    }

    public WBImage(WhiteboardContext context, byte[] buf, String fileName, String displayName) {
        this(context);
        this.loadImage(buf, fileName, displayName);
    }

    public WBImage(WhiteboardContext context, WBElement element, ProgressUpdate update) {
        this(context);
    }

    public WBImage(WhiteboardContext context, DataInputStream istr) {
        this(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.mediaData != null) {
                this.removeMedia();
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        WBImage newImage = new WBImage(this.context);
        newImage.imageSize = this.imageSize;
        newImage.imageFilename = this.imageFilename;
        newImage.imageFileMimeType = this.imageFileMimeType;
        newImage.animationInstance = null;
        newImage.displayName = this.displayName;
        newImage.paletteType = this.paletteType;
        if (this.mediaData != null) {
            newImage.hookMediaData(this.mediaData);
        }
        return newImage;
    }

    @Override
    public void removeFromConference() {
        if (this.mediaData != null && this.getParent().isConferenceNode()) {
            this.context.getDataExporter().removeMedia(this.mediaData);
        }
    }

    @Override
    public void delete() {
        this.removeMedia();
        this.imageFileMimeType = null;
        this.imageSize = null;
        super.delete();
    }

    public boolean loadImage(File file) {
        ImageObject imageObject;
        byte[] imageFileBuffer;
        block10: {
            imageFileBuffer = null;
            this.removeMedia();
            this.setImageFilename(file.getPath());
            this.displayName = file.getName();
            this.setMimeType(file.getName(), Platform.getMimeType((File)file));
            this.errorMessage = null;
            try {
                if (ImageMimeUtilities.isCommonImageFile((File)file)) {
                    imageFileBuffer = this.readFile(file);
                    imageObject = this.getImageObject(imageFileBuffer, file.getPath());
                    if (imageObject == null) {
                        this.imageFileMimeType = null;
                        return false;
                    }
                    if (!this.imageFileMimeType.equals(Platform.getMimeType((String)this.imageFilename))) {
                        this.imageFilename = this.imageFilename + "." + Platform.getSuffix((String)this.imageFileMimeType);
                    }
                    break block10;
                }
                imageFileBuffer = null;
                return false;
            }
            catch (FileNotFoundException fe) {
                this.errorMessage = fe.getMessage();
                this.imageFileMimeType = null;
                return false;
            }
            catch (ImageTooBigException itb) {
                Object imageObject2 = null;
                this.imageFileMimeType = null;
                this.errorMessage = itb.getMessage();
                return false;
            }
            catch (IOException ie) {
                this.errorMessage = ie.getMessage();
                LogSupport.exception((Object)this, (String)"loadImage", (Throwable)ie, (boolean)true);
                this.imageFileMimeType = null;
                return false;
            }
            catch (RuntimeException r) {
                r.printStackTrace();
                Object imageObject2 = null;
                this.imageFileMimeType = null;
                this.errorMessage = r.getMessage();
                return false;
            }
            catch (Throwable t) {
                this.imageFileMimeType = null;
                this.errorMessage = t.getMessage();
                LogSupport.error((Object)this, (String)"loadImage", (String)t.getMessage());
                return false;
            }
        }
        if (imageObject.isScaled()) {
            imageFileBuffer = ImageSupport.encodeImage((Image)imageObject.getAnimationFrame().getImage(), (String)imageObject.getMimeType(), (int)90);
        }
        this.cacheMediaData(imageFileBuffer);
        this.mediaData.setMediaInstance(imageObject);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFile(File file) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        try {
            IOUtilities.copyStream((InputStream)in, (OutputStream)out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException ignore) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean loadImage(String filename) {
        File fin = new File(filename);
        return this.loadImage(fin);
    }

    public boolean loadImage(byte[] buf, String name, String displayName) {
        this.removeMedia();
        this.setImageFilename(name);
        this.displayName = displayName;
        if (buf == null || name == null) {
            return false;
        }
        try {
            String mimeType = Platform.getMimeType((String)name);
            if (!ImageMimeUtilities.isCommonImageType((String)mimeType)) {
                return false;
            }
        }
        catch (Throwable t) {
            LogSupport.error((Object)this, (String)"loadImage", (String)t.getMessage());
            return false;
        }
        this.cacheMediaData(buf);
        return true;
    }

    public boolean hasImage() {
        return this.mediaData != null ? this.mediaData.getMediaID().getLength() > 0 : false;
    }

    public boolean imageExists() {
        return this.imageFileMimeType != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageObject getImageObject() {
        if (this.mediaData == null) {
            return null;
        }
        ImageObject imageObject = null;
        SoftReference imageRef = null;
        MediaData mediaData = this.mediaData;
        synchronized (mediaData) {
            imageRef = this.mediaData.getMediaInstance();
            if ((imageRef == null || imageRef.get() == null) && this.hasImage()) {
                if (this.getImageBytes() != null) {
                    try {
                        imageObject = this.getImageObject(this.getImageBytes(), this.getImageFilename());
                        this.mediaData.setMediaInstance(imageObject);
                    }
                    catch (RuntimeException re) {
                        return null;
                    }
                }
            } else {
                imageObject = imageRef != null ? (ImageObject)imageRef.get() : null;
            }
        }
        if (this.animationInstance == null && imageObject != null && this.canAnimate() && imageObject.getFrameCount() > 1) {
            this.animationInstance = new Animation(imageObject);
        }
        this.context.getMediaCache().noteMediaReference(this.mediaData);
        return imageObject;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public String getImageFilename() {
        return this.imageFilename;
    }

    public void setImageFilename(String name) {
        String mimeType = Platform.getMimeType((String)name);
        if (!ImageMimeUtilities.isCommonImageType((String)mimeType)) {
            mimeType = "application/x-octet-stream";
        }
        this.setMimeType(name, mimeType);
    }

    public byte[] getImageBytes() {
        return this.mediaData != null ? this.mediaData.getMedia() : null;
    }

    public void setImageBytes(byte[] buf, String name) {
        this.removeMedia();
        this.cacheMediaData(buf);
        this.notifyVisibleChange();
        this.setImageFilename(name);
    }

    public void eraseImage() {
        this.removeMedia();
        this.imageFilename = null;
        this.imageFileMimeType = null;
        this.imageSize = null;
    }

    public Dimension getSize() {
        if (this.imageSize == null) {
            if (this.context.getController() != null) {
                ImageObject imageObject = null;
                try {
                    imageObject = this.getImageObject();
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                if (imageObject == null || imageObject.getHeight() * imageObject.getWidth() > 4000000) {
                    this.eraseImage();
                    this.imageSize = new Dimension(0, 0);
                    this.imageFileMimeType = null;
                } else {
                    this.imageSize = new Dimension(imageObject.getWidth(), imageObject.getHeight());
                }
            } else {
                this.imageSize = new Dimension(0, 0);
            }
        }
        return this.imageSize;
    }

    public void setSize(Dimension size) {
        this.imageSize = size;
    }

    private void realizeUncachedSize() {
        this.getSize();
        if (this.mediaData != null && this.context.getMediaCache().getRefCount(this.mediaData.getMediaID()) <= 1) {
            this.mediaData.setMediaInstance(null);
        }
    }

    public boolean isInBackground() {
        return this.getPaletteType() == PaletteType.BACKGROUND;
    }

    public PaletteType getPaletteType() {
        if (this.paletteType == null) {
            return PaletteType.CLIPART;
        }
        return this.paletteType;
    }

    public void setPaletteType(PaletteType paletteType) {
        this.paletteType = paletteType;
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        super.streamToObject(istr);
        boolean hasImage = WBUtils.readBoolean(istr, "WBImage hasimage");
        if (!hasImage) {
            return new WBImage(this.context);
        }
        this.setImageFilename(WBUtils.readUTF(istr, "WBImage name"));
        String type = WBUtils.readUTF(istr, "WBImage type");
        this.setPaletteType(PaletteType.valueOf(type));
        short width = WBUtils.readShort(istr, "WBImage width");
        short height = WBUtils.readShort(istr, "WBImage height");
        this.imageSize = width != 0 && height != 0 ? new Dimension(width, height) : null;
        this.hookMediaData(new MediaData(this.context, MediaID.streamToObject(istr)));
        if (this.context.getMediaCache().contains(this.mediaData.getMediaID())) {
            this.mediaData = this.context.getMediaCache().getMediaItem(this.mediaData.getMediaID()).getMediaData();
            this.useMedia();
        }
        this.context.getDataExporter().incrementMediaReceived(this.mediaData, istr.getOriginatorId());
        return null;
    }

    @Override
    public String streamToString(WBInputStream istr) {
        try {
            boolean hasImage = istr.readBoolean();
            if (!hasImage) {
                return this.getName() + ": no image";
            }
            String name = istr.readUTF();
            String type = istr.readUTF();
            short width = WBUtils.readShort(istr, "WBImage width");
            short height = WBUtils.readShort(istr, "WBImage height");
            MediaID mediaID = MediaID.streamToObject(istr);
            return this.getName() + ": name=" + name + " type=" + type + ", width=" + width + ", height=" + height + mediaID;
        }
        catch (Exception e) {
            return this.getName() + " Exception: " + e.getMessage();
        }
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
        boolean b = this.hasImage() && this.imageFilename != null;
        ostr.writeBoolean(b);
        if (b) {
            ostr.writeUTF(this.imageFilename);
            ostr.writeUTF(this.getPaletteType().toString());
            if (this.getSize() != null) {
                ostr.writeShort(this.getSize().width);
                ostr.writeShort(this.getSize().height);
            } else {
                ostr.writeShort(0);
                ostr.writeShort(0);
            }
            this.mediaData.getMediaID().objectToStream(ostr);
        }
    }

    @Override
    public RegisteredTemplate elementToObject(WBElement element, ProgressUpdate progress) {
        byte[] bytes;
        long imageCRC = 0L;
        Attribute crcAttribute = null;
        String imageName = null;
        PaletteType imgType = null;
        this.imageSize = null;
        int imageLength = 0;
        try {
            imageName = element.getAttributeValue("name");
            imageLength = element.getAttribute("size").getIntValue();
            crcAttribute = element.getAttribute("CRC");
            if (crcAttribute != null) {
                imageCRC = crcAttribute.getLongValue();
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"elementToObject", (Throwable)ex, (boolean)false, (String)"parsing name and size");
            return new WBImage(this.context);
        }
        try {
            imgType = PaletteType.valueOf(element.getAttributeValue("type"));
        }
        catch (Exception ex) {
            imgType = PaletteType.CLIPART;
        }
        try {
            int width = element.getAttribute("w").getIntValue();
            int height = element.getAttribute("h").getIntValue();
            this.imageSize = new Dimension(width, height);
        }
        catch (Exception e1) {
            // empty catch block
        }
        if (crcAttribute != null) {
            MediaItem mediaItem = this.context.getMediaCache().getMediaItem(new MediaID(imageLength, imageCRC));
            bytes = mediaItem != null && mediaItem.getMediaData() != null ? mediaItem.getMediaData().getMedia() : new byte[]{};
        } else {
            bytes = StringUtils.bytesFromHex((String)element.getText());
            element.getParent().removeContent((Content)element);
        }
        this.loadImage(bytes, imageName, imageName);
        if (this.imageSize == null) {
            this.realizeUncachedSize();
        }
        this.setPaletteType(imgType);
        return null;
    }

    @Override
    public WBElement objectToElement(WBElement parent, ProgressUpdate progress) {
        WBElement imElement = new WBElement(this.getName());
        if (this.getImageBytes() != null) {
            imElement.setAttribute(new Attribute("name", this.getImageFilename()));
            imElement.setAttribute(new Attribute("type", this.getPaletteType().toString()));
            imElement.setAttribute(new Attribute("size", Integer.toString(this.getImageBytes().length)));
            imElement.setAttribute(new Attribute("w", Integer.toString(this.getSize().width)));
            imElement.setAttribute(new Attribute("h", Integer.toString(this.getSize().height)));
            if (this.context.getMediaCache().isMediaSaveable(this.mediaData.getMediaID())) {
                imElement.setAttribute(new Attribute("CRC", Long.toString(this.mediaData.getMediaID().getCRC())));
            } else {
                imElement.addContent((Content)new DeferredImageContent(this.getImageBytes()));
            }
        } else {
            imElement.setAttribute(new Attribute("name", "dummy.png"));
            imElement.setAttribute(new Attribute("type", this.getPaletteType().toString()));
            imElement.setAttribute(new Attribute("size", "0"));
            imElement.setAttribute(new Attribute("w", "0"));
            imElement.setAttribute(new Attribute("h", "0"));
        }
        parent.addContent((Content)imElement);
        return null;
    }

    @Override
    public void merge(AbstractAttribute newAttribute) {
        if (newAttribute instanceof WBImage) {
            this.setAttributeNotificationSuppression();
            WBImage newImage = (WBImage)newAttribute;
            if (newImage.hasImage() && newImage.getImageBytes() != null) {
                this.loadImage(this.getImageBytes(), newImage.imageFilename, newImage.getDisplayName());
            }
            this.clearAttributeNotificationSuppression(true);
        }
    }

    private void setMimeType(String name, String mimeType) {
        if (mimeType == null) {
            LogSupport.error((Object)this, (String)"setMimeType", (String)"Set mime type null");
            Thread.dumpStack();
        }
        this.setAttributeChanged();
        this.imageFilename = name;
        this.imageFileMimeType = mimeType;
    }

    @Override
    public String toString() {
        long value = -1L;
        int length = -1;
        if (this.mediaData != null) {
            value = this.mediaData.getMediaID().getCRC();
            length = this.mediaData.getMediaID().getLength();
        }
        return super.toString() + "[nm=" + this.imageFilename + ",buf.len=" + length + ",crc=" + value + "]";
    }

    private ImageObject getImageObject(byte[] imageFileBuffer, String name) {
        if (this.imageFileMimeType == null) {
            LogSupport.error((Object)this, (String)"getImageIcon", (String)"Null mime type");
            Thread.dumpStack();
        }
        return this.getImageObject(imageFileBuffer, this.imageFileMimeType, name);
    }

    private ImageObject getImageObject(byte[] imageFileBuffer, String mimeType, String name) {
        ImageObject imageObject = null;
        if (mimeType.equals("image/gif")) {
            GifFile gifFile = new GifFile(imageFileBuffer, name);
            try {
                if (this.context.getMediaCache().instanceTooBig(gifFile.getImageCount() * gifFile.getHeight() * gifFile.getWidth())) {
                    if (this.mediaData != null) {
                        this.mediaData.setMedia(null);
                    }
                    gifFile.dispose();
                    gifFile = null;
                    throw new ImageTooBigException(i18n.getString((PropertiesEnum)StringsProperties.WBIMAGE_CACHELIMIT, new Object[]{name}));
                }
                imageObject = new ImageObject(gifFile, name);
            }
            catch (InterruptedException ie) {
                imageObject = null;
            }
        } else {
            try {
                ImageInfo imgInfo = ImageSupport.loadImage((String)mimeType, (byte[])imageFileBuffer, (boolean)true);
                Image localImage = imgInfo.getImage();
                if (ImageSupport.waitForImage((Image)localImage)) {
                    imageObject = new ImageObject(imgInfo, name);
                }
                if (imageObject == null) {
                    throw new ImageTooBigException("Image is too big.");
                }
            }
            catch (ImageSupport.OversizeImageException oix) {
                this.delete();
                throw new ImageTooBigException(oix.getMessage());
            }
            catch (ImageSupport.InsufficientMemoryExcetpion ime) {
                this.delete();
                Dimension rs = ime.getReducedSize();
                throw new ImageTooBigException(i18n.getString((PropertiesEnum)StringsProperties.INSUFFICIENT_MEMORY_FOR_IMAGE, new Object[]{rs.width, rs.height}));
            }
            catch (Exception ex) {
                LogSupport.message((Object)this, (String)"getImageObject", (String)("image load failed: " + ex));
                ex.printStackTrace();
                this.delete();
            }
        }
        return imageObject;
    }

    private void mediaRemoved(MediaData mediaData) {
        if (this.mediaData != null && this.mediaData == mediaData) {
            this.context.getMediaCache().removeMediaListener(this);
            mediaData = null;
        }
    }

    private void removeMedia() {
        if (this.mediaData != null) {
            Long screenUID = this.getMediaScreen() != null ? this.getMediaScreen().getObjectID() : null;
            this.context.getMediaCache().removeMediaListener(this, this.mediaData);
            this.mediaData.remove(screenUID);
            this.mediaData = null;
        }
    }

    @Override
    public void addMediaRequest(Short clientId) {
        if (this.mediaData != null && this.mediaData.getMedia() != null) {
            this.context.getDataExporter().addMedia(clientId, this.getParent().getOriginator(), this.getParent().findScreenParent(), this.mediaData);
        }
    }

    private void cacheMediaData(byte[] imageFileBuffer) {
        this.hookMediaData(this.context.getMediaCache().newMediaData(imageFileBuffer));
    }

    private void hookMediaData(MediaData mediaData) {
        Long screenUID = null;
        this.removeMedia();
        this.mediaData = mediaData;
        if (this.getParent() != null && this.getParent().getScreenParent() != null) {
            screenUID = this.getParent().getScreenParent().getObjectID();
        }
        this.context.getMediaCache().add(this.mediaData, screenUID);
        this.context.getMediaCache().addMediaListener(this, this.mediaData);
    }

    private void useMedia() {
        if (this.getImageBytes() != null) {
            if (this.getParent() instanceof AbstractToolModel) {
                ((AbstractToolModel)this.getParent()).setUIInvalid(true);
            }
            this.notifyVisibleChange();
        }
    }

    @Override
    public boolean onMedia(MediaEvent mediaEvent) {
        boolean removeListener = false;
        if (mediaEvent.getEventType() == 1) {
            boolean addToConference = this.mediaData == null || this.mediaData.getMedia() == null;
            this.mediaData = mediaEvent.getMediaItem().getMediaData();
            try {
                if (this.context.getController() != null && (this.imageSize == null || this.imageSize.width == 0 || this.imageSize.height == 0)) {
                    this.realizeUncachedSize();
                    if (this.imageSize.width != 0 && this.imageSize.height != 0) {
                        Rectangle bounds = ((ImageToolModel)this.getParent()).getBounds();
                        bounds.width = this.imageSize.width;
                        bounds.height = this.imageSize.height;
                        ((ImageToolModel)this.getParent()).setBounds(bounds);
                    }
                }
                if (addToConference && this.mediaData != null && this.mediaData.getMedia() != null && this.getParent() != null) {
                    this.context.getDataExporter().addMedia(ScreenModel.BROADCAST_ADDRESS, mediaEvent.getOriginator(), this.getParent().findScreenParent(), this.mediaData);
                    this.context.getDataExporter().mediaReceived(this.mediaData, mediaEvent.getOriginator());
                }
                this.useMedia();
                removeListener = false;
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"onMedia", (Throwable)ex, (boolean)true);
            }
        } else if (mediaEvent.getEventType() == 2) {
            this.mediaRemoved(mediaEvent.getMediaItem().getMediaData());
            removeListener = true;
        }
        return removeListener;
    }

    @Override
    public ScreenModel getMediaScreen() {
        return this.getParent() == null ? null : this.getParent().getScreenParent();
    }

    public MediaData getMediaData() {
        return this.mediaData;
    }

    private boolean canAnimate() {
        ImageToolModel imageTool = (ImageToolModel)this.getParent();
        return this.hasImage() && imageTool != null && !imageTool.isDeleted();
    }

    public void imageRendered() {
        if (this.animationInstance != null && this.canAnimate()) {
            this.animationInstance.imageRendered(this.getImageObject());
        }
    }

    public Image getImage() {
        if (this.animationInstance != null) {
            return this.animationInstance.getAnimationFrame(this.getImageObject()).getImage();
        }
        return this.getImageObject().getAnimationFrame().getImage();
    }

    class Animation
    extends AnimationInstance {
        Animation(ImageObject imageObject) {
            super(imageObject);
        }

        protected boolean canAnimate() {
            return WBImage.this.canAnimate();
        }

        protected void animate(int xOffset, int yOffset, int width, int height) {
            ImageToolModel imageTool = (ImageToolModel)WBImage.this.getParent();
            if (imageTool == null || !imageTool.isDeleted()) {
                WBImage.this.context.getController().repaint(imageTool);
            }
        }

        protected AnimationFrame getFrame() {
            return WBImage.this.animationInstance.getAnimationFrame(WBImage.this.getImageObject());
        }
    }

    public static enum PaletteType {
        CLIPART,
        BACKGROUND;

    }
}

