/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.attributes;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import com.elluminate.util.log.LogSupport;
import java.io.DataInputStream;
import java.io.IOException;
import org.jdom.Content;

public class ToolText
extends AbstractAttribute
implements Cloneable {
    protected String text = "";
    private static final String toolName = "Text";

    public ToolText(WhiteboardContext context) {
        this(context, toolName);
    }

    public ToolText(WhiteboardContext context, String name) {
        super(context, name);
    }

    public ToolText(WhiteboardContext context, WBElement element, ProgressUpdate update) {
        this(context);
    }

    public ToolText(WhiteboardContext context, DataInputStream istr) {
        this(context);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public void delete() {
        this.setText(null);
        super.delete();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (this.text == null || text == null || !this.text.equals(text)) {
            this.notifyVisibleChange();
            this.text = text != null && text.length() > 10000 ? text.substring(0, 10000) : text;
            this.setAttributeChanged();
            this.notifySizingChange();
            this.notifyAttributeChange();
        }
    }

    @Override
    public void merge(AbstractAttribute newAttribute) {
        if (newAttribute instanceof ToolText) {
            this.setAttributeNotificationSuppression();
            ToolText newText = (ToolText)newAttribute;
            this.setText(newText.getText());
            this.clearAttributeNotificationSuppression(true);
        }
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        super.streamToObject(istr);
        this.notifyVisibleChange();
        this.setText(WBInputStream.readUTF(istr));
        this.notifySizingChange();
        this.notifyAttributeChange();
        return null;
    }

    @Override
    public String streamToString(WBInputStream istr) {
        try {
            return "Text=" + istr.readUTF();
        }
        catch (IOException ioe) {
            return this.getName() + " IOException: " + ioe.getMessage();
        }
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
        ostr.writeUTF(this.text);
    }

    @Override
    public RegisteredTemplate elementToObject(WBElement element, ProgressUpdate progress) throws Exception {
        this.setText(element.getText());
        return null;
    }

    @Override
    public WBElement objectToElement(WBElement parent, ProgressUpdate progress) {
        if (this.text != null) {
            WBElement textElement = new WBElement(toolName);
            textElement.setText(this.text);
            parent.addContent((Content)textElement);
        } else {
            LogSupport.error((String)"Null Text in objectToElement.");
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getName() + ": " + (this.text != null ? this.text : "");
    }
}

