/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.attributes;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttributeList;
import com.elluminate.groupware.whiteboard.attributes.subattributes.AbstractSubAttribute;
import com.elluminate.groupware.whiteboard.attributes.subattributes.StyleRunSubAttribute;

public class ToolStyleRunList
extends AbstractAttributeList {
    public ToolStyleRunList(WhiteboardContext context) {
        super(context);
    }

    public ToolStyleRunList(WhiteboardContext context, String toolName) {
        super(context, toolName);
    }

    public void insertUpdate(int offset, int length, int styleId, int docLen) {
        if (this.attributeList.size() == 0) {
            StyleRunSubAttribute firstRun = new StyleRunSubAttribute(this.context, this.getName(), offset, length, styleId);
            this.attributeList.add(firstRun);
            this.notifyVisibleChange();
            this.setAttributeChanged();
            this.notifySizingChange();
            this.notifyAttributeChange();
            return;
        }
        boolean updated = false;
        Object[] attributes = this.attributeList.toArray();
        for (int i = 0; i < attributes.length; ++i) {
            StyleRunSubAttribute sa = (StyleRunSubAttribute)attributes[i];
            int saEndPos = sa.getOffset() + sa.getLength();
            if (saEndPos < offset) continue;
            if (saEndPos == offset) {
                if (sa.getSaId() == styleId) {
                    sa.setLength(sa.getLength() + length);
                } else {
                    StyleRunSubAttribute colorChange = new StyleRunSubAttribute(this.context, sa.getName(), offset, length, styleId);
                    this.attributeList.add(colorChange);
                }
                updated = true;
                continue;
            }
            if (sa.getOffset() < offset) {
                if (sa.getSaId() != styleId) {
                    StyleRunSubAttribute colorChange = new StyleRunSubAttribute(this.context, sa.getName(), offset, length, styleId);
                    this.attributeList.add(colorChange);
                    int oldSaLength = sa.getLength();
                    sa.setLength(offset - sa.getOffset());
                    int newLen = oldSaLength - sa.getLength();
                    int endPos = offset + length;
                    StyleRunSubAttribute saNew = new StyleRunSubAttribute(this.context, sa.getName(), endPos, newLen, sa.getSaId());
                    this.attributeList.add(saNew);
                } else {
                    sa.setLength(sa.getLength() + length);
                }
                updated = true;
                continue;
            }
            if (sa.getOffset() < offset) continue;
            int newOffset = sa.getOffset() + length;
            if (newOffset > docLen) {
                this.attributeList.remove(sa);
            } else {
                sa.setOffset(newOffset);
            }
            updated = true;
        }
        if (!updated) {
            StyleRunSubAttribute sa = new StyleRunSubAttribute(this.context, this.getName(), offset, length, styleId);
            this.attributeList.add(sa);
        }
        this.notifyVisibleChange();
        this.setAttributeChanged();
        this.notifySizingChange();
        this.notifyAttributeChange();
    }

    public void changeUpdate(int offset, int length, int styleId) {
        if (this.attributeList.size() == 0) {
            StyleRunSubAttribute firstRun = new StyleRunSubAttribute(this.context, this.getName(), offset, length, styleId);
            this.attributeList.add(firstRun);
            this.notifyVisibleChange();
            this.setAttributeChanged();
            this.notifySizingChange();
            this.notifyAttributeChange();
            return;
        }
        int endPos = offset + length;
        boolean updated = false;
        Object[] attributes = this.attributeList.toArray();
        for (int i = 0; i < attributes.length; ++i) {
            StyleRunSubAttribute colorChange;
            StyleRunSubAttribute sa = (StyleRunSubAttribute)attributes[i];
            int saEndPos = sa.getOffset() + sa.getLength();
            if (saEndPos < offset) continue;
            if (sa.getOffset() >= offset && saEndPos <= endPos) {
                sa.setOffset(offset);
                sa.setLength(length);
                sa.setSaId(styleId);
                updated = true;
                continue;
            }
            if (sa.getOffset() < offset && saEndPos > endPos) {
                if (sa.getSaId() != styleId) {
                    colorChange = new StyleRunSubAttribute(this.context, sa.getName(), offset, length, styleId);
                    this.attributeList.add(colorChange);
                    sa.setLength(offset - sa.getOffset());
                    StyleRunSubAttribute saNew = new StyleRunSubAttribute(this.context, sa.getName(), endPos, saEndPos - endPos, sa.getSaId());
                    this.attributeList.add(saNew);
                }
                updated = true;
                continue;
            }
            if (sa.getOffset() < offset && this.isInRange(saEndPos, offset, endPos)) {
                if (sa.getSaId() == styleId) {
                    sa.setLength(sa.getLength() + (endPos - saEndPos));
                } else {
                    sa.setLength(offset - sa.getOffset());
                    colorChange = new StyleRunSubAttribute(this.context, sa.getName(), offset, length, styleId);
                    this.attributeList.add(colorChange);
                }
                updated = true;
                continue;
            }
            if (!this.isInRange(sa.getOffset(), offset, endPos) || saEndPos <= endPos) continue;
            if (sa.getSaId() == styleId) {
                sa.setOffset(offset);
                sa.setLength(saEndPos - offset);
            } else {
                sa.setLength(saEndPos - endPos);
                sa.setOffset(endPos);
                colorChange = new StyleRunSubAttribute(this.context, sa.getName(), offset, length, styleId);
                this.attributeList.add(colorChange);
            }
            updated = true;
        }
        if (!updated) {
            StyleRunSubAttribute sa = new StyleRunSubAttribute(this.context, this.getName(), offset, length, styleId);
            this.attributeList.add(sa);
        }
        this.notifyVisibleChange();
        this.setAttributeChanged();
        this.notifySizingChange();
        this.notifyAttributeChange();
    }

    public void removeUpdate(int offset, int length) {
        int endPos = offset + length;
        int newOffset = 0;
        int newLength = 0;
        boolean updated = false;
        Object[] attributes = this.attributeList.toArray();
        for (int i = attributes.length - 1; i >= 0; --i) {
            StyleRunSubAttribute sa = (StyleRunSubAttribute)attributes[i];
            int saEndPos = sa.getOffset() + sa.getLength();
            if (saEndPos < offset) continue;
            if (sa.getOffset() > endPos) {
                newOffset = sa.getOffset() - length;
                sa.setOffset(newOffset);
            } else if (this.isInRange(sa.getOffset(), offset, endPos)) {
                if (saEndPos <= endPos) {
                    this.attributeList.remove(sa);
                } else {
                    newOffset = offset;
                    newLength = sa.getLength() - (endPos - sa.getOffset());
                    sa.setOffset(newOffset);
                    sa.setLength(newLength);
                }
            } else if (this.isInRange(offset, sa.getOffset(), saEndPos)) {
                newLength = endPos <= saEndPos ? sa.getLength() - length : sa.getLength() - (saEndPos - offset);
                sa.setLength(newLength);
            }
            updated = true;
        }
        if (updated) {
            this.notifyVisibleChange();
            this.setAttributeChanged();
            this.notifySizingChange();
            this.notifyAttributeChange();
        }
    }

    @Override
    public void setAttribute(AbstractSubAttribute attribute) {
        this.attributeList.add(attribute);
    }

    @Override
    public AbstractSubAttribute attributeFactory() {
        return new StyleRunSubAttribute(this.context);
    }
}

