/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.attributes;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttributeMap;
import com.elluminate.groupware.whiteboard.attributes.subattributes.AbstractSubAttribute;
import com.elluminate.groupware.whiteboard.attributes.subattributes.SmileySubAttribute;

public class ToolSmileyMap
extends AbstractAttributeMap {
    private static final String toolName = "SMILEYMAP";

    public ToolSmileyMap(WhiteboardContext context) {
        super(context, toolName);
    }

    @Override
    public void setAttribute(Object attributeKey) {
        if (attributeKey instanceof String && !this.attributeMap.containsKey(attributeKey)) {
            String pattern = (String)attributeKey;
            SmileySubAttribute sa = (SmileySubAttribute)this.attributeFactory();
            sa.setSaId(this.getNextId());
            sa.setPattern(pattern);
            this.attributeMap.put(attributeKey, sa);
            this.getAttributeIdMap().put(new Integer(sa.getSaId()), sa);
            this.notifyVisibleChange();
            this.setAttributeChanged();
            this.notifySizingChange();
            this.notifyAttributeChange();
        }
    }

    @Override
    public AbstractSubAttribute getAttribute(Object attributeKey) {
        return (SmileySubAttribute)this.attributeMap.get(attributeKey);
    }

    @Override
    public Object attributeKeyFactory(AbstractSubAttribute sa) {
        if (sa instanceof SmileySubAttribute) {
            String theKey = ((SmileySubAttribute)sa).getPattern();
            return theKey;
        }
        return null;
    }

    @Override
    public AbstractSubAttribute attributeFactory() {
        return new SmileySubAttribute(this.context);
    }
}

