/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.attributes;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import com.elluminate.util.log.LogSupport;
import java.awt.Dimension;
import java.io.DataInputStream;
import java.io.IOException;

public class ScreenSize
extends AbstractAttribute
implements Cloneable {
    private Dimension size = new Dimension();

    public ScreenSize(WhiteboardContext context, boolean optional) {
        super(context, "ScreenSize");
        this.setOptional(optional);
    }

    public ScreenSize(WhiteboardContext context) {
        this(context, false);
    }

    public ScreenSize(WhiteboardContext context, WBElement element, ProgressUpdate update) {
        this(context);
    }

    public ScreenSize(WhiteboardContext context, DataInputStream istr) {
        this(context);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ScreenSize screenSize = (ScreenSize)super.clone();
        screenSize.size = new Dimension(this.size);
        return screenSize;
    }

    @Override
    public void delete() {
        super.delete();
    }

    @Override
    public boolean usesHeader() {
        return true;
    }

    @Override
    public void merge(AbstractAttribute newAttribute) {
        if (newAttribute instanceof ScreenSize) {
            this.setAttributeNotificationSuppression();
            ScreenSize newSize = (ScreenSize)newAttribute;
            this.setSize(newSize.getSize());
            this.clearAttributeNotificationSuppression(true);
        }
    }

    public Dimension getSize() {
        return new Dimension(this.size);
    }

    public void setSize(int width, int height) {
        this.setSize(width, height, true);
    }

    private void setSize(int width, int height, boolean notify) {
        if (this.size.width == width && this.size.height == height) {
            return;
        }
        if (notify) {
            this.notifyVisibleChange();
        }
        this.size.width = width;
        this.size.height = height;
        this.setAttributeChanged();
        if (notify) {
            this.notifySizingChange();
            this.notifyAttributeChange();
            if (this.getParent() != null && this.getParent().isConferenceNode() && this.context.getController() != null && this.context.getController().getScreen() == this.getParent()) {
                this.context.getController().processScaleChange();
            }
        } else {
            this.clearAttributeChanged();
        }
    }

    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    public void setSize(Dimension d, boolean notify) {
        this.setSize(d.width, d.height, notify);
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        super.streamToObject(istr);
        short w = WBUtils.readShort(istr, "ScreenSize dimension width");
        short h = WBUtils.readShort(istr, "ScreenSize dimension height");
        this.setSize(w, h);
        return null;
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
        ostr.writeShort(this.size.width);
        ostr.writeShort(this.size.height);
    }

    @Override
    public String streamToString(WBInputStream istr) {
        try {
            return this.getName() + " (" + istr.readShort() + ", " + istr.readShort() + ")";
        }
        catch (IOException ioe) {
            return this.getName() + " IOException: " + ioe.getMessage();
        }
    }

    @Override
    public RegisteredTemplate elementToObject(WBElement element, ProgressUpdate progress) throws Exception {
        if (element.getAttribute("size") != null) {
            try {
                char[] rectChars = element.getAttributeValue("size").toCharArray();
                int type = 0;
                int accumulator = 0;
                int width = 0;
                int height = 0;
                block10: for (int index = 0; index < rectChars.length; ++index) {
                    char c = rectChars[index];
                    switch (c) {
                        default: {
                            break;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            accumulator = accumulator * 10 + (c - 48);
                            break;
                        }
                        case ',': {
                            ++type;
                            accumulator = 0;
                        }
                    }
                    switch (type) {
                        case 0: {
                            width = accumulator;
                            continue block10;
                        }
                        case 1: {
                            height = accumulator;
                            continue block10;
                        }
                    }
                }
                this.setSize(width, height, false);
            }
            catch (Exception e) {
                throw new Exception(this.getName() + " Invalid digits in size: " + e.getMessage());
            }
        } else if (!this.isOptional()) {
            LogSupport.error((String)("Tool: " + this.getParent().getName() + " has no size, at line: " + element.getInstanceCount()));
        }
        return null;
    }

    @Override
    public WBElement objectToElement(WBElement parent, ProgressUpdate progress) {
        parent.setAttribute("size", "" + this.size.width + "," + this.size.height);
        return null;
    }

    @Override
    public String toString() {
        return super.toString() + " (" + this.size.width + ", " + this.size.height + ")";
    }
}

