/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.attributes;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import com.elluminate.groupware.whiteboard.xml.XMLUtils;
import org.jdom.Attribute;
import org.jdom.Content;

public class AltText
extends AbstractAttribute
implements Cloneable {
    private static final String ATTR_NAME = "AlternateText";
    private String text = "";

    public AltText(WhiteboardContext context) {
        super(context, "altText");
        this.setOptional(true);
    }

    public void setAltText(String text) {
        if (text != null) {
            this.text = text;
        }
    }

    public String getAltText() {
        return this.text;
    }

    @Override
    public void merge(AbstractAttribute newAttribute) {
    }

    @Override
    public RegisteredTemplate elementToObject(WBElement element, ProgressUpdate progress) throws Exception {
        try {
            this.text = XMLUtils.unescapeXMLUnicode(element.getAttributeValue(ATTR_NAME));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public WBElement objectToElement(WBElement parent, ProgressUpdate progress) throws Exception {
        WBElement notesElement = new WBElement(this.getName());
        notesElement.setAttribute(new Attribute(ATTR_NAME, XMLUtils.escapeXMLUnicode(this.text)));
        parent.addContent((Content)notesElement);
        return null;
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
        ostr.writeUTF(XMLUtils.escapeXMLUnicode(this.text));
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        super.streamToObject(istr);
        this.text = XMLUtils.unescapeXMLUnicode(WBUtils.readUTF(istr, "altText text"));
        this.notifyAttributeChange();
        return null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

