/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.attributes;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.attributes.subattributes.AbstractSubAttribute;
import com.elluminate.groupware.whiteboard.attributes.subattributes.StyleRunSubAttribute;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Content;

public abstract class AbstractAttributeList
extends AbstractAttribute {
    private static final String toolName = "ATTRIBUTELIST";
    protected List attributeList = new ArrayList();

    public AbstractAttributeList(WhiteboardContext context) {
        super(context, toolName);
    }

    public AbstractAttributeList(WhiteboardContext context, String toolName) {
        super(context, toolName);
    }

    public List getAttributeList() {
        return this.attributeList;
    }

    public void setAttributeList(List attributeList) {
        this.attributeList = attributeList;
    }

    protected boolean isInRange(int value, int fromVal, int toVal) {
        return value >= fromVal && value <= toVal;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AbstractAttributeList attribute = (AbstractAttributeList)super.clone();
        attribute.attributeList = new ArrayList();
        attribute.attributeList.addAll(this.attributeList);
        return attribute;
    }

    @Override
    public void merge(AbstractAttribute newAttribute) {
        if (newAttribute instanceof AbstractAttributeList) {
            AbstractAttributeList newList = (AbstractAttributeList)newAttribute;
            this.setAttributeList(newList.getAttributeList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextId() {
        List list = this.attributeList;
        synchronized (list) {
            int id = 1;
            if (this.attributeList.size() > 0) {
                StyleRunSubAttribute sa = (StyleRunSubAttribute)this.attributeList.get(this.attributeList.size() - 1);
                id = sa.getSaId() + 1;
            }
            return id;
        }
    }

    public abstract void setAttribute(AbstractSubAttribute var1);

    public abstract AbstractSubAttribute attributeFactory();

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        super.streamToObject(istr);
        int size = WBUtils.readInt(istr, "attributeList size");
        if (size > 0) {
            this.notifyVisibleChange();
            this.attributeList.clear();
            for (int i = 0; i < size; ++i) {
                AbstractSubAttribute sa = this.attributeFactory();
                sa.streamToObject(istr);
                this.attributeList.add(sa);
            }
            this.notifyAttributeChange();
        }
        return null;
    }

    @Override
    public String streamToString(WBInputStream istr) {
        try {
            int size = WBUtils.readInt(istr, "attributeList size");
            return this.getName() + ": Size=" + size;
        }
        catch (IOException ioe) {
            return this.getName() + " IOException: " + ioe.getMessage();
        }
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
        Object[] attributes = this.attributeList.toArray();
        int size = attributes.length;
        ostr.writeInt(size);
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                AbstractSubAttribute sa = (AbstractSubAttribute)attributes[i];
                sa.objectToStream(ostr);
            }
        }
    }

    @Override
    public RegisteredTemplate elementToObject(WBElement element, ProgressUpdate progress) throws Exception {
        List children = element.getChildren();
        if (children.size() > 0) {
            this.notifyVisibleChange();
            this.attributeList.clear();
            for (WBElement tf : children) {
                AbstractSubAttribute sa = this.attributeFactory();
                sa.elementToObject(tf, progress);
                this.attributeList.add(sa);
            }
            this.notifyAttributeChange();
        }
        return null;
    }

    @Override
    public WBElement objectToElement(WBElement parent, ProgressUpdate progress) throws Exception {
        WBElement tf = new WBElement(this.getName());
        Object[] attributes = this.attributeList.toArray();
        int size = attributes.length;
        tf.setAttribute(new Attribute("size", Integer.toString(size)));
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                AbstractSubAttribute sa = (AbstractSubAttribute)attributes[i];
                sa.objectToElement(tf, progress);
            }
        }
        parent.addContent((Content)tf);
        return null;
    }

    @Override
    public String toString() {
        String output = this.getName();
        for (AbstractSubAttribute sa : this.attributeList) {
            output = output + "\n" + sa.toString();
        }
        return output;
    }
}

