/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.attributes;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AttributeEditorInterface;
import com.elluminate.groupware.whiteboard.conference.ClientIdentification;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.ActivityDisplay;
import com.elluminate.groupware.whiteboard.dataModel.ModifiedByInformation;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.TemplateClassLoader;
import com.elluminate.groupware.whiteboard.dataModel.Validator;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.interfaces.AttributeList;
import com.elluminate.groupware.whiteboard.interfaces.JDOMTransferrable;
import com.elluminate.groupware.whiteboard.interfaces.VisibleNotifyObject;
import com.elluminate.util.I18n;
import com.elluminate.util.log.LogSupport;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import javax.swing.Icon;

public abstract class AbstractAttribute
extends RegisteredTemplate
implements Cloneable,
JDOMTransferrable,
ModifiedByInformation {
    protected static I18n i18n = null;
    private String alternateName = null;
    protected String displayName = "";
    private String panelKey = null;
    private Icon panelIcon = null;
    private boolean firstIconTry = true;
    private String tabName = "";
    private boolean firstNameTry = true;
    private String tabToolTip = "";
    private boolean firstTipTry = true;
    private boolean optional = false;
    private boolean suppressAttributeNotify = false;
    private boolean attributeChanged = false;
    private Short modifiedById = ClientIdentification.CLIENT_LOCAL;
    protected WBNode parent = null;
    private static TemplateClassLoader loader = null;
    private AttributeEditorInterface editorUI = null;
    protected String editorUIName = null;
    private boolean quickAttribute = false;
    private boolean suppressUI = false;
    private boolean needEditor = true;
    private boolean displayEditorOnActivation = false;

    public AbstractAttribute(WhiteboardContext context, String name) {
        this.setContext(context);
        this.setName(name);
        this.setDisplayName(name);
        this.setOriginator(ClientIdentification.NULL_CLIENT);
        if (i18n == null) {
            i18n = I18n.create((Object)this);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AbstractAttribute attribute = (AbstractAttribute)super.clone();
        attribute.parent = null;
        return attribute;
    }

    @Override
    public void delete() {
        this.alternateName = null;
        this.parent = null;
        super.delete();
    }

    @Override
    public Short getModfiedById() {
        return this.modifiedById;
    }

    @Override
    public void setModifiedById(Short modifiedById) {
        this.modifiedById = modifiedById;
        if (this.context.getController() != null && this.context.getBean() != null) {
            ((ActivityDisplay)((Object)this.context.getBean())).noteActivity(modifiedById, this.getParent());
        }
    }

    public boolean needsEditor() {
        return this.needEditor;
    }

    public void setNeedsEditor(boolean needEditor) {
        this.needEditor = needEditor;
    }

    public WBNode getParent() {
        return this.parent;
    }

    public void setParent(WBNode parent) {
        this.parent = parent;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getPanelKey() {
        return this.panelKey;
    }

    public String getTabName() {
        if (this.firstNameTry && this.panelKey != null) {
            try {
                this.tabName = i18n.getStringLegacy(this.panelKey + ".tabName");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.firstNameTry = false;
        return this.tabName == null ? this.panelKey : this.tabName;
    }

    public void setPanelKey(String panelKey) {
        this.panelKey = panelKey;
    }

    public Icon getTabIcon() {
        if (this.firstIconTry && this.panelKey != null) {
            try {
                this.panelIcon = i18n.getIcon(this.panelKey + ".tabIcon");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.firstIconTry = false;
        return this.panelIcon;
    }

    public String getTabToolTip() {
        if (this.firstTipTry && this.panelKey != null) {
            try {
                this.tabToolTip = i18n.getStringLegacy(this.panelKey + ".tabTip");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.firstTipTry = false;
        return this.tabToolTip;
    }

    public boolean isQuickAttribute() {
        return this.quickAttribute;
    }

    public void setQuickAttribute(boolean quickAttribute) {
        this.quickAttribute = quickAttribute;
    }

    public void notifyVisibleChange() {
        if (this.parent instanceof VisibleNotifyObject) {
            ((VisibleNotifyObject)((Object)this.parent)).notifyVisibleChange();
        }
    }

    public void notifySizingChange() {
        if (this.parent instanceof VisibleNotifyObject) {
            ((VisibleNotifyObject)((Object)this.parent)).notifySizingChange();
        }
    }

    public void removeFromConference() {
    }

    public boolean isSuppressUI() {
        return this.suppressUI;
    }

    public void setSuppressUI(boolean suppressUI) {
        this.suppressUI = suppressUI;
        if (suppressUI) {
            this.editorUI = null;
        }
    }

    public AttributeEditorInterface editorUIFactory(String uiName) {
        String message = null;
        try {
            if (loader == null) {
                loader = new TemplateClassLoader();
            }
            Object object = null;
            Class myClass = loader.loadClass(uiName, true);
            if (AttributeEditorInterface.class.isAssignableFrom(myClass)) {
                Constructor ctor = null;
                try {
                    ctor = myClass.getConstructor(WhiteboardContext.class);
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                if (ctor != null) {
                    object = ctor.newInstance(this.context);
                    return object;
                }
            }
            if ((object = myClass.newInstance()) instanceof AttributeEditorInterface) {
                ((AttributeEditorInterface)object).setContext(this.context);
                return object;
            }
        }
        catch (ClassNotFoundException ex) {
            message = ex.getMessage();
            LogSupport.exception((Object)this, (String)"editorUIFactory", (Throwable)ex, (boolean)true);
        }
        catch (IllegalAccessException ex) {
            message = ex.getMessage();
            LogSupport.exception((Object)this, (String)"editorUIFactory", (Throwable)ex, (boolean)true);
        }
        catch (InstantiationException ex) {
            message = ex.getMessage();
            LogSupport.exception((Object)this, (String)"editorUIFactory", (Throwable)ex, (boolean)true);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            message = cause != null ? cause.getMessage() : ex.getMessage();
            LogSupport.exception((Object)this, (String)"editorUIFactory", (Throwable)ex, (boolean)true);
        }
        throw new RuntimeException("Cannot intantiate editor UI class: " + uiName + "\n\t" + message);
    }

    public AttributeEditorInterface getEditorUI() {
        if (!this.suppressUI && this.editorUI == null && this.context.getController() != null && this.editorUIName != null) {
            try {
                this.editorUI = this.editorUIFactory(this.editorUIName);
            }
            catch (Exception e) {
                LogSupport.error((Object)this, (String)"constructor", (String)("Cannot find editor UI: " + this.editorUIName));
                this.editorUIName = null;
            }
        }
        return this.editorUI;
    }

    public void notifyAttributeChange() {
        if (this.attributeChanged && !this.suppressAttributeNotify) {
            if (this.getParent() != null) {
                this.getParent().onAttributeChange(this);
            }
            this.attributeChanged = false;
        }
        this.setOriginator();
    }

    public void setAttributeChanged() {
        this.attributeChanged = true;
        if (this.getOriginator() == null || this.getOriginator().equals(ClientIdentification.NULL_CLIENT)) {
            this.setOriginator();
        }
    }

    public boolean isAttributeChanged() {
        return this.attributeChanged;
    }

    public void clearAttributeChanged() {
        this.attributeChanged = false;
        this.setOriginator(ClientIdentification.NULL_CLIENT);
    }

    public void setAttributeNotificationSuppression() {
        this.suppressAttributeNotify = true;
    }

    public void clearAttributeNotificationSuppression(boolean suppressNotify) {
        this.suppressAttributeNotify = false;
        if (suppressNotify) {
            this.clearAttributeChanged();
        } else if (this.attributeChanged) {
            this.notifyAttributeChange();
        }
    }

    public boolean usesHeader() {
        return false;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public boolean isVisible() {
        return true;
    }

    public void addMediaRequest(Short clientId) {
    }

    public abstract void merge(AbstractAttribute var1);

    @Override
    public boolean canFactoryFromName() {
        return false;
    }

    public String getAlternateName() {
        return this.alternateName;
    }

    public String getEditorUIName() {
        return this.editorUIName;
    }

    public boolean isDisplayEditorOnActivation() {
        return this.displayEditorOnActivation;
    }

    public void setAlternateName(String alternateName) {
        this.alternateName = alternateName.toLowerCase(Locale.ENGLISH);
    }

    public void setDisplayEditorOnActivation(boolean displayEditorOnActivation) {
        this.displayEditorOnActivation = displayEditorOnActivation;
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        this.setOriginator(istr.getOriginatorId());
        this.setDisplayName(WBUtils.readUTF(istr, "WBImage display name"));
        this.setAttributeChanged();
        return null;
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        ostr.writeUTF(this.getDisplayName());
        this.clearAttributeChanged();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        try {
            buf.append(this.getName());
            if (this.getAlternateName() != null) {
                buf.append("(" + this.getAlternateName() + ")");
            }
            buf.append(": on: " + this.getParent() + ", ModifiedBy: " + this.getModfiedById());
        }
        catch (Exception ex) {
            buf.append("Exception: " + ex.getMessage());
        }
        return buf.toString();
    }

    public boolean validate(AttributeList parent) {
        boolean valid = true;
        if (parent != this.getParent()) {
            Validator.log("AbstractAttribute(" + this.getRegisteredID() + "): " + this.getName() + ", getParent() != parent: '" + WBUtils.objectName(this.getParent()) + "' != '" + WBUtils.objectName(parent));
            valid = Validator.setValid(valid, false);
        }
        return valid & super.validate();
    }
}

