/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.acl;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.acl.ACLEntry;
import com.elluminate.groupware.whiteboard.conference.ClientIdentification;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.DataModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenGroups;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.Validator;
import com.elluminate.groupware.whiteboard.interfaces.ACLList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class ACLTerm {
    private static final byte DEFAULT_ALLOW_FLAG = -128;
    private static final byte DENY_SELF_FLAG = 64;
    private static final byte DEFINING_LIST_EMPTY = 32;
    private static final byte ACCEPT_LIST_EMPTY = 16;
    private static final byte DENY_LIST_EMPTY = 8;
    private static final byte DEFINING_LIST_ENTRIES = 4;
    private static final byte ACCEPT_LIST_ENTRIES = 2;
    private static final byte DENY_LIST_ENTRIES = 1;
    public static final ACLEntry CHAIR_ENTRY = new ACLEntry(null, ACLEntry.ALL_CLIENTS, ACLEntry.ALL_GROUPS, null, ACLEntry.CHAIR_ROLE);
    public static final ACLEntry RECORDER_ENTRY = new ACLEntry(null, ACLEntry.RECORDER_ROLE, ACLEntry.ALL_GROUPS, null, ACLEntry.ACCESSIBLE);
    public static final ACLEntry ALL_ENTRY = new ACLEntry(null, ACLEntry.ALL_CLIENTS, ACLEntry.ALL_GROUPS, null, ACLEntry.ALL_ROLES);
    public static final ACLEntry GROUP_CREATOR_ENTRY = new ACLEntry(null, ACLEntry.ALL_CLIENTS, ACLEntry.ALL_GROUPS, null, ACLEntry.GROUP_CREATOR_ROLE);
    public static final ACLEntry ACCESSIBLE_ENTRY = new ACLEntry(null, ACLEntry.ALL_CLIENTS, ACLEntry.ALL_GROUPS, null, ACLEntry.ACCESSIBLE);
    public static final ACLEntry NOT_ACCESSIBLE_ENTRY = new ACLEntry(null, ACLEntry.ALL_CLIENTS, ACLEntry.ALL_GROUPS, null, ACLEntry.NOT_ACCESSIBLE);
    private String name;
    private ACLList parent;
    private boolean defaultAllow;
    private boolean denySelf;
    private ArrayList definingList = null;
    private ArrayList acceptList = null;
    private ArrayList denyList = null;
    private Boolean allow = null;
    private boolean empty = true;
    private Short[] otherClientsList = null;
    private boolean evaluateOtherClients = true;
    private Short[] clientsList = null;
    private boolean evaluateClients = true;
    private WhiteboardContext context;

    public ACLTerm(String name, ACLList parent, WhiteboardContext context, boolean defaultAllow) {
        this.name = name;
        this.parent = parent;
        this.defaultAllow = defaultAllow;
        this.denySelf = false;
        this.context = context;
        parent.addACLTerm(this);
    }

    public ACLTerm(String name, ACLList parent, WhiteboardContext context, boolean defaultAllow, ACLEntry defining) {
        this(name, parent, context, defaultAllow);
        this.addDefiningEntry(defining);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            this.removeRefs(this.definingList);
            this.removeRefs(this.acceptList);
            this.removeRefs(this.denyList);
            this.context.getACLManager().removeTerm(this);
        }
    }

    private void removeRefs(ArrayList list) {
        if (list != null) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                ACLEntry entry = (ACLEntry)iter.next();
                iter.remove();
                this.context.getACLManager().remove(entry, this);
            }
        }
    }

    public boolean allows() {
        Boolean allowable = this.allow;
        if (allowable == null) {
            return this.validateClient();
        }
        try {
            return allowable;
        }
        catch (Exception ex) {
            return this.validateClient();
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public ACLList getParent() {
        return this.parent;
    }

    public void setACLListParent(ACLList parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reEvaluateTerm(Boolean state) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            this.empty = this.definingList == null && this.acceptList == null && this.denyList == null;
            this.allow = null;
            this.evaluateClients = true;
            this.evaluateOtherClients = true;
            this.notifyACLChange(state);
        }
    }

    public abstract void notifyACLChange(Boolean var1);

    public boolean getDefaultAllow() {
        return this.defaultAllow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultAllow(boolean defaultAllow) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            if (defaultAllow != this.defaultAllow) {
                this.defaultAllow = defaultAllow;
                this.reEvaluateTerm(new Boolean(defaultAllow));
            }
        }
    }

    public boolean getDenySelf() {
        return this.denySelf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDenySelf(boolean denySelf) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            if (denySelf != this.denySelf) {
                this.denySelf = denySelf;
                this.reEvaluateTerm(new Boolean(this.defaultAllow));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addDefiningEntry(ACLEntry aclEntry) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            ACLEntry realEntry;
            boolean added;
            if (this.definingList == null) {
                this.definingList = new ArrayList(2);
            }
            if (added = this.definingList.contains(realEntry = this.context.getACLManager().add(aclEntry, this)) ? false : this.definingList.add(realEntry)) {
                Collections.sort(this.definingList);
            }
            this.reEvaluateTerm(new Boolean(this.defaultAllow));
            return added;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAcceptEntry(ACLEntry aclEntry) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            ACLEntry realEntry;
            boolean added;
            if (this.acceptList == null) {
                this.acceptList = new ArrayList(2);
            }
            if (added = this.acceptList.contains(realEntry = this.context.getACLManager().add(aclEntry, this)) ? false : this.acceptList.add(realEntry)) {
                Collections.sort(this.acceptList);
            }
            this.reEvaluateTerm(new Boolean(this.defaultAllow));
            return added;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addDenyEntry(ACLEntry aclEntry) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            ACLEntry realEntry;
            boolean added;
            if (this.denyList == null) {
                this.denyList = new ArrayList(2);
            }
            if (added = this.denyList.contains(realEntry = this.context.getACLManager().add(aclEntry, this)) ? false : this.denyList.add(realEntry)) {
                Collections.sort(this.denyList);
            }
            this.reEvaluateTerm(new Boolean(this.defaultAllow));
            return added;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearAll() {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            boolean forceEvaluate = this.clearEntry(this.definingList, false, false);
            forceEvaluate |= this.clearEntry(this.acceptList, false, false);
            forceEvaluate |= this.clearEntry(this.denyList, true, forceEvaluate);
            this.definingList = null;
            this.acceptList = null;
            this.denyList = null;
            return forceEvaluate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearDefining() {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            boolean result = this.clearEntry(this.definingList, true, false);
            this.definingList = null;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearDeny() {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            boolean result = this.clearEntry(this.denyList, true, false);
            this.denyList = null;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearAccept() {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            boolean result = this.clearEntry(this.acceptList, true, false);
            this.acceptList = null;
            return result;
        }
    }

    private boolean clearEntry(List list, boolean reevaluate, boolean forceEvaluate) {
        boolean removed = false;
        if (list == null) {
            return false;
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            ACLEntry aclEntry = (ACLEntry)iter.next();
            this.context.getACLManager().remove(aclEntry, this);
            iter.remove();
            removed = true;
        }
        if ((removed || forceEvaluate) && reevaluate) {
            this.reEvaluateTerm(new Boolean(this.defaultAllow));
        }
        return removed;
    }

    private boolean removeDefiningEntry(ACLEntry aclEntry) {
        boolean removed;
        boolean bl = removed = this.definingList != null ? this.definingList.remove(aclEntry) : false;
        if (removed) {
            this.context.getACLManager().remove(aclEntry, this);
            this.reEvaluateTerm(new Boolean(this.defaultAllow));
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAcceptEntry(ACLEntry aclEntry) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            boolean removed;
            boolean bl = removed = this.acceptList != null ? this.acceptList.remove(aclEntry) : false;
            if (removed) {
                this.context.getACLManager().remove(aclEntry, this);
                this.reEvaluateTerm(new Boolean(this.defaultAllow));
            }
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDenyEntry(ACLEntry aclEntry) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            boolean removed;
            boolean bl = removed = this.denyList != null ? this.denyList.remove(aclEntry) : false;
            if (removed) {
                this.context.getACLManager().remove(aclEntry, this);
                this.reEvaluateTerm(new Boolean(this.defaultAllow));
            }
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateClient() {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            if (this.allow == null) {
                ACLTerm term;
                this.allow = this.isEmpty() && this.parent instanceof ACLList && this.parent.getACLParent() != null ? ((term = this.parent.getACLParent().getACLTerm(this.name)) != null ? new Boolean(term.validateClient()) : new Boolean(this.defaultAllow)) : new Boolean(this.validateClient(ClientIdentification.CLIENT_LOCAL));
            }
            return this.allow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateClient(Short clientId) {
        boolean valid = false;
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            if (this.definingList != null && !this.definingList.isEmpty()) {
                valid = this.validate(clientId, this.definingList, null, false, false);
            }
            if (!(valid || this.acceptList == null && this.denyList == null)) {
                valid = this.getMaster().validate(clientId, this.acceptList, this.denyList, this.denySelf, this.defaultAllow);
            }
            return valid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Short[] getValidClients() {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            if (this.evaluateClients) {
                ACLTerm aCLTerm = this.getMaster();
                this.context.getIDProcessor();
                this.clientsList = aCLTerm.validClients(this.acceptList, this.denyList, ClientIdentification.NULL_CLIENT);
                this.evaluateClients = false;
            }
            return this.clientsList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Short[] getOtherValidClients() {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            if (this.evaluateOtherClients) {
                ACLTerm master = this.getMaster();
                if (master == null || this.context.getClientList() == null) {
                    return WhiteboardContext.NO_CLIENTS;
                }
                this.otherClientsList = master.validClients(master.acceptList, master.denyList, ClientIdentification.CLIENT_LOCAL);
                this.evaluateOtherClients = false;
            }
            return this.otherClientsList;
        }
    }

    private ACLTerm getMaster() {
        ACLList aclParent = this.parent;
        ACLTerm aclTerm = this;
        ACLTerm proposedTerm = null;
        while (aclTerm.isEmpty() && aclParent instanceof ACLList && (aclParent = aclParent.getACLParent()) != null && !(aclParent instanceof ScreenGroups)) {
            proposedTerm = aclParent.getACLTerm(this.name);
            if (proposedTerm == null) continue;
            aclTerm = proposedTerm;
        }
        return aclTerm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTerm(ACLTerm aclTerm) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            this.defaultAllow = aclTerm.getDefaultAllow();
            this.denySelf = aclTerm.getDenySelf();
            this.definingList = this.copyRefs(this.definingList, aclTerm.definingList);
            this.acceptList = this.copyRefs(this.acceptList, aclTerm.acceptList);
            this.denyList = this.copyRefs(this.denyList, aclTerm.denyList);
            this.reEvaluateTerm(null);
        }
    }

    private ArrayList copyRefs(ArrayList oldList, ArrayList newList) {
        ArrayList<ACLEntry> list = oldList;
        this.removeRefs(list);
        if (newList != null && !newList.isEmpty()) {
            if (list == null) {
                list = new ArrayList<ACLEntry>(2);
            }
            for (ACLEntry entry : newList) {
                list.add(entry);
            }
            Collections.sort(list);
        }
        return list;
    }

    private Short[] validClients(List acceptList, List denyList, Short omitClient) {
        Short[] acceptedArray = WhiteboardContext.NO_CLIENTS;
        this.context.getACLManager().termEvaluatesClients(this.getMaster());
        ArrayList<Short> accepted = new ArrayList<Short>(this.context.getIDProcessor().getClientCount());
        Iterator iter = this.context.getIDProcessor().getClientIdEntryIterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            Short client = (Short)entry.getValue();
            if (client.equals(omitClient) || !this.validate(client, acceptList, denyList, this.denySelf, this.defaultAllow)) continue;
            accepted.add(client);
        }
        if (!accepted.isEmpty()) {
            acceptedArray = new Short[accepted.size()];
            iter = accepted.iterator();
            int i = 0;
            while (iter.hasNext()) {
                acceptedArray[i] = (Short)iter.next();
                ++i;
            }
        }
        return acceptedArray;
    }

    private boolean validate(Short client, List acceptList, List denyList, boolean denySelf, boolean defaultAllow) {
        boolean accepted = false;
        boolean denied = false;
        if (denySelf && (client == null || this.context.getIDProcessor().getMyId().equals(client))) {
            return false;
        }
        if (client == null) {
            return defaultAllow;
        }
        ACLEntry acceptEntry = null;
        ACLEntry denyEntry = null;
        Iterator acceptIterator = acceptList == null ? WhiteboardContext.EMPTY_ARRAYLIST.iterator() : acceptList.iterator();
        Iterator denyIterator = denyList == null ? WhiteboardContext.EMPTY_ARRAYLIST.iterator() : denyList.iterator();
        int acceptOrder = -1;
        int denyOrder = -1;
        while (acceptIterator.hasNext() || acceptEntry != null || denyIterator.hasNext() || denyEntry != null) {
            if (acceptEntry == null && acceptIterator != null && acceptIterator.hasNext() && (acceptEntry = (ACLEntry)acceptIterator.next()) != null) {
                acceptOrder = acceptEntry.getOrder();
                accepted = acceptEntry.validate(client, this, this.context);
            }
            if (denyEntry == null && denyIterator != null && denyIterator.hasNext() && (denyEntry = (ACLEntry)denyIterator.next()) != null) {
                denyOrder = denyEntry.getOrder();
                denied = denyEntry.validate(client, this, this.context);
            }
            if (acceptOrder > denyOrder) {
                if (accepted) {
                    return true;
                }
            } else if (acceptOrder < denyOrder) {
                if (denied) {
                    return false;
                }
            } else {
                boolean result = defaultAllow;
                if (!accepted && denied) {
                    result = false;
                } else if (accepted && !denied) {
                    result = true;
                }
                return result;
            }
            if (acceptOrder > denyOrder) {
                acceptEntry = null;
                acceptOrder = -1;
                continue;
            }
            if (denyOrder > acceptOrder) {
                denyEntry = null;
                denyOrder = -1;
                continue;
            }
            acceptEntry = null;
            acceptOrder = -1;
            denyEntry = null;
            denyOrder = -1;
        }
        return defaultAllow;
    }

    public String toString() {
        ACLEntry aclEntry;
        Iterator iter;
        StringBuffer result = new StringBuffer();
        result.append("'" + this.getName());
        if (this.parent instanceof ScreenModel) {
            ScreenModel screen = (ScreenModel)this.parent;
            result.append(" (" + WBUtils.objectName(screen) + ")'");
        } else {
            result.append("'");
        }
        result.append(", defaultAllow: " + this.defaultAllow + ", denySelf: " + this.denySelf);
        result.append("\n Defining List: ");
        if (this.definingList != null && !this.definingList.isEmpty()) {
            iter = this.definingList.iterator();
            while (iter.hasNext()) {
                aclEntry = (ACLEntry)iter.next();
                result.append(aclEntry.toString());
                if (!iter.hasNext()) continue;
                result.append(", ");
            }
        }
        result.append("\n Accept List: ");
        if (this.acceptList != null && !this.acceptList.isEmpty()) {
            iter = this.acceptList.iterator();
            while (iter.hasNext()) {
                aclEntry = (ACLEntry)iter.next();
                result.append(aclEntry.toString());
                if (!iter.hasNext()) continue;
                result.append(", ");
            }
        }
        result.append("\n Deny List: ");
        if (this.denyList != null && !this.denyList.isEmpty()) {
            iter = this.denyList.iterator();
            while (iter.hasNext()) {
                aclEntry = (ACLEntry)iter.next();
                result.append(aclEntry.toString());
                if (!iter.hasNext()) continue;
                result.append(", ");
            }
        }
        result.append("\n  allows: " + this.allow + "\n\n");
        return result.toString();
    }

    public void objectToStream(WBOutputStream ostr) throws Exception {
        int encodedStatus = 0;
        encodedStatus = (byte)(encodedStatus | (this.defaultAllow ? -128 : 0));
        encodedStatus = (byte)(encodedStatus | (this.denySelf ? 64 : 0));
        encodedStatus = (byte)(encodedStatus | (this.definingList == null || this.definingList.isEmpty() ? 32 : 4));
        encodedStatus = (byte)(encodedStatus | (this.acceptList == null || this.acceptList.isEmpty() ? 16 : 2));
        encodedStatus = (byte)(encodedStatus | (this.denyList == null || this.denyList.isEmpty() ? 8 : 1));
        ostr.writeByte(encodedStatus);
        this.emitList(this.definingList, ostr);
        this.emitList(this.acceptList, ostr);
        this.emitList(this.denyList, ostr);
    }

    public void streamToObject(WBInputStream istr) throws Exception {
        int i;
        int entryCount;
        byte encodedStatus = WBUtils.readByte(istr, "ACLTerm reads encodedStatus");
        this.defaultAllow = (encodedStatus & 0xFFFFFF80) != 0;
        boolean bl = this.denySelf = (encodedStatus & 0x40) != 0;
        if ((encodedStatus & 0x20) != 0) {
            this.removeRefs(this.definingList);
        }
        if ((encodedStatus & 0x10) != 0) {
            this.removeRefs(this.acceptList);
        }
        if ((encodedStatus & 8) != 0) {
            this.removeRefs(this.denyList);
        }
        if ((encodedStatus & 4) != 0) {
            entryCount = WBUtils.readShort(istr, "ACLTerm reads definingList count");
            for (i = 0; i < entryCount; ++i) {
                this.addDefiningEntry(ACLEntry.streamToObject(istr));
            }
        }
        if ((encodedStatus & 2) != 0) {
            entryCount = WBUtils.readShort(istr, "ACLTerm reads acceptList count");
            for (i = 0; i < entryCount; ++i) {
                this.addAcceptEntry(ACLEntry.streamToObject(istr));
            }
        }
        if ((encodedStatus & 1) != 0) {
            entryCount = WBUtils.readShort(istr, "ACLTerm reads denyList count");
            for (i = 0; i < entryCount; ++i) {
                this.addDenyEntry(ACLEntry.streamToObject(istr));
            }
        }
        this.reEvaluateTerm(new Boolean(this.defaultAllow));
    }

    private void emitList(List list, WBOutputStream ostr) throws Exception {
        if (list != null && !list.isEmpty()) {
            ostr.writeShort(list.size());
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                ((ACLEntry)iter.next()).objectToStream(ostr);
            }
        }
    }

    public String streamToString(WBInputStream istr) {
        StringBuffer buf = new StringBuffer();
        try {
            int i;
            int entryCount;
            byte encodedStatus = WBUtils.readByte(istr, "ACLTerm reads encodedStatus");
            buf.append("ACLTerm: " + this.getName() + ", reads defaultAllow: " + ((encodedStatus & 0xFFFFFF80) != 0 ? "true" : "false") + ", denySelf: " + ((encodedStatus & 0x40) != 0 ? "true" : "false"));
            if ((encodedStatus & 0x20) != 0) {
                buf.append(", clear definingList");
            }
            if ((encodedStatus & 0x10) != 0) {
                buf.append(", clear acceptList");
            }
            if ((encodedStatus & 8) != 0) {
                buf.append(", clear denyList");
            }
            if ((encodedStatus & 4) != 0) {
                entryCount = WBUtils.readShort(istr, "ACLTerm reads definingList count");
                buf.append("\n  Read definingList ACLEntries: ");
                for (i = 0; i < entryCount; ++i) {
                    buf.append(ACLEntry.streamToString(istr));
                }
            }
            if ((encodedStatus & 2) != 0) {
                entryCount = WBUtils.readShort(istr, "ACLTerm reads acceptList count");
                buf.append("\n  Read acceptList ACLEntries: ");
                for (i = 0; i < entryCount; ++i) {
                    buf.append(ACLEntry.streamToString(istr));
                }
            }
            if ((encodedStatus & 1) != 0) {
                entryCount = WBUtils.readShort(istr, "ACLTerm reads denyList count");
                buf.append("\n  Read denyList ACLEntries: ");
                for (i = 0; i < entryCount; ++i) {
                    buf.append(ACLEntry.streamToString(istr));
                }
            }
        }
        catch (Exception e) {
            buf.append(" ACLTerm Exception: " + e.getMessage());
        }
        return buf.toString();
    }

    public boolean validate(Object parent) {
        boolean valid = true;
        if (parent == null) {
            Validator.log("ACLTerm: " + this.getName() + ", with parent: " + WBUtils.objectName(parent) + ", has null parent.");
            valid = Validator.setValid(valid, false);
        } else if (parent instanceof ACLList) {
            ACLList aclParent = (ACLList)parent;
            if (aclParent.getACLTerm(this.getName()) != this) {
                Validator.log("ACLTerm: " + this.getName() + ", not a child of parent: " + WBUtils.objectName(parent));
                valid = Validator.setValid(valid, false);
            }
        } else {
            Validator.log("ACLTerm: " + this.getName() + ", with non-ACLList parent: " + WBUtils.objectName(parent));
            valid = Validator.setValid(valid, false);
        }
        return valid;
    }
}

