/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.acl;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.acl.ACLTerm;
import com.elluminate.groupware.whiteboard.conference.ClientIdentification;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.ObjectUID;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenResolver;
import com.elluminate.jinx.ClientGroup;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.util.ShortList;
import com.elluminate.util.log.LogSupport;

public class ACLEntry
extends ObjectUID
implements Comparable {
    String participant;
    Short clientId = null;
    String group;
    Short groupId = null;
    String role;
    Short roleId = null;
    String entryString = null;
    int order = 0;
    static final String[] PARTICIPANT_NAMES = new String[]{"*", "-self-"};
    public static final Short ALL_CLIENTS = ShortList.get((short)-2);
    public static final Short SELF_CLIENT = ClientIdentification.CLIENT_LOCAL;
    static final String[] GROUP_NAMES = new String[]{"*", "-DEFAULT-", "-CURRENT-", "-NOT CURRENT-"};
    public static final short ALL_GROUPS_SHORT = -2;
    public static final Short ALL_GROUPS = ShortList.get((short)-2);
    private static final short ALL_GROUPS_INDEX = 0;
    public static final short NULL_GROUP_SHORT = 0;
    public static final Short NULL_GROUP = ShortList.get((short)0);
    private static final short NULL_GROUP_INDEX = 1;
    public static final short CURRENT_GROUP_SHORT = -3;
    public static final Short CURRENT_GROUP = ShortList.get((short)-3);
    private static final short CURRENT_GROUP_INDEX = 2;
    public static final short NOT_CURRENT_GROUP_SHORT = -4;
    public static final Short NOT_CURRENT_GROUP = ShortList.get((short)-4);
    private static final short NOT_CURRENT_GROUP_INDEX = 3;
    static final String[] ROLE_NAMES = new String[]{"*", "chair", "server", "recorder", "group creator", "chair of record", "off line", "on line", "accessible", "notAccessible"};
    public static final short ALL_ROLES_SHORT = -2;
    public static final Short ALL_ROLES = ShortList.get((short)-2);
    private static final short ALL_ROLES_INDEX = 0;
    public static final short NULL_ROLE_SHORT = -1;
    public static final Short NULL_ROLE = ShortList.get((short)-1);
    public static final short CHAIR_ROLE_SHORT = 0;
    public static final Short CHAIR_ROLE = ShortList.get((short)0);
    private static final short CHAIR_ROLE_INDEX = 1;
    public static final short SERVER_ROLE_SHORT = 1;
    public static final Short SERVER_ROLE = ShortList.get((short)1);
    private static final short SERVER_ROLE_INDEX = 2;
    public static final short RECORDER_ROLE_SHORT = 2;
    public static final Short RECORDER_ROLE = ShortList.get((short)2);
    private static final short RECORDER_ROLE_INDEX = 3;
    public static final short GROUP_CREATOR_ROLE_SHORT = 3;
    public static final Short GROUP_CREATOR_ROLE = ShortList.get((short)3);
    private static final short GROUP_ROLE_INDEX = 4;
    public static final short CHAIR_OF_RECORD_ROLE_SHORT = 4;
    public static final Short CHAIR_OF_RECORD_ROLE = ShortList.get((short)4);
    private static final short CHIAR_OF_RECORD_ROLE_INDEX = 5;
    public static final short OFFLINE_ROLE_SHORT = 5;
    public static final Short OFFLINE_ROLE = ShortList.get((short)5);
    private static final short OFFLINE_ROLE_INDEX = 6;
    public static final short ONLINE_ROLE_SHORT = 6;
    public static final Short ONLINE_ROLE = ShortList.get((short)6);
    private static final short ONLINE_ROLE_INDEX = 7;
    public static final short ACCESSIBLE_ROLE_SHORT = 7;
    public static final Short ACCESSIBLE = ShortList.get((short)7);
    private static final short ACCESSIBLE_INDEX = 8;
    public static final short NOT_ACCESSIBLE_ROLE_SHORT = 8;
    public static final Short NOT_ACCESSIBLE = ShortList.get((short)8);
    private static final short NOT_ACCESSIBLE_INDEX = 9;
    private static final int PARTICIPANT_SPECIFIC = 4;
    private static final int GROUP_SPECIFIC = 2;
    private static final int ROLE_SPECIFIC = 1;
    private static final char SEPARATOR = '.';
    private WhiteboardContext context = null;

    public ACLEntry(WhiteboardContext context) {
        this.context = context;
    }

    public ACLEntry(WhiteboardContext context, String access) {
        this(context);
        int endPart = access.indexOf(46);
        int endGroup = access.lastIndexOf(46);
        if (endPart < 0 || endGroup < 0) {
            throw new RuntimeException("Invalid ACL term: " + access);
        }
        this.setParticipant(access.substring(0, endPart));
        if (endPart >= endGroup - 1) {
            this.setGroup(null);
        } else {
            this.setGroup(access.substring(endPart + 1, endGroup));
        }
        this.setRole(access.substring(endGroup + 1));
    }

    public ACLEntry(WhiteboardContext context, Short client, Short group, String groupName, Short role) {
        this(context);
        this.setClient(client);
        this.setGroup(group, groupName);
        this.setRole(role);
    }

    public void setParticipant(String participant) {
        Short clientResult = null;
        this.participant = participant;
        if (participant != null) {
            ClientInfo clientInfo;
            if (participant.equals("*")) {
                clientResult = ALL_CLIENTS;
            } else if (this.context != null && this.context.getClientList() != null && (clientInfo = this.context.getClientList().get(participant)) != null) {
                clientResult = this.context.getIDProcessor().getClientId(ShortList.get((short)clientInfo.getAddress()));
            }
        }
        this.setClient(clientResult);
    }

    public void setClient(Short client) {
        this.clientId = client;
        this.order &= 0xFFFFFFFB;
        if (client != null) {
            if (client.equals(ALL_CLIENTS)) {
                this.participant = "*";
            } else if (client.equals(ClientIdentification.RECORDER_ID)) {
                this.participant = ClientIdentification.RECORDER_NAME;
            } else if (this.context != null && this.context.getClientList() != null) {
                ClientInfo clientOfAddress = null;
                Short clientAddress = this.context.getIDProcessor().getClientAddress(client);
                try {
                    if (clientAddress == null && client.equals(ClientIdentification.CLIENT_LOCAL)) {
                        clientAddress = ShortList.get((short)this.context.getClientList().getMyAddress());
                        clientOfAddress = this.context.getClientList().get(clientAddress.shortValue());
                    } else {
                        clientOfAddress = this.context.getClientList().get(clientAddress.shortValue());
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.participant = clientOfAddress == null ? (clientAddress == 1 ? ClientIdentification.RECORDER_NAME : "- unknown -") : clientOfAddress.getName();
                this.order |= 4;
            }
        }
        this.entryString = null;
    }

    public void setGroup(String group) {
        Short groupResult = null;
        this.group = group;
        if (group != null) {
            if (group.equals("*")) {
                groupResult = ALL_GROUPS;
            } else if (this.context != null && this.context.getClientList() != null) {
                try {
                    ClientGroup groupInfo = this.context.getClientList().getClientGroup(group);
                    if (groupInfo != null) {
                        groupResult = ShortList.get((short)groupInfo.getGroupID());
                    }
                }
                catch (Exception ex) {
                    LogSupport.exception((Object)this, (String)"setGroup", (Throwable)ex, (boolean)true);
                }
            }
        }
        if (groupResult != null) {
            this.setGroup(groupResult, group);
        }
    }

    public void setGroup(Short group, String groupName) {
        this.groupId = group;
        this.order &= 0xFFFFFFFD;
        if (group != null) {
            if (group.equals(ALL_GROUPS)) {
                this.group = "*";
            } else {
                this.group = this.translateToName(group, groupName);
                this.order |= 2;
            }
        } else {
            LogSupport.error((Object)this, (String)"setGroup", (String)"Supplied groupId is null");
            Thread.dumpStack();
        }
        this.entryString = null;
    }

    private String translateToName(Short group, String name) {
        String result = "";
        if (group != null) {
            switch (group) {
                case -2: {
                    result = GROUP_NAMES[0];
                    break;
                }
                case 0: {
                    result = GROUP_NAMES[1];
                    break;
                }
                case -3: {
                    result = GROUP_NAMES[2];
                    break;
                }
                case -4: {
                    result = GROUP_NAMES[3];
                    break;
                }
                default: {
                    result = name;
                }
            }
        }
        return result;
    }

    public void setRole(String role) {
        Short roleResult = null;
        this.role = role;
        if (role != null) {
            if (role.equals("*")) {
                roleResult = ALL_ROLES;
            } else {
                for (int i = 0; i < ROLE_NAMES.length; i = (int)((short)(i + 1))) {
                    if (!role.equals(ROLE_NAMES[i])) continue;
                    roleResult = ShortList.get((short)((short)(i - 1)));
                    break;
                }
            }
        }
        this.setRole(roleResult);
    }

    public void setRole(Short role) {
        this.roleId = role;
        this.order &= 0xFFFFFFFE;
        if (role.equals(ALL_ROLES)) {
            this.role = "*";
        } else if (role >= 0 && role < ROLE_NAMES.length) {
            this.role = ROLE_NAMES[role + 1];
            this.order |= 1;
        } else {
            this.role = "";
        }
        this.entryString = null;
    }

    public int compareTo(Object o) throws ClassCastException {
        if (o == null || !(o instanceof ACLEntry)) {
            throw new ClassCastException("Cannot compare ACLEntry to: " + o);
        }
        return this.getOrder() - ((ACLEntry)o).getOrder();
    }

    public boolean equals(Object o) {
        if (o instanceof ACLEntry) {
            return this.getEntry().equals(((ACLEntry)o).getEntry());
        }
        return false;
    }

    public int hashCode() {
        return this.getEntry().hashCode();
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isParticipantSpecific() {
        return (this.order & 4) != 0;
    }

    public boolean isGroupSpecific() {
        return (this.order & 2) != 0;
    }

    public boolean isRoleSpecific() {
        return (this.order & 1) != 0;
    }

    boolean validateParticipant(Short client, ACLTerm aclTerm, WhiteboardContext context) {
        if (this.clientId.equals(ALL_CLIENTS)) {
            return true;
        }
        if (client == null) {
            return false;
        }
        if (this.clientId.equals(SELF_CLIENT) && context.getIDProcessor().isLocalClient(client)) {
            return true;
        }
        return client.equals(this.clientId);
    }

    boolean validateGroup(Short client, ACLTerm aclTerm, WhiteboardContext context) {
        if (this.groupId.equals(ALL_GROUPS)) {
            return true;
        }
        if (client == null || context.getIDProcessor() == null) {
            return false;
        }
        Short clientGroup = context.getIDProcessor().getGroupId(client);
        if (clientGroup == null) {
            clientGroup = NULL_GROUP;
        }
        if (this.groupId.equals(CURRENT_GROUP)) {
            if (!(aclTerm.getParent() instanceof ScreenResolver)) {
                return false;
            }
            ScreenResolver resolver = (ScreenResolver)((Object)aclTerm.getParent());
            ScreenModel screen = resolver.getScreen();
            if (screen == null || screen.getRoot() == null) {
                return false;
            }
            short screenGroup = screen.getRoot().getGroupID();
            return clientGroup == screenGroup;
        }
        if (this.groupId.equals(NOT_CURRENT_GROUP)) {
            if (!(aclTerm.getParent() instanceof ScreenResolver)) {
                return false;
            }
            ScreenResolver resolver = (ScreenResolver)((Object)aclTerm.getParent());
            ScreenModel screen = resolver.getScreen();
            if (screen == null || screen.getRoot() == null) {
                return false;
            }
            short screenGroup = screen.getRoot().getGroupID();
            return clientGroup != screenGroup;
        }
        try {
            boolean result = this.groupId.equals(clientGroup);
            return result;
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"validateGroup", (Throwable)ex, (boolean)true);
            return false;
        }
    }

    boolean validateRole(Short client, ACLTerm aclTerm, WhiteboardContext context) {
        if (this.roleId.equals(ALL_ROLES)) {
            return true;
        }
        if (client == null) {
            return false;
        }
        ClientIdentification.Role currentRole = context.getIDProcessor().getRole(client);
        if (currentRole == null && !this.roleId.equals(GROUP_CREATOR_ROLE)) {
            return false;
        }
        switch (this.roleId) {
            case 4: {
                return currentRole.isChairOfRecord() || currentRole.isServer();
            }
            case 0: {
                return currentRole.isChair() || currentRole.isChairOfRecord() || currentRole.isServer();
            }
            case 1: {
                return currentRole.isServer();
            }
            case 2: {
                return currentRole.isRecorder();
            }
            case 3: {
                if (!(aclTerm.getParent() instanceof ScreenResolver)) break;
                ScreenModel node = ((ScreenResolver)((Object)aclTerm.getParent())).getScreen();
                if (client == null || node == null || node.getObjectID() == null) {
                    return false;
                }
                boolean result = client == ObjectUID.decodeClientId(node.getObjectID());
                return result;
            }
            case 5: {
                return !context.isOnline();
            }
            case 6: {
                return context.isOnline();
            }
            case 7: {
                return context.isAccessible();
            }
            case 8: {
                return !context.isAccessible();
            }
        }
        return false;
    }

    boolean isMyGroup(Short client, ACLTerm aclTerm) {
        if (client == null) {
            return false;
        }
        if (aclTerm.getParent() instanceof ScreenModel) {
            ScreenModel screen = (ScreenModel)aclTerm.getParent();
            return client.equals(screen.getScreenGroup().getCreator());
        }
        return false;
    }

    public boolean validate(Short client, ACLTerm aclTerm, WhiteboardContext context) {
        return this.validateParticipant(client, aclTerm, context) && this.validateGroup(client, aclTerm, context) && this.validateRole(client, aclTerm, context);
    }

    public String getEntry() {
        if (this.entryString == null) {
            this.setEntryString();
        }
        return this.entryString;
    }

    public String[] getGroupConstants() {
        return GROUP_NAMES;
    }

    public String[] getRoleConstants() {
        return ROLE_NAMES;
    }

    public static char getSeparator() {
        return '.';
    }

    private void setEntryString() {
        int len = 2 + (this.participant == null ? 0 : this.participant.length()) + (this.group == null ? 0 : this.group.length()) + (this.role == null ? 0 : this.role.length());
        StringBuffer str = new StringBuffer(len);
        if (this.participant != null) {
            str.append(this.participant);
        }
        str.append('.');
        if (this.group != null) {
            str.append(this.group);
        }
        str.append('.');
        if (this.role != null) {
            str.append(this.role);
        }
        this.entryString = str.toString();
    }

    public void objectToStream(WBOutputStream ostr) throws Exception {
        ostr.writeShort(this.clientId.shortValue());
        ostr.writeShort(this.groupId.shortValue());
        ostr.writeUTF(this.group);
        ostr.writeShort(this.roleId.shortValue());
    }

    public static ACLEntry streamToObject(WBInputStream istr) throws Exception {
        Short clientId = ShortList.get((short)istr.getContext().getIDProcessor().conferenceToLocal(WBUtils.readShort(istr, "ACLEntry reads clientId"), istr.getAddress()));
        Short groupId = ShortList.get((short)WBUtils.readShort(istr, "ACLEntry reads groupId"));
        String groupName = WBUtils.readUTF(istr, "ACLEntry reads group name");
        Short roleId = ShortList.get((short)WBUtils.readShort(istr, "ACLEntry reads roleId"));
        return new ACLEntry(istr.getContext(), clientId, groupId, groupName, roleId);
    }

    public static String streamToString(WBInputStream istr) {
        try {
            Short clientId = ShortList.get((short)istr.getContext().getIDProcessor().conferenceToLocal(WBUtils.readShort(istr, "ACLEntry reads clientId"), istr.getAddress()));
            Short groupId = ShortList.get((short)WBUtils.readShort(istr, "ACLEntry reads groupId"));
            String groupName = WBUtils.readUTF(istr, "ACLEntry reads group name");
            Short roleId = ShortList.get((short)WBUtils.readShort(istr, "ACLEntry reads roleId"));
            return "ACLEntry reads clientId, groupId, groupName, roleId: " + clientId + ", " + groupId + ", '" + groupName + "', " + Integer.toHexString(roleId.intValue());
        }
        catch (Exception e) {
            return "ACLEntry.streamToString: " + e.getMessage();
        }
    }

    public String toString() {
        return this.getEntry() + "\n";
    }
}

