/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard;

import com.elluminate.framework.imps.Imps;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.comm.AbstractCommContainer;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.responder.WhiteboardResponder;
import com.elluminate.jinx.Bytes;
import com.elluminate.jinx.JinxProtocolAdapter;
import com.elluminate.jinx.ProtocolResponder;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class WhiteboardProtocol
extends JinxProtocolAdapter {
    public static final byte NOPTool = -1;
    public static final byte RegisterTemplate = 1;
    public static final byte ClientOnline = 2;
    public static final byte ServerOnline = 3;
    public static final byte ClientSynchComplete = 4;
    public static final byte SendCommObject = 5;
    public static final byte ResponderIgnoredObject = 6;
    public static final byte DataBlock = 7;
    public static final byte ValidateData = 8;
    public static final byte StatusIndication = 9;
    public static final String CommandChannel = "whiteboardCommand";
    public static final byte CommandPriority = 2;
    public static final String DataChannel = "whiteboardData";
    public static final byte DataPriority = 3;
    public static final String AccessProperty = "whiteboardFloor";
    public static final String ActiveProperty = "whiteboardActive";
    public static final String StatusYellowProperty = "whiteboardYellowStatus";
    public static final String StatusRedProperty = "whiteboardRedStatus";
    public static final String ActiveIndicatorTimeProperty = "whiteboardActiveIndicatorTime";
    public static final String ProprietaryContentProperty = "whitebordProprietaryContent";
    public static final String WB_DEFAULT_GROUP_NAME = "defaultGroupName";
    public static final String WB_DEFAULT_SCREEN_NAME = "defaultScreenName";
    public static final String PROPERTY_SHOW_COUNTER = "show.counter";
    public static final byte SHOW_COUNTER_UNDEFINED = -1;
    public static final byte SHOW_COUNTER_TO_NONE = 0;
    public static final byte SHOW_COUNTER_TO_MODERATORS = 1;
    public static final byte SHOW_COUNTER_TO_ALL = 2;
    public static final byte LOAD_REMOTE = -95;
    public static final byte REMOTE_DATA = -94;
    private WhiteboardResponder responder = null;
    private Imps imps = null;
    private WhiteboardContext context = null;

    public WhiteboardProtocol() {
        this(null, false);
    }

    @Inject
    public void initWhiteboardResponder(WhiteboardResponder whiteboardResponder) {
        this.responder = whiteboardResponder;
    }

    @Inject
    protected void initImps(Imps imps) {
        this.imps = imps;
    }

    public WhiteboardProtocol(WhiteboardContext context, boolean dftAccess) {
        this.context = context;
        this.defineChannel(CommandChannel, (byte)2);
        this.defineChannel(DataChannel, (byte)3);
        this.defineProperty(AccessProperty, (byte)0, new Boolean(dftAccess));
        this.defineProperty(ProprietaryContentProperty, (byte)1, Boolean.FALSE);
        this.defineProperty(PROPERTY_SHOW_COUNTER, (byte)1, Bytes.get((byte)-1));
    }

    public String messageToString(byte cmd, DataInputStream str) {
        StringBuffer msg = new StringBuffer(1024);
        switch (cmd) {
            case 1: {
                break;
            }
            case 2: {
                return "Client Online";
            }
            case 3: {
                return "Server Sees ClientOnline";
            }
            case 4: {
                return "Client Synch Complete";
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                msg.append("\nDataBlock: \n");
                break;
            }
            case 9: {
                break;
            }
            case 8: {
                return "ValidateData";
            }
        }
        try {
            byte[] strData = new byte[str.available()];
            str.read(strData);
            str.close();
            msg.append(strData.length + " bytes\n");
            msg.append(WhiteboardProtocol.arrayToString(strData));
            if (cmd == 7) {
                return msg.toString();
            }
            WBInputStream str1 = WBInputStream.inputStreamFactory(new ByteArrayInputStream(strData), this.context, null);
            if (str1.available() > 0) {
                RegisteredTemplate temp = this.context.getTemplateRegistry().templateLocator(str1);
                if (temp != null && temp instanceof AbstractCommContainer) {
                    AbstractCommContainer cObj = (AbstractCommContainer)temp;
                    msg.append(cObj.streamToString(str1));
                } else {
                    LogSupport.error((Object)((Object)this), (String)"messageToString", (String)("Template is not a CommContainer: " + temp));
                }
            }
            str1.close();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)((Object)this), (String)"messageToString", (Throwable)ex, (boolean)true, (String)"decoding message");
        }
        return msg.toString();
    }

    public String streamToString(DataInputStream istr) {
        String h = "0123456789ABCDEF";
        char[] hex = new char[]{' ', ' ', ' '};
        StringBuffer buf = null;
        try {
            int avail = istr.available();
            buf = new StringBuffer(avail * 3 + 10 + avail / 66);
            int i = 0;
            while (istr.available() > 0) {
                byte b = istr.readByte();
                hex[0] = h.charAt((short)b >> 4 & 0xF);
                hex[1] = h.charAt((short)b & 0xF);
                buf.append(hex);
                if (++i <= 22) continue;
                buf.append("\n");
                i = 0;
            }
            buf.append("\n");
        }
        catch (IOException ioe) {
            LogSupport.exception((Object)((Object)this), (String)"streamToString", (Throwable)ioe, (boolean)true);
        }
        return buf == null ? "Error in stream read" : buf.toString();
    }

    public static String arrayToString(byte[] buffer) {
        String h = "0123456789ABCDEF";
        char[] hex = new char[]{' ', ' ', ' '};
        StringBuffer buf = null;
        int avail = buffer.length;
        buf = new StringBuffer(avail * 3 + 10 + avail / 66);
        int i = 0;
        for (int bufIndex = 0; bufIndex < buffer.length; ++bufIndex) {
            hex[0] = h.charAt((short)buffer[bufIndex] >> 4 & 0xF);
            hex[1] = h.charAt((short)buffer[bufIndex] & 0xF);
            buf.append(hex);
            if (++i <= 22) continue;
            buf.append("\n");
            i = 0;
        }
        buf.append("\n");
        return buf.toString();
    }

    public ProtocolResponder getResponder() {
        if (this.responder == null) {
            this.responder = new WhiteboardResponder(this, this.imps);
        }
        return this.responder;
    }
}

