/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard;

import com.elluminate.framework.imps.Imps;
import com.elluminate.groupware.imps.RecorderIndexAPI;
import com.elluminate.groupware.whiteboard.AccessibleChangeListener;
import com.elluminate.groupware.whiteboard.AttributeChangeListener;
import com.elluminate.groupware.whiteboard.ButtonBehaviour;
import com.elluminate.groupware.whiteboard.CanvasChangeListener;
import com.elluminate.groupware.whiteboard.ChairManager;
import com.elluminate.groupware.whiteboard.OnlineListener;
import com.elluminate.groupware.whiteboard.ScreenClipboardListener;
import com.elluminate.groupware.whiteboard.ShutdownListener;
import com.elluminate.groupware.whiteboard.StringsProperties;
import com.elluminate.groupware.whiteboard.ToolClipboardListener;
import com.elluminate.groupware.whiteboard.WBScaler;
import com.elluminate.groupware.whiteboard.WhiteboardBeanInterface;
import com.elluminate.groupware.whiteboard.acl.ACLEntry;
import com.elluminate.groupware.whiteboard.acl.ACLManager;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.conference.ClientIdentification;
import com.elluminate.groupware.whiteboard.conference.DataExporter;
import com.elluminate.groupware.whiteboard.conference.GroupManager;
import com.elluminate.groupware.whiteboard.conference.ItemCache;
import com.elluminate.groupware.whiteboard.conference.StatusIndicators;
import com.elluminate.groupware.whiteboard.conference.WhiteboardDataProcessor;
import com.elluminate.groupware.whiteboard.dataModel.DataModel;
import com.elluminate.groupware.whiteboard.dataModel.DataModelListener;
import com.elluminate.groupware.whiteboard.dataModel.MediaCache;
import com.elluminate.groupware.whiteboard.dataModel.NodeList;
import com.elluminate.groupware.whiteboard.dataModel.ObjectUID;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.dataModel.TemplateRegistry;
import com.elluminate.groupware.whiteboard.dataModel.ThumbnailResolver;
import com.elluminate.groupware.whiteboard.dataModel.UniqueObjectManager;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.dataModel.WBNodeProxy;
import com.elluminate.groupware.whiteboard.interfaces.ControllerPaneInterface;
import com.elluminate.groupware.whiteboard.interfaces.WBClipboardInterface;
import com.elluminate.groupware.whiteboard.listeners.DeleteListener;
import com.elluminate.groupware.whiteboard.listeners.SelectionListener;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nMessage;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.ShortList;
import com.elluminate.util.TimedExecution;
import com.elluminate.util.event.ThrowableListener;
import com.elluminate.util.log.LogSupport;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

public class WhiteboardContext
implements DataModelListener {
    public static final Rectangle NULL_RECTANGLE = new Rectangle();
    public static final short NULL_ADDRESS = -32767;
    public static final Short[] NO_CLIENTS = new Short[0];
    public static final Short[] SERVER_CLIENT = new Short[]{ClientIdentification.SERVER_ID};
    public static final ArrayList EMPTY_ARRAYLIST = new ArrayList(0);
    public static final NodeList EMPTY_NODELIST = new NodeList(null, 0);
    public static final int WIDTH_DEFAULT = 1014;
    public static final int HEIGHT_DEFAULT = 835;
    public static final Dimension DEFAULT_SIZE = new Dimension(1014, 835);
    private ACLManager aclManager;
    private TemplateRegistry templateRegistry;
    private UniqueObjectManager uniqueObjectManager;
    private DataModel dataModel;
    private ControllerPaneInterface controller = null;
    private MediaCache mediaCache = null;
    private ItemCache itemCache = null;
    private HashMap commStateData = new HashMap();
    private ClientIdentification clientIdentification = null;
    private StatusIndicators statusIndicators = null;
    private WhiteboardBeanInterface bean = null;
    private DialogParentProvider dialogParentProvider;
    private WhiteboardDataProcessor dataProcessor;
    private DataExporter dataExporter = null;
    private TimedExecution timedExecution = null;
    private WBNodeProxy nodeProxy = null;
    private boolean online = false;
    private boolean client;
    private boolean chair = false;
    private boolean playback = false;
    private boolean accessible = true;
    private boolean defaultAccess = false;
    private boolean supervised = true;
    private boolean autoScaleMask = false;
    private boolean isNonlinear = false;
    private boolean isSeeking = false;
    private long conferenceUID = 0L;
    private ClientList clients = null;
    private ArrayList deleteListeners = new ArrayList();
    private ArrayList selectionListeners = new ArrayList();
    private ArrayList shutdownListeners = new ArrayList();
    private Object[] screenClipboard = null;
    private Object[] toolClipboard = null;
    LinkedList toolClipboardListeners = new LinkedList();
    LinkedList screenClipboardListeners = new LinkedList();
    private WBClipboardInterface wbClipboard = null;
    public File oldImageFile = new File(System.getProperty("user.home"));
    public File fileToSave = null;
    public File fileToLoad = Platform.getDefaultDir();
    ButtonBehaviour buttonBehaviour = new ButtonBehaviour();
    GroupManager groupManager = null;
    ChairManager chairManager = null;
    private ArrayList onlineListeners = new ArrayList();
    private LinkedList attributeChangeListeners = new LinkedList();
    private int toolClipboardGeneration = 0;
    private boolean followDefault = true;
    private HashSet accessibleChangeListeners = new HashSet();
    private HashSet canvasChangeListeners = new HashSet();
    private Long onScreen = null;
    private Long pendingGoToUID = null;
    private static final Long NO_TOPIC_UID = new Long(-1L);
    private Long currentTopicUID = NO_TOPIC_UID;
    private RecorderIndexAPI recorderIndexAPI = null;
    private I18n i18n = I18n.create((Object)this);
    private Properties params = null;
    private String defaultPublicScreenName = this.i18n.getString((PropertiesEnum)StringsProperties.DATAMODEL_DEFAULTCLASSSCREENNAME);
    private String defaultPublicGroupName = this.i18n.getString((PropertiesEnum)StringsProperties.DATAMODEL_DEFAULTCLASSGROUPNAME);
    private String defaultWorkScreenName = this.i18n.getString((PropertiesEnum)StringsProperties.DATAMODEL_DEFAULTWORKSCREENNAME);
    private boolean renamingSystemGeneratedNames = false;
    private boolean showThumbnails = true;
    private Thread thumbnailResolverThread = null;
    private LinkedList<ThumbnailResolver> thumbnailResolverQueue = new LinkedList();
    private boolean thumbnailResolverIdle = true;
    private Imps imps;
    private ThrowableListener throwableListener = null;
    private WBScaler scaler;
    private short publicPageCount;

    public WhiteboardContext(boolean client, boolean playback) {
        this.nodeProxy = new WBNodeProxy(this);
        this.client = client;
        this.playback = playback;
        this.templateRegistry = new TemplateRegistry(this);
        this.uniqueObjectManager = new UniqueObjectManager(this);
        this.mediaCache = new MediaCache(this);
        this.itemCache = new ItemCache();
        this.aclManager = new ACLManager(this);
        this.dataModel = new DataModel(this);
        this.templateRegistry.initialize();
        this.dataProcessor = null;
        this.dataExporter = new DataExporter(this);
        this.clientIdentification = new ClientIdentification(this);
        if (!client && !playback) {
            this.clientIdentification.setMyAddress((short)0);
        }
    }

    public void setBean(WhiteboardBeanInterface bean) {
        this.bean = bean;
    }

    public long getConferenceUID() {
        return this.conferenceUID;
    }

    public void setConferenceUID(long conferenceUID) {
        this.conferenceUID = conferenceUID;
    }

    public DataExporter getDataExporter() {
        return this.dataExporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupManager getGroupManager() {
        DataModel dataModel = this.dataModel;
        synchronized (dataModel) {
            if (this.groupManager == null) {
                this.groupManager = new GroupManager(this);
            }
            return this.groupManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusIndicators getStatus() {
        DataModel dataModel = this.dataModel;
        synchronized (dataModel) {
            if (this.statusIndicators == null && !this.client) {
                this.statusIndicators = new StatusIndicators(this);
                this.getChairManager().addChairListener(this.statusIndicators);
            }
            return this.statusIndicators;
        }
    }

    public ChairManager getChairManager() {
        if (this.chairManager == null) {
            this.chairManager = new ChairManager(this);
        }
        return this.chairManager;
    }

    public WhiteboardBeanInterface getBean() {
        return this.bean;
    }

    public Frame getDialogParentFrame() {
        return this.dialogParentProvider.getDialogParent();
    }

    public TimedExecution getTimedExecution() {
        if (this.timedExecution == null) {
            this.timedExecution = new TimedExecution();
        }
        return this.timedExecution;
    }

    public WBNodeProxy getNodeProxy() {
        return this.nodeProxy;
    }

    public void setRegistryOnline(boolean mode) {
        this.online = mode;
        this.getACLManager().changeRole(ACLEntry.ONLINE_ROLE);
        this.getACLManager().changeRole(ACLEntry.OFFLINE_ROLE);
    }

    public void setClientOnline(boolean online) {
        for (OnlineListener l : this.onlineListeners) {
            l.onOnline(online);
        }
        if (!online) {
            this.recorderIndexAPI = null;
        } else {
            try {
                this.recorderIndexAPI = (RecorderIndexAPI)this.imps.findBest(RecorderIndexAPI.class);
            }
            catch (Throwable t) {
                this.recorderIndexAPI = null;
            }
        }
        if (this.getChairManager() != null) {
            this.getChairManager().updateChair();
        }
    }

    public boolean isOnline() {
        return this.online;
    }

    public boolean isClient() {
        return this.client;
    }

    public boolean isPlayback() {
        return this.getBean() != null && this.getBean().isPlayback();
    }

    public void setNonLinear(boolean nlinear) {
        this.isNonlinear = nlinear;
    }

    public boolean isNonlinear() {
        return this.isNonlinear;
    }

    public void setSeeking(boolean seeking) {
        this.isSeeking = seeking;
        this.getController().repaint();
    }

    public boolean isSeeking() {
        return this.isSeeking;
    }

    public boolean isMe(Long objectUID) {
        return this.isMe(ObjectUID.decodeClientId((long)objectUID));
    }

    public boolean isMe(short clientId) {
        return clientId == this.getObjectManager().getClientId();
    }

    public boolean isServer(Long objectUID) {
        return this.isServer(ShortList.get((short)ObjectUID.decodeClientId((long)objectUID)));
    }

    public boolean isServer(Short clientId) {
        return this.getIDProcessor().isServer(clientId);
    }

    public boolean isChair() {
        return this.chair;
    }

    public void setChair(boolean chair) {
        this.chair = chair;
        if (this.controller != null) {
            this.controller.setChair();
        }
    }

    public boolean isShowThumbnails() {
        return this.showThumbnails;
    }

    public void setThumbnailShow(boolean showThumbnails) {
        this.showThumbnails = showThumbnails;
    }

    public boolean isFollowDefault() {
        return this.followDefault;
    }

    public void setFollowDefault(boolean followDefault) {
        this.followDefault = followDefault;
    }

    public boolean isSupervised() {
        return this.supervised;
    }

    public void setSupervised(boolean supervised) {
        this.supervised = supervised;
    }

    public boolean isDefaultAccess() {
        return this.defaultAccess;
    }

    public void setDefaultAccess(boolean defaultAccess) {
        this.defaultAccess = defaultAccess;
    }

    public boolean isAccessible() {
        return this.accessible && !this.isPlayback();
    }

    public boolean isAccessible(ScreenModel screen) {
        if (screen == null) {
            return this.isAccessible();
        }
        return screen.isAccessible() && !this.isPlayback();
    }

    public void setAccessible(boolean accessible) {
        this.accessible = accessible;
        this.fireAccessibleChangeListeners();
    }

    public void addAccessibleChangeListener(AccessibleChangeListener l) {
        this.accessibleChangeListeners.add(l);
    }

    public void removeAccessibleChangeListener(AccessibleChangeListener l) {
        this.accessibleChangeListeners.remove(l);
    }

    private void fireAccessibleChangeListeners() {
        Iterator iter = this.accessibleChangeListeners.iterator();
        while (iter.hasNext()) {
            try {
                ((AccessibleChangeListener)iter.next()).onAccessibleChange(this.accessible);
            }
            catch (Exception exception) {}
        }
    }

    public void addCanvasChangeListener(CanvasChangeListener l) {
        this.canvasChangeListeners.add(l);
    }

    public void removeCanvasChangeListener(CanvasChangeListener l) {
        this.canvasChangeListeners.remove(l);
    }

    public void fireCanvasChangeListeners() {
        Iterator iter = this.canvasChangeListeners.iterator();
        while (iter.hasNext()) {
            try {
                ((CanvasChangeListener)iter.next()).onCanvasChange();
            }
            catch (Exception exception) {}
        }
    }

    public WBScaler getScaler() {
        return this.scaler;
    }

    public int getScalerAspect() {
        if (this.scaler == null || this.autoScaleMask) {
            return 4;
        }
        return this.scaler.getAspect();
    }

    public double getScaleX() {
        double scale = this.scaler == null || this.autoScaleMask ? 1.0 : this.scaler.getScaleX();
        return scale;
    }

    public double getScaleY() {
        double scale = this.scaler == null || this.autoScaleMask ? 1.0 : this.scaler.getScaleY();
        return scale;
    }

    public boolean isAutoScaler() {
        if (this.scaler != null) {
            return this.scaler.isAutoScaler();
        }
        return false;
    }

    public boolean isScaled() {
        if (this.scaler == null) {
            return false;
        }
        return this.scaler.getScaleX() != 1.0 || this.scaler.getScaleY() != 0.0;
    }

    public void setScaleX(double scaleX) {
        if (this.scaler != null) {
            this.scaler.setScaleX(scaleX);
        }
    }

    public void setScaleY(double scaleY) {
        if (this.scaler != null) {
            this.scaler.setScaleY(scaleY);
        }
    }

    public void setScaler(WBScaler scaler) {
        this.scaler = scaler;
    }

    public boolean maskAutoScale() {
        return this.autoScaleMask;
    }

    public boolean maskAutoScale(boolean maskAutoScale) {
        boolean result = this.autoScaleMask;
        this.autoScaleMask = maskAutoScale;
        return result;
    }

    public ClientIdentification getIDProcessor() {
        return this.clientIdentification;
    }

    public Object[] getScreenClipboard() {
        if (this.screenClipboard == null) {
            this.screenClipboard = new ScreenModel[0];
        }
        return this.screenClipboard;
    }

    public void setScreenClipboard(Object[] obj) {
        this.screenClipboard = obj;
        this.fireScreenClipboardListeners(obj);
    }

    private void fireScreenClipboardListeners(Object[] obj) {
        Iterator iter = this.screenClipboardListeners.iterator();
        while (iter.hasNext()) {
            ((ScreenClipboardListener)iter.next()).onScreenClipboard(obj);
        }
    }

    public void addScreenClipboardListener(ScreenClipboardListener l) {
        if (!this.screenClipboardListeners.contains(l)) {
            this.screenClipboardListeners.add(l);
        }
    }

    public void removeScreenClipboardListener(ScreenClipboardListener l) {
        this.screenClipboardListeners.remove(l);
    }

    public Object[] getToolClipboard() {
        if (this.toolClipboard == null) {
            this.toolClipboard = new AbstractToolModel[0];
        }
        return this.toolClipboard;
    }

    public void setToolClipboard(Object[] obj) {
        ++this.toolClipboardGeneration;
        this.toolClipboard = obj;
        this.fireToolClipboardListeners(obj);
    }

    public int getToolClipboardGeneration() {
        return this.toolClipboardGeneration;
    }

    private void fireToolClipboardListeners(Object[] obj) {
        Iterator iter = this.toolClipboardListeners.iterator();
        while (iter.hasNext()) {
            ((ToolClipboardListener)iter.next()).onToolClipboard(obj);
        }
    }

    public void addToolClipboardListener(ToolClipboardListener l) {
        if (!this.toolClipboardListeners.contains(l)) {
            this.toolClipboardListeners.add(l);
        }
    }

    public void removeToolClipboardListener(ToolClipboardListener l) {
        this.toolClipboardListeners.remove(l);
    }

    public void gotoScreen(Long screenUID, boolean informController) {
        if (screenUID == null) {
            this.pendingGoToUID = null;
            return;
        }
        if (informController && this.controller != null) {
            this.controller.gotoConferenceScreen(screenUID);
        } else {
            this.getDataExporter().goneToScreen(this.onScreen, screenUID);
            this.onScreen = screenUID;
        }
        try {
            Object template = this.uniqueObjectManager.getObjectFromMap(screenUID);
            if (template != null) {
                this.reportGoTo(screenUID);
            } else {
                this.pendingGoToUID = screenUID;
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"gotoScreen", (Throwable)ex, (boolean)false);
        }
    }

    private void reportGoTo(Long screenUID) {
        block10: {
            try {
                Object template = this.uniqueObjectManager.getObjectFromMap(screenUID);
                if (template instanceof WBNodeProxy) {
                    return;
                }
                this.pendingGoToUID = null;
                if (this.recorderIndexAPI == null) break block10;
                if (template instanceof ScreenModel) {
                    try {
                        String screenName = ((ScreenModel)template).getScreenName();
                        I18nMessage mod = this.i18n.getMessage((PropertiesEnum)StringsProperties.WHITEBOARDCONTEXT_INDEXICON);
                        I18nMessage kind = this.i18n.getMessage((PropertiesEnum)StringsProperties.WHITEBOARDCONTEXT_INDEXSLIDECHANGE);
                        this.recorderIndexAPI.addIndexMark(mod, kind, new I18nMessage(screenName));
                        String topicName = null;
                        Long targetTopicUID = null;
                        WBNode parent = ((ScreenModel)template).getParent();
                        if (parent != null) {
                            targetTopicUID = parent.getObjectID();
                            topicName = parent instanceof ScreenModel ? ((ScreenModel)parent).getScreenName() : parent.getDisplayName();
                        } else {
                            targetTopicUID = NO_TOPIC_UID;
                            topicName = "";
                        }
                        if (this.currentTopicUID == null || !this.currentTopicUID.equals(targetTopicUID)) {
                            if (topicName == null) {
                                topicName = "";
                            }
                            kind = this.i18n.getMessage((PropertiesEnum)StringsProperties.WHITEBOARDCONTEXT_INDEXTOPICCHANGE);
                            this.recorderIndexAPI.addIndexMark(mod, kind, new I18nMessage(topicName));
                            this.currentTopicUID = targetTopicUID;
                        }
                        break block10;
                    }
                    catch (Throwable t) {
                        LogSupport.exception((Object)this, (String)"reportGoTo", (Throwable)t, (boolean)true, (String)("Failed to add index mark: " + screenUID));
                    }
                    break block10;
                }
                LogSupport.message((Object)this, (String)"reportGoTo", (String)("ObjectUID " + screenUID + " does not refer to a ScreenModel: " + (template == null ? "N/A" : template.getClass().getName()) + " " + template));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void nodeAdded(WBNode addedNode, WBNode parentNode) {
        if (this.pendingGoToUID != null && this.pendingGoToUID.equals(addedNode.getObjectID())) {
            this.reportGoTo(this.pendingGoToUID);
        }
        if (addedNode != null && addedNode.getDisplayName().contains(this.getDefaultPublicScreenName()) && parentNode instanceof ScreenRoot) {
            this.publicPageCount = (short)(this.publicPageCount + 1);
            ((ScreenRoot)parentNode).setNextScreenSequence(this.publicPageCount);
        }
    }

    @Override
    public void nodeRemoved(WBNode removedNode, int removedIndex, WBNode parentNode) {
    }

    public short[] participantsExcept(short omitAddress) {
        LinkedList<Short> participants = new LinkedList<Short>();
        for (ClientInfo client : this.clients) {
            if (client.isMe() || client.getAddress() == omitAddress) continue;
            participants.add(ShortList.get((short)client.getAddress()));
        }
        short[] targets = new short[participants.size()];
        Iterator iter = participants.iterator();
        int i = 0;
        while (iter.hasNext()) {
            targets[i++] = (Short)iter.next();
        }
        return targets;
    }

    public HashMap getCommStateData() {
        return this.commStateData;
    }

    public void addOnlineListener(OnlineListener l) {
        this.onlineListeners.add(l);
    }

    public void removeOnlineListener(OnlineListener l) {
        this.onlineListeners.remove(l);
    }

    public void addDeleteListener(DeleteListener l) {
        this.deleteListeners.add(l);
    }

    public void removeDeleteListener(DeleteListener l) {
        this.deleteListeners.remove(l);
    }

    public void fireDeletion(Long id) {
        Iterator iter = this.deleteListeners.iterator();
        while (iter.hasNext()) {
            try {
                ((DeleteListener)iter.next()).onDelete(id);
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"fireDeletion", (Throwable)ex, (boolean)true);
            }
        }
    }

    public void addSelectionListener(SelectionListener l) {
        this.selectionListeners.add(l);
    }

    public void removeSelectionListener(SelectionListener l) {
        this.selectionListeners.remove(l);
    }

    public void fireSelection(AbstractToolModel tool, boolean selected) {
        Iterator iter = this.selectionListeners.iterator();
        while (iter.hasNext()) {
            try {
                ((SelectionListener)iter.next()).onSelect(tool, selected);
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"fireSelection", (Throwable)ex, (boolean)true);
            }
        }
    }

    public void addShutdownListener(ShutdownListener l) {
        if (!this.shutdownListeners.contains(l)) {
            this.shutdownListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addThumbnailResolver(ThumbnailResolver resolver) {
        if (this.thumbnailResolverThread == null) {
            this.thumbnailResolverThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        WhiteboardContext.this.thumbnailResolverThread;
                        if (Thread.interrupted()) break;
                        try {
                            ThumbnailResolver resolver;
                            LinkedList linkedList = WhiteboardContext.this.thumbnailResolverQueue;
                            synchronized (linkedList) {
                                if (WhiteboardContext.this.thumbnailResolverQueue.isEmpty()) {
                                    WhiteboardContext.this.thumbnailResolverIdle = true;
                                    try {
                                        WhiteboardContext.this.thumbnailResolverQueue.wait();
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    WhiteboardContext.this.thumbnailResolverIdle = false;
                                }
                                resolver = WhiteboardContext.this.thumbnailResolverQueue.isEmpty() ? null : (ThumbnailResolver)WhiteboardContext.this.thumbnailResolverQueue.removeFirst();
                            }
                            if (resolver == null) continue;
                            if (resolver.isVisible()) {
                                resolver.resolve();
                                continue;
                            }
                            resolver.abandonResolving();
                        }
                        catch (Throwable t) {
                            LogSupport.exception((Object)this, (String)"run", (Throwable)t, (boolean)true);
                        }
                    }
                    WhiteboardContext.this.thumbnailResolverThread = null;
                }
            }, "Thumbnail Resolver Thread");
            this.thumbnailResolverThread.setPriority(1);
            this.thumbnailResolverThread.setDaemon(true);
            this.thumbnailResolverIdle = false;
            this.thumbnailResolverThread.start();
        }
        resolver.setResolving();
        LinkedList<ThumbnailResolver> linkedList = this.thumbnailResolverQueue;
        synchronized (linkedList) {
            this.thumbnailResolverQueue.addLast(resolver);
            if (this.thumbnailResolverIdle) {
                this.thumbnailResolverQueue.notify();
            }
        }
    }

    public void removeShutdownListener(ShutdownListener l) {
        this.shutdownListeners.remove(l);
    }

    private void fireShutdown() {
        if (this.thumbnailResolverThread != null) {
            this.thumbnailResolverThread.interrupt();
        }
        ArrayList shutdowns = (ArrayList)this.shutdownListeners.clone();
        Iterator iter = shutdowns.iterator();
        while (iter.hasNext()) {
            try {
                ((ShutdownListener)iter.next()).onShutdown();
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"fireShutdown", (Throwable)ex, (boolean)true);
            }
        }
    }

    public void addAttributeChangeListener(AttributeChangeListener l) {
        this.attributeChangeListeners.add(l);
    }

    public void removeAttributeChangeListener(AttributeChangeListener l) {
        this.attributeChangeListeners.remove(l);
    }

    public void fireAttributeChange(AbstractAttribute attribute) {
        Iterator iter = this.attributeChangeListeners.iterator();
        while (iter.hasNext()) {
            try {
                ((AttributeChangeListener)iter.next()).onAttributeChange(attribute);
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"fireAttributeChange", (Throwable)ex, (boolean)true);
            }
        }
    }

    public ButtonBehaviour getButtonBehaviour() {
        return this.buttonBehaviour;
    }

    public ACLManager getACLManager() {
        return this.aclManager;
    }

    public ClientList getClientList() {
        return this.clients;
    }

    public void setClientList(ClientList clients) {
        this.clients = clients;
        this.getIDProcessor().setMyAddress(clients.getMyAddress());
        if (this.controller != null) {
            this.controller.setClientList(clients);
        }
    }

    public void setSelectMode() {
        if (this.controller != null) {
            this.controller.setSelectMode();
        }
    }

    public WBClipboardInterface getWBClipboard() {
        return this.wbClipboard;
    }

    public void setWBClipboard(WBClipboardInterface wbClipboard) {
        this.wbClipboard = wbClipboard;
    }

    public ControllerPaneInterface getController() {
        return this.controller;
    }

    public void setController(ControllerPaneInterface controller) {
        this.controller = controller;
    }

    public DataModel getDataModel() {
        return this.dataModel;
    }

    public boolean isRenamingSystemGeneratedNames() {
        return this.renamingSystemGeneratedNames;
    }

    public void setRenamingSystemGeneratedNames(boolean rename) {
        this.renamingSystemGeneratedNames = rename;
    }

    public WhiteboardDataProcessor getDataProcessor() {
        return this.dataProcessor;
    }

    public void setDataProcessor(WhiteboardDataProcessor processor) {
        this.dataProcessor = processor;
    }

    public UniqueObjectManager getObjectManager() {
        return this.uniqueObjectManager;
    }

    public MediaCache getMediaCache() {
        return this.mediaCache;
    }

    public ItemCache getItemCache() {
        return this.itemCache;
    }

    public TemplateRegistry getTemplateRegistry() {
        return this.templateRegistry;
    }

    public void clearTemplateRegistry() {
        this.templateRegistry.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void svcStop() {
        DataModel dataModel = this.dataModel;
        synchronized (dataModel) {
            if (this.dataProcessor != null) {
                this.dataProcessor.dispose();
            }
            if (this.statusIndicators != null) {
                this.statusIndicators.shutdown();
                this.statusIndicators = null;
            }
            if (this.timedExecution != null) {
                this.timedExecution.shutdown();
                this.timedExecution = null;
            }
        }
        this.fireShutdown();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("\nWhiteboardContext: online: " + this.online + ", client: " + this.client + ", chair: " + this.chair + ", conferenceUID: " + this.conferenceUID + "\n");
        buf.append("CommStateData: ");
        Iterator iter = this.commStateData.keySet().iterator();
        while (iter.hasNext()) {
            buf.append(iter.next());
            if (iter.hasNext()) {
                buf.append("\n\t");
                continue;
            }
            buf.append("\n");
        }
        buf.append(" ScreenClipboard: " + this.screenClipboard + ", toolClipboard: " + this.toolClipboard);
        buf.append("  oldImageFile: " + this.oldImageFile + ", fileToSave: " + this.fileToSave + ", fileToLoad: " + this.fileToLoad + "\n");
        return buf.toString();
    }

    public String getDefaultPublicGroupName() {
        return this.defaultPublicGroupName;
    }

    public String getDefaultPublicScreenName() {
        return this.defaultPublicScreenName;
    }

    public String getDefaultWorkScreenName() {
        return this.defaultWorkScreenName;
    }

    public void setDefaultPublicGroupName(String defaultPublicGroupName) {
        if (defaultPublicGroupName != null) {
            this.defaultPublicGroupName = defaultPublicGroupName;
        }
    }

    public void setDefaultPublicScreenName(String defaultPublicScreenName) {
        if (defaultPublicScreenName != null) {
            this.defaultPublicScreenName = defaultPublicScreenName;
        }
    }

    public void setDefaultWorkScreenName(String defaultWorkScreenName) {
        if (defaultWorkScreenName != null) {
            this.defaultWorkScreenName = defaultWorkScreenName;
        }
    }

    public Imps getImps() {
        return this.imps;
    }

    public void setImps(Imps imps) {
        this.imps = imps;
    }

    public void setDialogParentProvider(DialogParentProvider dpp) {
        this.dialogParentProvider = dpp;
    }

    public ThrowableListener getThrowableListener() {
        return this.throwableListener;
    }

    public void setThrowableListener(ThrowableListener l) {
        this.throwableListener = l;
    }
}

