/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard;

import com.elluminate.groupware.whiteboard.WhiteboardContext;

public class WBScaler
implements Comparable<WBScaler> {
    public static final int MIN_SCALE_PERCENT = 10;
    public static final int MAX_SCALE_PERCENT = 1000;
    public static final int FILL_PAGE = 0;
    public static final int FILL_WIDTH = 1;
    public static final int FILL_HEIGHT = 2;
    public static final int FILL_SCREEN = 3;
    public static final int FIXED = 4;
    private int aspect = 4;
    protected boolean autoScaler = false;
    private WhiteboardContext context;
    private String scalerName;
    protected double scaleX;
    protected double scaleY;

    public WBScaler(String name, double scaleX, double scaleY) {
        this.scalerName = name;
        this.scaleX = scaleX;
        this.scaleY = scaleY;
    }

    public WBScaler(String name, double scaleX, double scaleY, WhiteboardContext context) {
        this(name, scaleX, scaleY);
        this.context = context;
    }

    public WBScaler(String name, WhiteboardContext context, int aspect) {
        this(name, 1.0, 1.0);
        this.context = context;
        this.aspect = aspect;
    }

    @Override
    public int compareTo(WBScaler arg0) {
        return this.scalerName.compareTo(arg0.scalerName);
    }

    public String displayName() {
        return this.scalerName;
    }

    public boolean equals(String name) {
        return name.startsWith(this.scalerName);
    }

    public final int getAspect() {
        return this.aspect;
    }

    public final String getName() {
        return this.scalerName;
    }

    public final double getScaleX() {
        return this.scaleX;
    }

    public final double getScaleY() {
        return this.scaleY;
    }

    public final int hashCode() {
        return this.scalerName.hashCode();
    }

    final boolean isAutoScaler() {
        return this.autoScaler;
    }

    public final void parseArgument(String argument) {
        try {
            String arg = argument.substring(this.scalerName.length());
            this.initArgument(arg);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void initArgument(String arg) {
    }

    public String generateArgument() {
        return this.scalerName;
    }

    public final void setScaleX(double scaleX) {
        if (this.autoScaler) {
            this.scaleX = scaleX;
        }
    }

    public final void setScaleY(double scaleY) {
        if (this.autoScaler) {
            this.scaleY = scaleY;
        }
    }

    public String toString() {
        return this.scalerName;
    }
}

