/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.x11;

import com.elluminate.gui.GUIDebug;
import com.elluminate.gui.GuiUtils;
import com.elluminate.gui.HotKey;
import com.elluminate.gui.x11.X11HotKey;
import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.log.LogSupport;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;

public class X11GuiSupport
extends GuiUtils.PlatformGuiSupport {
    private final boolean INSETS_BUG = !Platform.checkJavaVersion((String)"1.7+");

    @Override
    public Insets getScreenInsets(GraphicsConfiguration graphConfig) {
        if (this.INSETS_BUG) {
            try {
                String display = graphConfig.getDevice().getIDstring();
                Insets result = X11GuiSupport.getScreenInsetsNative(display);
                if (result != null) {
                    if (GUIDebug.INSETS.show()) {
                        LogSupport.message((Object)this, (String)"getScreenInsets", (String)("insets(JNI)=" + result.top + "," + result.left + "," + result.bottom + "," + result.right));
                    }
                    return result;
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        Insets result = null;
        result = super.getScreenInsets(graphConfig);
        if (GUIDebug.INSETS.show()) {
            LogSupport.message((Object)this, (String)"getScreenInsets", (String)("insets(toolkit)=" + result.top + "," + result.left + "," + result.bottom + "," + result.right));
        }
        return result;
    }

    @Override
    public boolean hasHotKeys() {
        return X11HotKey.isSupported();
    }

    @Override
    public HotKey createHotKey(int keyCode, int keyModifiers, Runnable action) {
        X11HotKey hkey;
        block3: {
            hkey = null;
            if (this.hasHotKeys()) {
                try {
                    hkey = new X11HotKey(keyCode, keyModifiers, action);
                }
                catch (Throwable t) {
                    hkey = null;
                    if (!GUIDebug.HOT_KEYS.show()) break block3;
                    LogSupport.message((Object)this, (String)"createHotKey", (String)Debug.getStackTrace((Throwable)t));
                }
            }
        }
        return hkey;
    }

    @Override
    public void shutDownHotKeys() {
        block3: {
            if (this.hasHotKeys()) {
                try {
                    X11HotKey.shutdown();
                }
                catch (Throwable t) {
                    if (!GUIDebug.HOT_KEYS.show()) break block3;
                    LogSupport.message((Object)this, (String)"shutDownHotKeys", (String)Debug.getStackTrace((Throwable)t));
                }
            }
        }
    }

    private static native Insets getScreenInsetsNative(String var0);

    static {
        System.loadLibrary("X11Support");
        if (!X11HotKey.isSupported()) {
            LogSupport.message(X11GuiSupport.class, (String)"<clinit>", (String)"No hot key support.");
        }
    }
}

