/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.swing;

import com.elluminate.gui.swing.StringsProperties;
import com.elluminate.gui.swing.TableModelChain;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.ShortList;
import com.elluminate.util.StringUtils;
import com.elluminate.util.SwingRunnerSupport;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;

public class TableSorter
extends TableModelChain {
    public static final String SORT_COLUMN = "sortColumn";
    public static final String SORT_ORDER = "sortOrder";
    public static final int NOT_SORTED = -1;
    private static final boolean HAS_MAC_CLIENT_PROPS = Platform.checkOSVersion((int)202, (String)"10.5+");
    private I18n i18n = I18n.create((Object)this);
    private JTableHeader header = null;
    private GestureHandler gestureHandler = new GestureHandler();
    private DeferredNotify deferredNotifier = new DeferredNotify();
    private Icon ascendingIcon = this.i18n.getIcon((PropertiesEnum)StringsProperties.TABLESORTER_ASCENDINGICON);
    private Icon descendingIcon = this.i18n.getIcon((PropertiesEnum)StringsProperties.TABLESORTER_DESCENDINGICON);
    private Dimension iconSize = null;
    private ArrayList disallowColumn = new ArrayList();
    private boolean ascending = true;
    private int sortColumn = -1;
    private int defaultSortColumn = -1;
    private boolean defaultSortAscending = true;
    private Comparator sortComparator = null;
    private Comparator[] columnComparator = null;
    private HashMap defaultComparator = new HashMap();
    private boolean sortInvalid = false;
    private Indirector[] indirection = null;
    private int[] reverse = null;
    private PropertyChangeSupport propSupport = new PropertyChangeSupport(this);

    public static TableSorter getSorter(JTable table) {
        TableModel mod = table.getModel();
        if (mod instanceof TableSorter) {
            return (TableSorter)mod;
        }
        while (mod != null) {
            TableModel mod2 = null;
            if (mod instanceof TableModelChain) {
                mod2 = ((TableModelChain)mod).getTableModel();
            }
            if (mod2 == null) break;
            if (mod2 instanceof TableSorter) {
                return (TableSorter)mod2;
            }
            mod = mod2;
        }
        return null;
    }

    public TableSorter() {
        this.setDefaultComparator(String.class, StringUtils.LOCAL_INSENSITIVE_COMPARATOR);
    }

    public TableSorter(TableModel tm) {
        super(tm);
        this.setDefaultComparator(String.class, StringUtils.LOCAL_INSENSITIVE_COMPARATOR);
    }

    public JTableHeader getTableHeader() {
        return this.header;
    }

    public void setTableHeader(JTableHeader hdr) {
        if (this.header != null) {
            this.header.removeMouseListener(this.gestureHandler);
        }
        this.header = hdr;
        if (this.header != null) {
            this.header.addMouseListener(this.gestureHandler);
        }
    }

    public Dimension getHeaderIconSize() {
        if (this.iconSize == null) {
            int w1 = this.ascendingIcon.getIconWidth();
            int h1 = this.ascendingIcon.getIconHeight();
            int w2 = this.descendingIcon.getIconWidth();
            int h2 = this.descendingIcon.getIconHeight();
            this.iconSize = new Dimension(Math.max(w1, w2), Math.max(h1, h2));
        }
        return this.iconSize;
    }

    public Icon getHeaderIcon(int colIdx) {
        if (HAS_MAC_CLIENT_PROPS) {
            return null;
        }
        if (this.sortColumn < 0) {
            return null;
        }
        if (colIdx != this.sortColumn) {
            return null;
        }
        if (this.ascending) {
            return this.ascendingIcon;
        }
        return this.descendingIcon;
    }

    public boolean isColumnAllowed(int colIdx) {
        if (colIdx < 0 || colIdx > Short.MAX_VALUE) {
            return false;
        }
        Short key = ShortList.get((short)((short)colIdx));
        return !this.disallowColumn.contains(key);
    }

    public void setColumnAllowed(int colIdx, boolean allowed) {
        if (colIdx < 0 || colIdx > Math.min(Short.MAX_VALUE, this.getColumnCount())) {
            throw new IllegalArgumentException("Invalid column index: " + colIdx);
        }
        Short key = ShortList.get((short)((short)colIdx));
        if (allowed) {
            this.disallowColumn.remove(key);
        } else if (!this.disallowColumn.contains(key)) {
            this.disallowColumn.add(key);
        }
    }

    public boolean isSorting() {
        return this.sortColumn >= 0;
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    public void setSortColumn(int colIdx) {
        int prevCol = this.sortColumn;
        if (colIdx != -1 && (colIdx < 0 || colIdx >= this.getColumnCount())) {
            colIdx = -1;
        }
        if (colIdx == -1) {
            if (this.sortColumn == this.defaultSortColumn && this.ascending == this.defaultSortAscending) {
                this.updatePLAF();
                return;
            }
            this.sortColumn = this.defaultSortColumn;
            this.ascending = this.defaultSortAscending;
        } else {
            if (!this.isColumnAllowed(colIdx)) {
                return;
            }
            if (this.sortColumn == colIdx) {
                return;
            }
            this.sortColumn = colIdx;
        }
        this.updatePLAF();
        this.sortInvalid = true;
        this.sortComparator = this.getComparator(this.sortColumn);
        this.propSupport.firePropertyChange(SORT_COLUMN, prevCol, this.sortColumn);
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean val) {
        if (this.ascending == val) {
            return;
        }
        boolean wasAscending = this.ascending;
        this.ascending = val;
        this.updatePLAF();
        this.sortInvalid |= this.sortColumn >= 0;
        this.propSupport.firePropertyChange(SORT_ORDER, wasAscending, this.ascending);
    }

    private void updatePLAF() {
        if (HAS_MAC_CLIENT_PROPS) {
            Integer colProp = null;
            String ascProp = null;
            if (this.sortColumn != -1) {
                colProp = new Integer(this.sortColumn);
                ascProp = this.ascending ? "ascending" : "decending";
            }
            this.header.putClientProperty("JTableHeader.selectedColumn", colProp);
            this.header.putClientProperty("JTableHeader.sortDirection", ascProp);
        }
    }

    public int getDefaultSortColumn() {
        return this.defaultSortColumn;
    }

    public boolean isDefaultSortAscending() {
        return this.defaultSortAscending;
    }

    public void setDefaultSort(int colIdx, boolean ascend) {
        boolean usingDefault;
        boolean bl = usingDefault = this.sortColumn == this.defaultSortColumn;
        if (colIdx < 0 || colIdx >= this.getColumnCount() && colIdx != -1) {
            throw new IllegalArgumentException("Invalid column index: " + colIdx);
        }
        if (this.defaultSortColumn == colIdx && this.defaultSortAscending == ascend) {
            return;
        }
        this.defaultSortColumn = colIdx;
        this.defaultSortAscending = ascend;
        if (usingDefault) {
            this.setSortColumn(this.defaultSortColumn);
            this.setAscending(this.defaultSortAscending);
        }
    }

    public Comparator getComparator(int colIdx) {
        if (colIdx == -1) {
            return null;
        }
        Comparator result = this.getColumnComparator(colIdx);
        if (result == null) {
            result = this.getDefaultComparator(this.getColumnClass(colIdx));
        }
        return result;
    }

    public Comparator getColumnComparator(int colIdx) {
        if (this.columnComparator == null) {
            return null;
        }
        if (colIdx < 0 || colIdx >= this.columnComparator.length) {
            return null;
        }
        return this.columnComparator[colIdx];
    }

    public void setColumnComparator(int colIdx, Comparator cmp) {
        if (!(colIdx >= 0 && colIdx < this.getColumnCount() || colIdx >= 0 && colIdx <= this.getColumnCount())) {
            throw new IllegalArgumentException("Invalid column index: " + colIdx);
        }
        if (this.columnComparator == null) {
            this.columnComparator = new Comparator[this.getColumnCount()];
        } else if (colIdx >= this.columnComparator.length) {
            Comparator[] old = this.columnComparator;
            this.columnComparator = new Comparator[this.getColumnCount()];
            for (int ix = 0; ix < old.length; ++ix) {
                this.columnComparator[ix] = old[ix];
            }
        }
        this.columnComparator[colIdx] = cmp;
        this.sortInvalid = true;
    }

    public Comparator getDefaultComparator(Class cls) {
        if (cls == null) {
            return null;
        }
        return (Comparator)this.defaultComparator.get(cls);
    }

    public void setDefaultComparator(Class cls, Comparator cmp) {
        this.defaultComparator.put(cls, cmp);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propSupport.addPropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String propName, PropertyChangeListener l) {
        this.propSupport.addPropertyChangeListener(propName, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propSupport.removePropertyChangeListener(l);
    }

    public void removePropertyChangeListener(String propName, PropertyChangeListener l) {
        this.propSupport.removePropertyChangeListener(propName, l);
    }

    public boolean sortTable() {
        if (this.sortInvalid) {
            this.sortTableData();
            return true;
        }
        return false;
    }

    @Override
    public int getModelRow(int rowIdx) {
        if (this.sortInvalid) {
            this.sortTableData();
        }
        if (this.indirection == null) {
            return rowIdx;
        }
        if (rowIdx < 0 || rowIdx >= this.indirection.length) {
            return rowIdx;
        }
        return this.indirection[rowIdx].index;
    }

    @Override
    public int getLocalRow(int rowIdx) {
        if (this.sortInvalid) {
            this.sortTableData();
        }
        if (this.reverse == null) {
            return rowIdx;
        }
        if (rowIdx < 0 || rowIdx >= this.reverse.length) {
            return rowIdx;
        }
        return this.reverse[rowIdx];
    }

    @Override
    public void tableChanged(TableModelEvent ev) {
        boolean singleRow;
        if (ev.getFirstRow() == -1) {
            this.setSortColumn(-1);
            this.setAscending(true);
        }
        if (this.sortColumn < 0) {
            this.fireTableChanged(ev);
            return;
        }
        boolean bl = singleRow = ev.getFirstRow() == ev.getLastRow();
        if (!this.includesSortCol(ev.getColumn()) && singleRow && !this.sortInvalid) {
            int r = this.getModelRow(ev.getFirstRow());
            this.fireTableChanged(new TableModelEvent(this, r, r, ev.getColumn(), ev.getType()));
            return;
        }
        this.invalidateSort();
        this.deferredNotifier.schedule();
    }

    private void invalidateSort() {
        this.sortInvalid = true;
    }

    private void sortTableData() {
        this.sortInvalid = false;
        if (this.sortColumn < 0) {
            this.indirection = null;
            this.reverse = null;
        } else {
            int ix;
            if (this.indirection == null || this.indirection.length != this.getRowCount()) {
                this.indirection = new Indirector[this.getRowCount()];
                this.reverse = new int[this.indirection.length];
                for (ix = 0; ix < this.indirection.length; ++ix) {
                    this.indirection[ix] = new Indirector(ix);
                }
            }
            Arrays.sort(this.indirection);
            for (ix = 0; ix < this.indirection.length; ++ix) {
                this.reverse[this.indirection[ix].index] = ix;
            }
        }
        this.fireTableDataChanged();
    }

    private boolean includesSortCol(int col) {
        if (this.sortColumn < 0) {
            return false;
        }
        if (col == -1) {
            return true;
        }
        return col == this.sortColumn;
    }

    private class DeferredNotify
    implements Runnable {
        private volatile boolean pending = false;

        private DeferredNotify() {
        }

        @Override
        public void run() {
            this.pending = false;
            TableSorter.this.fireTableDataChanged();
        }

        public void schedule() {
            if (this.pending) {
                return;
            }
            this.pending = true;
            SwingRunnerSupport.invokeLater((Runnable)this);
        }
    }

    private class GestureHandler
    extends MouseAdapter {
        private GestureHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            JTableHeader hdr = null;
            int colIdx = -1;
            try {
                hdr = (JTableHeader)me.getComponent();
                colIdx = hdr.columnAtPoint(me.getPoint());
            }
            catch (Throwable t) {
                colIdx = -1;
                hdr = null;
                t.printStackTrace();
            }
            if (colIdx >= 0 && TableSorter.this.isColumnAllowed(colIdx)) {
                if (colIdx == TableSorter.this.getSortColumn()) {
                    if (TableSorter.this.ascending) {
                        TableSorter.this.setAscending(false);
                    } else {
                        TableSorter.this.setSortColumn(-1);
                    }
                } else {
                    TableSorter.this.setSortColumn(colIdx);
                    TableSorter.this.setAscending(true);
                }
                TableSorter.this.sortTableData();
                hdr.repaint();
            }
        }
    }

    private class Indirector
    implements Comparable {
        int index = -1;

        Indirector(int idx) {
            this.index = idx;
        }

        public int compareTo(Object obj) {
            int result = this.doCompare(obj);
            if (!TableSorter.this.ascending) {
                result = -result;
            }
            return result;
        }

        private int doCompare(Object obj) {
            Object val2;
            int index2 = ((Indirector)obj).index;
            if (TableSorter.this.sortColumn < 0) {
                if (this.index < index2) {
                    return -1;
                }
                if (this.index > index2) {
                    return 1;
                }
                return 0;
            }
            Object val = TableSorter.this.model.getValueAt(this.index, TableSorter.this.sortColumn);
            if (val == (val2 = TableSorter.this.model.getValueAt(index2, TableSorter.this.sortColumn))) {
                return 0;
            }
            if (val == null) {
                return -1;
            }
            if (val2 == null) {
                return 1;
            }
            if (TableSorter.this.sortComparator != null) {
                return TableSorter.this.sortComparator.compare(val, val2);
            }
            if (val instanceof Comparable) {
                return ((Comparable)val).compareTo(val2);
            }
            Comparator cmp = TableSorter.this.getDefaultComparator(String.class);
            if (cmp != null) {
                return cmp.compare(val.toString(), val2.toString());
            }
            return val.toString().compareToIgnoreCase(val2.toString());
        }
    }
}

