/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.print;

import com.elluminate.gui.print.DocumentPrintable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.util.ArrayList;
import javax.swing.JEditorPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class DocumentPageable
extends DocumentPrintable
implements Pageable,
DocumentListener {
    private PageFormat pageFormat = null;
    private int pageCount = -1;
    private ArrayList<Rectangle> pageBounds = new ArrayList();

    public DocumentPageable(Document doc, String contentType, PageFormat fmt) {
        super(doc, contentType);
        this.pageFormat = fmt;
        this.paginate();
    }

    @Override
    public void changedUpdate(DocumentEvent ev) {
        this.paginate();
    }

    @Override
    public void insertUpdate(DocumentEvent ev) {
        this.paginate();
    }

    @Override
    public void removeUpdate(DocumentEvent ev) {
        this.paginate();
    }

    @Override
    public int getNumberOfPages() {
        return this.pageCount;
    }

    @Override
    public PageFormat getPageFormat(int pageIdx) {
        return this.pageFormat;
    }

    @Override
    public Printable getPrintable(int pageIdx) {
        if (super.getCurrentPage() != pageIdx - 1) {
            if (pageIdx == 0) {
                super.reset();
            } else {
                Rectangle b = this.pageBounds.get(pageIdx - 1);
                super.setPageBounds(pageIdx - 1, b);
            }
        }
        return this;
    }

    public void paginate() {
        int pos;
        this.pageCount = -1;
        this.pageBounds.clear();
        JEditorPane editorPane = super.getEditorPane();
        int pageX = (int)this.pageFormat.getImageableX();
        int pageY = (int)this.pageFormat.getImageableY();
        int pageWidth = (int)this.pageFormat.getImageableWidth();
        int pageHeight = (int)this.pageFormat.getImageableHeight();
        int wrapWidth = pageWidth;
        if (pageHeight < 1 || pageWidth < 1) {
            throw new RuntimeException("Invalid page size: " + pageWidth + "x" + pageHeight);
        }
        double scale = 1.0;
        int minWidth = (int)editorPane.getMinimumSize().getWidth();
        if (this.isScaleToFit() && minWidth > pageWidth) {
            scale = (double)pageWidth / (double)minWidth;
            wrapWidth = minWidth;
        }
        editorPane.setSize(wrapWidth, Integer.MAX_VALUE);
        editorPane.validate();
        int docLen = editorPane.getDocument().getLength();
        int dy = (int)((double)pageHeight / scale + 0.5);
        Point pt = new Point(0, 0);
        do {
            Rectangle bounds = new Rectangle(pt.x, pt.y, wrapWidth, 0);
            pt.y += dy;
            pos = editorPane.viewToModel(pt);
            Rectangle r = null;
            try {
                r = editorPane.modelToView(pos);
                pt.y = r.y;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            bounds.add(pt);
            this.pageBounds.add(bounds);
        } while (pos < docLen);
        this.pageCount = this.pageBounds.size();
    }
}

