/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.macosx;

import com.elluminate.gui.GUIDebug;
import com.elluminate.gui.macosx.CarbonHotKey;
import com.elluminate.platform.MacOSXPlatform;
import com.elluminate.util.Debug;
import com.elluminate.util.MTPriorityQueue;
import com.elluminate.util.QueuedProcessor;
import com.elluminate.util.QueuedProcessorAdapter;
import com.elluminate.util.log.LogSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

public final class CarbonHotKeyManager
implements CarbonHotKey.CarbonEventHandlerInterface,
PropertyChangeListener {
    public static final String DEBUG_FLAG = "HotKey";
    private static final int eventNotHandledErr = -9874;
    private static final int noErr = 0;
    private static final int kEventClassKeyboard = MacOSXPlatform.convertFileType((String)"keyb");
    private static final int kEventHotKeyPressed = 5;
    private static final int kEventHotKeyReleased = 6;
    private static final int kEventParamDirectObject = MacOSXPlatform.convertFileType((String)"----");
    private static final int kTypeEventHotKeyID = MacOSXPlatform.convertFileType((String)"hkid");
    private static MacOSXPlatform.CarbonLock carbonLock = MacOSXPlatform.getCarbonLock();
    private static long handlerRef = 0L;
    private static ArrayList keyList = new ArrayList();
    private static CarbonHotKeyManager instance = null;
    private MTPriorityQueue queue = null;

    public static boolean loadedOK() {
        return instance != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean registerHotKey(CarbonHotKey key) {
        boolean result = false;
        if (key == null) {
            return result;
        }
        Debug.lockEnter(null, (String)"registerHotKey", (String)"hotKeyList", (Object)keyList);
        try {
            ArrayList arrayList = keyList;
            synchronized (arrayList) {
                if (!keyList.contains(key)) {
                    result = keyList.add(key);
                }
            }
        }
        finally {
            Debug.lockLeave(null, (String)"registerHotKey", (String)"hotKeyList", (Object)keyList);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterHotKey(CarbonHotKey key) {
        if (key == null) {
            return;
        }
        Debug.lockEnter(null, (String)"unregisterHotKey", (String)"hotKeyList", (Object)keyList);
        try {
            ArrayList arrayList = keyList;
            synchronized (arrayList) {
                int which = keyList.indexOf(key);
                if (which >= 0) {
                    keyList.remove(which);
                }
            }
        }
        finally {
            Debug.lockLeave(null, (String)"unregisterHotKey", (String)"hotKeyList", (Object)keyList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeHotKeys() {
        Debug.lockEnter(null, (String)"removeHotKeys", (String)"hotKeyList", (Object)keyList);
        try {
            ArrayList arrayList = keyList;
            synchronized (arrayList) {
                for (Object candidate : keyList) {
                    try {
                        ((CarbonHotKey)candidate).dispose();
                    }
                    catch (Throwable throwable) {}
                }
                keyList.clear();
            }
        }
        finally {
            Debug.lockLeave(null, (String)"removeHotKeys", (String)"hotKeyList", (Object)keyList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CarbonHotKey findHotKey(long uid) {
        CarbonHotKey result = null;
        Debug.lockEnter(null, (String)"findHotKey", (String)"hotKeyList", (Object)keyList);
        try {
            ArrayList arrayList = keyList;
            synchronized (arrayList) {
                for (Object candidate : keyList) {
                    try {
                        if (((CarbonHotKey)candidate).getUniqueID() != uid) continue;
                        result = (CarbonHotKey)candidate;
                        break;
                    }
                    catch (Throwable t) {
                    }
                }
            }
        }
        finally {
            Debug.lockLeave(null, (String)"findHotKey", (String)"hotKeyList", (Object)keyList);
        }
        return result;
    }

    private CarbonHotKeyManager() {
        int err = this.createHandler();
        if (err != 0) {
            throw new RuntimeException("Mac OS error installing hot key Carbon event handler: " + err);
        }
        this.queue = new MTPriorityQueue("Carbon Hot Key Queue", (QueuedProcessor)new QueuedProcessorAdapter(){

            public void process(Object o, Object context) {
                CarbonHotKeyManager.this.doProcess(o);
            }
        });
        this.queue.process((Object)"Start");
    }

    public void dispose() {
        CarbonHotKeyManager.removeHotKeys();
        this.disposeHandler();
    }

    @Override
    public int carbonEventHandler(long handlerCallRef, long eventRec, int userData) {
        try {
            long[] hotKeyID = new long[1];
            int err = CarbonHotKey.carbonGetEventParameterHotKeyID(eventRec, kEventParamDirectObject, hotKeyID);
            if (err == 0 && this.processHotKeyEvent(hotKeyID[0])) {
                return 0;
            }
            return CarbonHotKey.carbonCallNextEventHandler(handlerCallRef, eventRec);
        }
        catch (Throwable t) {
            return -9874;
        }
    }

    private boolean processHotKeyEvent(long uid) {
        CarbonHotKey target = CarbonHotKeyManager.findHotKey(uid);
        if (target == null) {
            return false;
        }
        this.queue.process((Object)target);
        return true;
    }

    private void doProcess(Object obj) {
        if (!(obj instanceof CarbonHotKey)) {
            return;
        }
        CarbonHotKey target = (CarbonHotKey)obj;
        if (GUIDebug.HOT_KEYS.show()) {
            LogSupport.message((Object)this, (String)"doProcess", (String)("Triggered hot key: " + Long.toHexString(target.getUniqueID())));
        }
        target.runAction();
    }

    private int createHandler() {
        final CarbonHotKeyManager eventHandler = this;
        int err = carbonLock.runCarbonInt(new MacOSXPlatform.RunnableResult(){
            int result = 0;

            public void run() {
                block4: {
                    try {
                        long[] tmpRef = new long[]{0L};
                        this.result = CarbonHotKey.carbonInstallEventHandler(eventHandler, kEventClassKeyboard, 5, eventHandler.hashCode(), tmpRef);
                        if (this.result == 0) {
                            handlerRef = tmpRef[0];
                        }
                        if (GUIDebug.HOT_KEYS.show()) {
                            LogSupport.message((Object)((Object)this), (String)"createHandler", (String)("Registered event handler: " + kEventClassKeyboard + ":" + 5 + " ref=0x" + Long.toHexString(handlerRef) + " result=" + this.result));
                        }
                    }
                    catch (Throwable t) {
                        LogSupport.exception((Object)((Object)this), (String)"run (for CarbonHotKeyManager.createHandler)", (Throwable)t, (boolean)true);
                        if (this.result != 0) break block4;
                        this.result = -1;
                    }
                }
            }

            public int intResult() {
                return this.result;
            }
        });
        GUIDebug.HOT_KEYS.addPropertyChangeListener((PropertyChangeListener)this);
        CarbonHotKey.setDebugIONative(GUIDebug.HOT_KEYS.show());
        if (err != 0 && GUIDebug.HOT_KEYS.show()) {
            LogSupport.message((Object)this, (String)"createHandler", (String)("MacOS error in InstallEventHandler: " + err));
        } else if (GUIDebug.HOT_KEYS.show()) {
            LogSupport.message((Object)this, (String)"createHandler", (String)("Installed HotKey Carbon Event handler: " + handlerRef));
        }
        return err;
    }

    private void disposeHandler() {
        CarbonHotKeyManager eventHandler = this;
        GUIDebug.HOT_KEYS.removePropertyChangeListener((PropertyChangeListener)this);
        if (handlerRef == 0L) {
            return;
        }
        int err = carbonLock.runCarbonInt(new MacOSXPlatform.RunnableResult(){
            int result = 0;

            public void run() {
                block4: {
                    try {
                        if (handlerRef != 0L) {
                            long tmp = handlerRef;
                            handlerRef = 0L;
                            this.result = CarbonHotKey.carbonRemoveEventHandler(tmp);
                            if (GUIDebug.HOT_KEYS.show()) {
                                LogSupport.message((Object)((Object)this), (String)"createHandler", (String)("Registered event handler:  ref=0x" + Long.toHexString(tmp) + " result=" + this.result));
                            }
                        }
                    }
                    catch (Throwable t) {
                        LogSupport.exception((Object)((Object)this), (String)"run (for CarbonHotKeyManager.disposeHandler)", (Throwable)t, (boolean)true);
                        if (this.result != 0) break block4;
                        this.result = -1;
                    }
                }
            }

            public int intResult() {
                return this.result;
            }
        });
        if (err != 0 && GUIDebug.HOT_KEYS.show()) {
            LogSupport.message((Object)this, (String)"disposeHandler", (String)("MacOS error in RemoveEventHandler: " + err));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        if (ev.getSource() == GUIDebug.HOT_KEYS) {
            CarbonHotKey.setDebugIONative(GUIDebug.HOT_KEYS.show());
        }
    }

    static {
        try {
            instance = new CarbonHotKeyManager();
        }
        catch (Throwable t) {
            if (GUIDebug.HOT_KEYS.show()) {
                LogSupport.exception(CarbonHotKeyManager.class, (String)"<static>", (Throwable)t, (boolean)true);
            }
            instance = null;
        }
    }
}

