/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.dnd;

import com.elluminate.platform.Platform;
import com.elluminate.util.image.ImageMimeUtilities;
import com.elluminate.util.io.FileSysUtils;
import com.elluminate.util.log.LogSupport;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class UriListDataFlavor
extends DataFlavor {
    private static final File DOWNLOAD_DIR = new File(Platform.getTempDir(), "ElluminateDragDir");

    public UriListDataFlavor() throws ClassNotFoundException {
        super("text/uri-list;class=java.lang.String");
    }

    public List<File> getTransferFiles(Transferable transferable) throws UnsupportedFlavorException, IOException {
        boolean dereferenceURIs = false;
        try {
            DataFlavor mozImage = new DataFlavor("application/x-moz-nativeimage");
            dereferenceURIs = transferable.isDataFlavorSupported(mozImage);
        }
        catch (Throwable ignored) {
            dereferenceURIs = false;
        }
        String list = (String)transferable.getTransferData(this);
        return UriListDataFlavor.getTransferFiles(list, dereferenceURIs);
    }

    public static List<File> getTransferFiles(String list, boolean dereferenceURIs) {
        ArrayList<File> files = new ArrayList<File>();
        if (list == null) {
            return files;
        }
        StringTokenizer st = new StringTokenizer(list, "\r\n\u0000");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.startsWith("#")) continue;
            try {
                File f = new File(new URI(token));
                if (f.isFile()) {
                    files.add(f);
                    continue;
                }
            }
            catch (URISyntaxException ex) {
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            if (!dereferenceURIs) continue;
            try {
                URL url = new URL(token);
                URLConnection con = url.openConnection();
                String type = con.getContentType();
                if (ImageMimeUtilities.isValidImageMimeType((String)type)) {
                    File f = UriListDataFlavor.createTempFile(url);
                    if (f == null) continue;
                    UriListDataFlavor.copy(con, f);
                    if (!f.isFile() || f.length() <= 0L) continue;
                    files.add(f);
                    continue;
                }
                LogSupport.message(UriListDataFlavor.class, (String)"getTransferFiles", (String)("Ignoring " + type + " URL: " + url));
            }
            catch (IOException iox) {}
        }
        return files;
    }

    private static File createTempFile(URL url) throws IOException {
        String ext = null;
        try {
            ext = Platform.getSuffix((String)url.openConnection().getContentType());
        }
        catch (Throwable t) {
            ext = null;
        }
        if (ext == null) {
            ext = FileSysUtils.getExtensionString((String)url.getPath());
        }
        if (ext == null) {
            return null;
        }
        if (!DOWNLOAD_DIR.isDirectory()) {
            DOWNLOAD_DIR.mkdirs();
        }
        File f = File.createTempFile("eDrag_", "." + ext, DOWNLOAD_DIR);
        try {
            f.deleteOnExit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(URLConnection con, File f) throws IOException {
        block22: {
            InputStream is = null;
            FileOutputStream fos = null;
            try {
                is = con.getInputStream();
                fos = new FileOutputStream(f);
                byte[] buf = new byte[4096];
                long ioTime = System.currentTimeMillis();
                while (true) {
                    int n;
                    if ((n = is.read(buf)) < 0) {
                        break block22;
                    }
                    if (n > 0) {
                        fos.write(buf, 0, n);
                        ioTime = System.currentTimeMillis();
                        continue;
                    }
                    if (System.currentTimeMillis() - ioTime > 5000L) break;
                }
                LogSupport.message(UriListDataFlavor.class, (String)"copy", (String)("I/O stalled: " + con.getURL()));
            }
            catch (EOFException eofx) {
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Throwable ignored) {}
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable ignored) {}
                }
            }
        }
    }

    public Object setTransferFiles(List<File> list) {
        StringBuffer b = new StringBuffer();
        for (File f : list) {
            b.append(f.toURI());
            b.append("\r\n");
        }
        return b.toString();
    }
}

