/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import com.elluminate.gui.FontUtils;
import com.elluminate.platform.Platform;
import com.elluminate.util.ShortList;
import com.elluminate.util.SwingRunnerSupport;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.text.ParseException;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.AbstractSpinnerModel;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;

public class TimerSpinnerField
extends JSpinner {
    public static final short HH_MM_SS_FORMAT = 1;
    public static final short HH_MM_FORMAT = 2;
    public static final short MM_SS_FORMAT = 3;
    private static final short HOURS = 1;
    private static final short MINUTES = 2;
    private static final short SECONDS = 3;
    private static final short MAX_HOURS = 99;
    private static final short MAX_MINUTES = 59;
    private static final short MAX_SECONDS = 59;
    private static final Short MIN_HOURS_POSITION = ShortList.get((short)1);
    private static final Short MAX_HOURS_POSITION = ShortList.get((short)2);
    private static final Short MIN_MINUTES_POSITION = ShortList.get((short)3);
    private static final Short MAX_MINUTES_POSITION = ShortList.get((short)4);
    private static final Short MIN_SECONDS_POSITION = ShortList.get((short)5);
    private static final Short MAX_SECONDS_POSITION = ShortList.get((short)6);
    private static HashMap FORMAT_PATTERN_MAP = new HashMap();
    private static HashMap FORMAT_PARTS_MAP = new HashMap();
    private static HashMap HH_MM_SS_FORMAT_PARTS_MAP = new HashMap();
    private static HashMap HH_MM_FORMAT_PARTS_MAP = new HashMap();
    private static HashMap MM_SS_FORMAT_PARTS_MAP = new HashMap();
    private static HashMap MAX_STRING_VALUES = new HashMap();
    private static HashMap MIN_STRING_VALUES = new HashMap();
    private static HashMap MIN_FORMAT_FIELDS = new HashMap();
    private static HashMap INITIAL_EDITING_FIELD_FORMAT = new HashMap();
    private short inputFormat;
    private TimerSpinnerFieldEditor editor;
    public static final int SPINNER_EXTRA_WIDTH = 12;

    public Dimension getEditorSize() {
        return this.editor.getSize();
    }

    public TimerSpinnerField(short format) throws Exception {
        this.inputFormat = format;
        this.setModel(new TimerSpinnerFieldModel(format, 0, 0, 0));
        this.editor = new TimerSpinnerFieldEditor(this, format);
        this.setEditor(this.editor);
        this.setValue(0, 0, 0);
    }

    public TimerSpinnerField(Font font, short format, int fontSize, int fontStyle) throws Exception {
        this(format);
        Font fontEditor = FontUtils.setFontStyleAndSize(font, fontStyle, fontSize);
        Font fontRenderer = FontUtils.setFontStyleAndSize(this.getFont(), fontStyle, fontSize);
        ((TimerSpinnerFieldEditor)this.getEditor()).setFont(fontEditor);
        this.setFont(fontRenderer);
    }

    public void setDefaultButton(final JButton defaultButton) {
        KeyStroke enterStroke = KeyStroke.getKeyStroke(10, 0);
        AbstractAction defaultAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                defaultButton.doClick();
            }
        };
        this.getInputMap().put(enterStroke, defaultAction);
        this.getEditor().getInputMap().put(enterStroke, defaultAction);
    }

    public void setValue(long totalNumberOfSeconds) {
        int hr = 0;
        int min = 0;
        int sec = 0;
        long hourDivisor = 3600L;
        hr = (int)(totalNumberOfSeconds / hourDivisor);
        min = (int)((totalNumberOfSeconds %= hourDivisor) / 60L);
        sec = (int)(totalNumberOfSeconds % 60L);
        this.setValue(hr, min, sec);
    }

    @Override
    public void requestFocus() {
        ((TimerSpinnerFieldEditor)this.getEditor()).requestFocus();
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        ((TimerSpinnerFieldEditor)this.getEditor()).addMouseListener(listener);
        super.addMouseListener(listener);
    }

    @Override
    public void removeMouseListener(MouseListener listener) {
        ((TimerSpinnerFieldEditor)this.getEditor()).removeMouseListener(listener);
        super.removeMouseListener(listener);
    }

    public void addDocumentListener(DocumentListener listener) {
        ((TimerSpinnerFieldEditor)this.getEditor()).getDocument().addDocumentListener(listener);
    }

    public void removeDocumentListener(DocumentListener listener) {
        ((TimerSpinnerFieldEditor)this.getEditor()).getDocument().removeDocumentListener(listener);
    }

    public void setValue(int hours, int minutes, int seconds) {
        ((TimerSpinnerFieldModel)this.getModel()).setTime(hours, minutes, seconds);
    }

    public long getTotalSeconds() {
        return ((TimerSpinnerFieldModel)this.getModel()).getTotalSeconds();
    }

    public long getTotalSecondsFromText() {
        String value = ((TimerSpinnerFieldEditor)this.getEditor()).getText();
        int[] parts = TimerSpinnerField.parseValueForInput(value, this.inputFormat);
        if (parts.length < 3) {
            return 0L;
        }
        return TimerSpinnerField.getTotalSecondsFor(this.inputFormat, parts[0], parts[1], parts[2]);
    }

    private static int[] parseValueForInput(String value, short inputFormat) {
        int[] parts = new int[3];
        int hrs = 0;
        int min = 0;
        int sec = 0;
        StringTokenizer st = new StringTokenizer(value, ":", false);
        short minimumTokens = (Short)MIN_FORMAT_FIELDS.get(ShortList.get((short)inputFormat));
        if (st.countTokens() < minimumTokens) {
            return parts;
        }
        int[] tokens = new int[st.countTokens()];
        int index = 0;
        while (st.hasMoreTokens()) {
            try {
                String nextToken = st.nextToken().trim();
                tokens[index] = Integer.parseInt(nextToken);
            }
            catch (NumberFormatException e) {
                tokens[index] = 0;
            }
            ++index;
        }
        switch (inputFormat) {
            case 1: {
                hrs = tokens[0];
                min = tokens[1];
                sec = tokens[2];
                break;
            }
            case 2: {
                hrs = tokens[0];
                min = tokens[1];
                break;
            }
            case 3: {
                min = tokens[0];
                sec = tokens[1];
            }
        }
        if (sec < 0) {
            --min;
            sec = 59;
        } else if (sec / 60 > 0) {
            min += sec / 60;
            sec %= 60;
        }
        if (min < 0) {
            --hrs;
            min = 59;
        } else if (min / 60 > 0) {
            hrs += min / 60;
            min %= 60;
        }
        if (hrs < 0) {
            hrs = 99;
        } else if (hrs > 99) {
            hrs = 0;
        }
        switch (inputFormat) {
            case 2: {
                sec = 0;
                break;
            }
            case 3: {
                hrs = 0;
            }
        }
        parts[0] = hrs;
        parts[1] = min;
        parts[2] = sec;
        return parts;
    }

    private static long getTotalSecondsFor(short inputFormat, int hr, int min, int sec) {
        int includeHours = inputFormat == 2 || inputFormat == 1 ? 1 : 0;
        int includeMinutes = inputFormat == 2 || inputFormat == 1 || inputFormat == 3 ? 1 : 0;
        int includeSeconds = inputFormat == 1 || inputFormat == 3 ? 1 : 0;
        long convertedMinutes = min * 60;
        long convertedHours = hr * 60 * 60;
        return convertedHours * (long)includeHours + convertedMinutes * (long)includeMinutes + (long)(sec * includeSeconds);
    }

    static {
        FORMAT_PATTERN_MAP.put(ShortList.get((short)1), "##:##:##");
        FORMAT_PATTERN_MAP.put(ShortList.get((short)2), "##:##");
        FORMAT_PATTERN_MAP.put(ShortList.get((short)3), "##:##");
        INITIAL_EDITING_FIELD_FORMAT.put(ShortList.get((short)1), ShortList.get((short)1));
        INITIAL_EDITING_FIELD_FORMAT.put(ShortList.get((short)2), ShortList.get((short)1));
        INITIAL_EDITING_FIELD_FORMAT.put(ShortList.get((short)3), ShortList.get((short)2));
        HH_MM_SS_FORMAT_PARTS_MAP.put(MIN_HOURS_POSITION, ShortList.get((short)0));
        HH_MM_SS_FORMAT_PARTS_MAP.put(MAX_HOURS_POSITION, ShortList.get((short)2));
        HH_MM_SS_FORMAT_PARTS_MAP.put(MIN_MINUTES_POSITION, ShortList.get((short)3));
        HH_MM_SS_FORMAT_PARTS_MAP.put(MAX_MINUTES_POSITION, ShortList.get((short)5));
        HH_MM_SS_FORMAT_PARTS_MAP.put(MIN_SECONDS_POSITION, ShortList.get((short)6));
        HH_MM_SS_FORMAT_PARTS_MAP.put(MAX_SECONDS_POSITION, ShortList.get((short)8));
        HH_MM_FORMAT_PARTS_MAP.put(MIN_HOURS_POSITION, ShortList.get((short)0));
        HH_MM_FORMAT_PARTS_MAP.put(MAX_HOURS_POSITION, ShortList.get((short)2));
        HH_MM_FORMAT_PARTS_MAP.put(MIN_MINUTES_POSITION, ShortList.get((short)3));
        HH_MM_FORMAT_PARTS_MAP.put(MAX_MINUTES_POSITION, ShortList.get((short)5));
        MM_SS_FORMAT_PARTS_MAP.put(MIN_MINUTES_POSITION, ShortList.get((short)0));
        MM_SS_FORMAT_PARTS_MAP.put(MAX_MINUTES_POSITION, ShortList.get((short)2));
        MM_SS_FORMAT_PARTS_MAP.put(MIN_SECONDS_POSITION, ShortList.get((short)3));
        MM_SS_FORMAT_PARTS_MAP.put(MAX_SECONDS_POSITION, ShortList.get((short)5));
        FORMAT_PARTS_MAP.put(ShortList.get((short)1), HH_MM_SS_FORMAT_PARTS_MAP);
        FORMAT_PARTS_MAP.put(ShortList.get((short)2), HH_MM_FORMAT_PARTS_MAP);
        FORMAT_PARTS_MAP.put(ShortList.get((short)3), MM_SS_FORMAT_PARTS_MAP);
        MIN_STRING_VALUES.put(ShortList.get((short)1), "00:00:00");
        MIN_STRING_VALUES.put(ShortList.get((short)2), "00:00");
        MIN_STRING_VALUES.put(ShortList.get((short)3), "00:00");
        MIN_FORMAT_FIELDS.put(ShortList.get((short)1), ShortList.get((short)3));
        MIN_FORMAT_FIELDS.put(ShortList.get((short)2), ShortList.get((short)2));
        MIN_FORMAT_FIELDS.put(ShortList.get((short)3), ShortList.get((short)2));
        MAX_STRING_VALUES.put(ShortList.get((short)1), "99:59:59");
        MAX_STRING_VALUES.put(ShortList.get((short)2), "99:59");
        MAX_STRING_VALUES.put(ShortList.get((short)3), "59:59");
    }

    private class TimerSpinnerFieldEditor
    extends JFormattedTextField
    implements ChangeListener,
    CaretListener {
        private short timerFormatPattern = 1;
        private JSpinner spinner;
        private CaretListener caretListener = this;
        private ChangeListener changeListener = this;

        public TimerSpinnerFieldEditor(JSpinner spinner) throws ParseException {
            this(spinner, 1);
        }

        public TimerSpinnerFieldEditor(final JSpinner spinner, short timerFormat) throws ParseException {
            if (!(spinner.getModel() instanceof TimerSpinnerFieldModel)) {
                throw new IllegalArgumentException("model not a TimerSpinnerFieldModel");
            }
            if (timerFormat != 1 && timerFormat != 2 && timerFormat != 3) {
                throw new IllegalArgumentException("Invalid Timer Format");
            }
            this.timerFormatPattern = timerFormat;
            this.spinner = spinner;
            TimerSpinnerFieldModel model = (TimerSpinnerFieldModel)spinner.getModel();
            this.setColumns(Math.max(model.getMaximum().length(), model.getMinimum().length()));
            MaskFormatter formatter = new MaskFormatter((String)FORMAT_PATTERN_MAP.get(ShortList.get((short)timerFormat)));
            formatter.setValidCharacters("0123456789");
            formatter.setPlaceholder("0");
            DefaultFormatterFactory factory = new DefaultFormatterFactory(formatter);
            this.setFormatterFactory(factory);
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    try {
                        TimerSpinnerFieldModel model = (TimerSpinnerFieldModel)spinner.getModel();
                        model.setValue(TimerSpinnerFieldEditor.this.getText());
                        TimerSpinnerFieldEditor.this.commitEdit();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            spinner.addChangeListener(this.changeListener);
            this.addCaretListener(this.caretListener);
            KeyAdapter kl = new KeyAdapter(){
                final boolean HANDLE_UP_DOWN = Platform.getOS() == 202;

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        try {
                            TimerSpinnerFieldModel model = (TimerSpinnerFieldModel)spinner.getModel();
                            model.setValue(TimerSpinnerFieldEditor.this.getText());
                            TimerSpinnerFieldEditor.this.commitEdit();
                        }
                        catch (Exception exception) {}
                    } else if (this.HANDLE_UP_DOWN && e.getKeyCode() == 38) {
                        spinner.setValue(spinner.getNextValue());
                        e.consume();
                    } else if (this.HANDLE_UP_DOWN && e.getKeyCode() == 40) {
                        spinner.setValue(spinner.getPreviousValue());
                        e.consume();
                    }
                }
            };
            this.addKeyListener(kl);
        }

        private boolean checkFound(Object min, Object max, int value) {
            if (!(min instanceof Short) || !(max instanceof Short)) {
                return false;
            }
            return ((Short)min).intValue() <= value && ((Short)max).intValue() >= value;
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            Object max;
            int caretPosition = this.getCaretPosition();
            HashMap minMaxPositionMap = (HashMap)FORMAT_PARTS_MAP.get(ShortList.get((short)this.timerFormatPattern));
            int editingField = 1;
            Object min = minMaxPositionMap.get(MIN_HOURS_POSITION);
            if (!this.checkFound(min, max = minMaxPositionMap.get(MAX_HOURS_POSITION), caretPosition)) {
                editingField = 2;
                min = minMaxPositionMap.get(MIN_MINUTES_POSITION);
                if (!this.checkFound(min, max = minMaxPositionMap.get(MAX_MINUTES_POSITION), caretPosition)) {
                    editingField = 3;
                    min = minMaxPositionMap.get(MIN_SECONDS_POSITION);
                    if (!this.checkFound(min, max = minMaxPositionMap.get(MAX_SECONDS_POSITION), caretPosition)) {
                        editingField = -1;
                    }
                }
            }
            if (editingField == -1) {
                return;
            }
            final TimerSpinnerFieldModel model = (TimerSpinnerFieldModel)TimerSpinnerField.this.getModel();
            final int minSelectionPos = ((Short)min).intValue();
            final int maxSelectionPos = ((Short)max).intValue();
            if (model.getEditingField() != editingField) {
                model.setEditingField((short)editingField);
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TimerSpinnerFieldEditor.this.removeCaretListener(TimerSpinnerFieldEditor.this.caretListener);
                        try {
                            model.setValue(TimerSpinnerFieldEditor.this.getText());
                            TimerSpinnerFieldEditor.this.commitEdit();
                            TimerSpinnerFieldEditor.this.repaint();
                            TimerSpinnerFieldEditor.this.setSelectionStart(minSelectionPos);
                            TimerSpinnerFieldEditor.this.setSelectionEnd(maxSelectionPos);
                            TimerSpinnerFieldEditor.this.addCaretListener(TimerSpinnerFieldEditor.this.caretListener);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            final int currentCaretPosition = this.getCaretPosition();
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    TimerSpinnerFieldEditor.this.removeCaretListener(TimerSpinnerFieldEditor.this.caretListener);
                    TimerSpinnerFieldModel model = (TimerSpinnerFieldModel)TimerSpinnerField.this.getModel();
                    TimerSpinnerFieldEditor.this.setText(model.getValue().toString());
                    TimerSpinnerFieldEditor.this.setCaretPosition(currentCaretPosition);
                    TimerSpinnerFieldEditor.this.repaint();
                    HashMap minMaxPositionMap = (HashMap)FORMAT_PARTS_MAP.get(ShortList.get((short)TimerSpinnerFieldEditor.this.timerFormatPattern));
                    int min = 0;
                    int max = 0;
                    switch (model.getEditingField()) {
                        case 1: {
                            min = ((Short)minMaxPositionMap.get(MIN_HOURS_POSITION)).shortValue();
                            max = ((Short)minMaxPositionMap.get(MAX_HOURS_POSITION)).shortValue();
                            break;
                        }
                        case 2: {
                            min = ((Short)minMaxPositionMap.get(MIN_MINUTES_POSITION)).shortValue();
                            max = ((Short)minMaxPositionMap.get(MAX_MINUTES_POSITION)).shortValue();
                            break;
                        }
                        case 3: {
                            min = ((Short)minMaxPositionMap.get(MIN_SECONDS_POSITION)).shortValue();
                            max = ((Short)minMaxPositionMap.get(MAX_SECONDS_POSITION)).shortValue();
                        }
                    }
                    TimerSpinnerFieldEditor.this.setSelectionStart(min);
                    TimerSpinnerFieldEditor.this.setSelectionEnd(max);
                    TimerSpinnerFieldEditor.this.addCaretListener(TimerSpinnerFieldEditor.this.caretListener);
                }
            });
        }
    }

    private class TimerSpinnerFieldModel
    extends AbstractSpinnerModel {
        private short format = 1;
        private int hours = 0;
        private int minutes = 0;
        private int seconds = 0;
        private short editingField = 1;

        private boolean timeFieldOK(short calendarField) {
            switch (calendarField) {
                case 1: 
                case 2: 
                case 3: {
                    return true;
                }
            }
            return false;
        }

        public TimerSpinnerFieldModel(short format, int startHours, int startMinutes, int startSeconds) {
            if (format != 1 && format != 2 && format != 3) {
                throw new IllegalArgumentException("invalid format");
            }
            this.format = format;
            this.hours = startHours;
            this.minutes = startMinutes;
            this.seconds = startSeconds;
            this.editingField = (Short)INITIAL_EDITING_FIELD_FORMAT.get(ShortList.get((short)format));
        }

        public TimerSpinnerFieldModel() {
            this(1, 0, 0, 0);
        }

        public void setTime(int hours, int minutes, int seconds) {
            this.parseValue(this.formatValue(hours, minutes, seconds));
            this.fireStateChanged();
        }

        public short getEditingField() {
            return this.editingField;
        }

        public void setEditingField(short editingField) {
            if (!this.timeFieldOK(editingField)) {
                throw new IllegalArgumentException("invalid editingField");
            }
            if (editingField != this.editingField) {
                this.editingField = editingField;
            }
        }

        public String getMaximum() {
            return (String)MAX_STRING_VALUES.get(ShortList.get((short)this.format));
        }

        public String getMinimum() {
            return (String)MIN_STRING_VALUES.get(ShortList.get((short)this.format));
        }

        public long getTotalSeconds() {
            return TimerSpinnerField.getTotalSecondsFor(this.format, this.hours, this.minutes, this.seconds);
        }

        private String prependZero(String orig, int characters) {
            while (orig.length() < characters) {
                orig = "0" + orig;
            }
            return orig;
        }

        private String formatValue(int hr, int min, int sec) {
            switch (this.format) {
                case 1: {
                    return this.prependZero("" + hr, 2) + ":" + this.prependZero("" + min, 2) + ":" + this.prependZero("" + sec, 2);
                }
                case 2: {
                    return this.prependZero("" + hr, 2) + ":" + this.prependZero("" + min, 2);
                }
                case 3: {
                    return this.prependZero("" + min, 2) + ":" + this.prependZero("" + sec, 2);
                }
            }
            return "00:00:00";
        }

        @Override
        public Object getNextValue() {
            return this.getPreviousOrNext(true);
        }

        @Override
        public Object getPreviousValue() {
            return this.getPreviousOrNext(false);
        }

        private String getPreviousOrNext(boolean getNext) {
            int hrs = this.hours;
            int min = this.minutes;
            int sec = this.seconds;
            int addValue = getNext ? 1 : -1;
            switch (this.editingField) {
                case 1: {
                    hrs += addValue;
                    break;
                }
                case 2: {
                    min += addValue;
                    break;
                }
                case 3: {
                    sec += addValue;
                }
            }
            return this.formatValue(hrs, min, sec);
        }

        @Override
        public Object getValue() {
            return this.formatValue(this.hours, this.minutes, this.seconds);
        }

        @Override
        public void setValue(Object value) {
            if (value == null || !(value instanceof String)) {
                throw new IllegalArgumentException("invalid clock value: " + value);
            }
            if (this.parseValue((String)value)) {
                this.fireStateChanged();
            }
        }

        private boolean parseValue(String value) {
            int[] parts = TimerSpinnerField.parseValueForInput(value, this.format);
            if (parts.length < 3) {
                return false;
            }
            int hrs = parts[0];
            int min = parts[1];
            int sec = parts[2];
            if (hrs != this.hours || min != this.minutes || sec != this.seconds) {
                this.hours = hrs;
                this.minutes = min;
                this.seconds = sec;
                return true;
            }
            return false;
        }
    }
}

