/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import com.elluminate.gui.AccessibilityUtils;
import com.elluminate.gui.component.ButtonMetrics;
import com.elluminate.gui.component.RollOverBehavior;
import java.awt.Dimension;
import javax.accessibility.Accessible;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;

public class RollOverButton
extends JButton {
    private ButtonMetrics btnMetrics = null;

    public RollOverButton() {
        this(null, null, null);
    }

    public RollOverButton(ButtonMetrics metrics) {
        this(null, null, metrics);
    }

    public RollOverButton(Action action) {
        this(action, null);
    }

    public RollOverButton(Action action, ButtonMetrics metrics) {
        super(action);
        this.btnMetrics = metrics;
        RollOverBehavior.install(this);
        this.setAccessibleInfo();
    }

    public RollOverButton(Icon icon) {
        this(null, icon, null);
    }

    public RollOverButton(Icon icon, ButtonMetrics metrics) {
        this(null, icon, metrics);
    }

    public RollOverButton(String text) {
        this(text, null, null);
    }

    public RollOverButton(String text, ButtonMetrics metrics) {
        this(text, null, metrics);
    }

    public RollOverButton(String text, Icon icon) {
        this(text, icon, null);
    }

    public RollOverButton(String text, Icon icon, ButtonMetrics metrics) {
        super(text, icon);
        this.btnMetrics = metrics;
        RollOverBehavior.install(this);
        this.setAccessibleInfo();
    }

    private void setAccessibleInfo() {
        if (this.getIcon() instanceof Accessible) {
            AccessibilityUtils.copyAccessibleInfo((Accessible)((Object)this.getIcon()), this);
        }
    }

    @Override
    public void setIcon(Icon icon) {
        super.setIcon(icon);
        this.setAccessibleInfo();
    }

    public ButtonMetrics getButtonMetrics() {
        return this.btnMetrics;
    }

    public void setButtonMetrics(ButtonMetrics bm) {
        this.btnMetrics = bm;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet() || this.btnMetrics == null) {
            return super.getPreferredSize();
        }
        return this.btnMetrics.computePreferredSize(this);
    }
}

