/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import com.elluminate.gui.GuiUtils;
import com.elluminate.gui.component.ColorIcon;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PopupColorPicker
extends JButton {
    public static final String CHOSEN_COLOR_PROP = "QuickColorPicker.chosenColor";
    private static final int BORDER_WIDTH = 2;
    private ColorIcon icon;
    private Color defaultColor = null;
    private Color rolloverColor = Color.GRAY;
    private Color pressedColor = Color.DARK_GRAY;
    private Popup popup = null;
    private PopupPanel popupPanel = null;
    private final AWTEventListener popupCancelListener;

    public PopupColorPicker(Dimension dim, Color c) {
        this.icon = new ColorIcon(c, dim.width - 4, dim.height - 4);
        this.setIcon(this.icon);
        this.setDisabledIcon(this.icon);
        this.setBorder(new PickerBorder());
        this.setContentAreaFilled(false);
        this.setBorderPainted(true);
        this.setRolloverEnabled(true);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (!PopupColorPicker.this.isPopupShowing()) {
                    PopupColorPicker.this.showPopup();
                } else {
                    PopupColorPicker.this.hidePopup();
                }
            }
        });
        this.popupCancelListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent ev) {
                if (ev.getID() == 501) {
                    if (!(ev instanceof MouseEvent)) {
                        return;
                    }
                    MouseEvent me = (MouseEvent)ev;
                    Component cmp = me.getComponent();
                    if (cmp == PopupColorPicker.this) {
                        return;
                    }
                    if (PopupColorPicker.this.popupPanel.isAncestorOf(cmp)) {
                        return;
                    }
                    if (SwingUtilities.isDescendingFrom(PopupColorPicker.this.popupPanel, cmp)) {
                        Point pt = SwingUtilities.convertPoint(cmp, me.getX(), me.getY(), PopupColorPicker.this.popupPanel);
                        if (PopupColorPicker.this.popupPanel.contains(pt)) {
                            return;
                        }
                    }
                    PopupColorPicker.this.hidePopup();
                    if (UIManager.getBoolean("PopupMenu.consumeEventOnClose")) {
                        me.consume();
                    }
                }
            }
        };
    }

    public void setColor(Color c) {
        Color oldColor = this.icon.getColor();
        if (oldColor == c) {
            return;
        }
        if (oldColor != null && oldColor.equals(c)) {
            return;
        }
        this.icon.setColor(c);
        this.repaint();
        this.firePropertyChange(CHOSEN_COLOR_PROP, oldColor, c);
    }

    public Color getColor() {
        return this.icon.getColor();
    }

    private boolean isPopupShowing() {
        return this.popup != null;
    }

    private void showPopup() {
        if (this.isPopupShowing()) {
            return;
        }
        PopupPanel content = this.getPopupPanel(this.getColor());
        Toolkit tk = Toolkit.getDefaultToolkit();
        tk.addAWTEventListener(this.popupCancelListener, 501L);
        Dimension dim = content.getPreferredSize();
        Point loc = this.getLocationOnScreen();
        Insets scrnInsets = new Insets(0, 0, 0, 0);
        Rectangle scrnBounds = GuiUtils.getDeviceBounds(loc.x, loc.y, this, scrnInsets);
        scrnBounds.x += scrnInsets.left;
        scrnBounds.y += scrnInsets.top;
        scrnBounds.width -= scrnInsets.left + scrnInsets.right;
        scrnBounds.height -= scrnInsets.top + scrnInsets.bottom;
        loc.y += this.getHeight();
        if (loc.x + dim.width > scrnBounds.x + scrnBounds.width) {
            loc.x = scrnBounds.x + scrnBounds.width - dim.width - 1;
        }
        if (loc.x < scrnBounds.x) {
            loc.x = scrnBounds.x + 1;
        }
        if (loc.y + dim.height > scrnBounds.y + scrnBounds.height) {
            loc.y -= this.getHeight() + dim.height;
        }
        if (loc.y < scrnBounds.y) {
            loc.y = scrnBounds.y + 1;
        }
        PopupFactory f = PopupFactory.getSharedInstance();
        this.popup = f.getPopup(this, content, loc.x, loc.y);
        this.popup.show();
    }

    private void hidePopup() {
        Popup p = this.popup;
        this.popup = null;
        if (p != null) {
            p.hide();
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        tk.removeAWTEventListener(this.popupCancelListener);
    }

    private PopupPanel getPopupPanel(Color col) {
        if (this.popupPanel == null) {
            this.popupPanel = new PopupPanel(col);
        } else {
            this.popupPanel.setColor(col);
        }
        return this.popupPanel;
    }

    private static class PickerBorder
    implements Border {
        private PickerBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(2, 2, 2, 2);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component cmp, Graphics g, int x, int y, int w, int h) {
            PopupColorPicker picker = (PopupColorPicker)cmp;
            ButtonModel model = picker.getModel();
            Color c = null;
            c = !model.isEnabled() ? Color.GRAY : (model.isArmed() ? picker.pressedColor : (model.isRollover() ? picker.rolloverColor : picker.defaultColor));
            if (c != null) {
                g.setColor(c);
                g.fillRect(x, y, w, 2);
                g.fillRect(x, y + h - 2 - 1, w, 2);
                g.fillRect(x, y + 2, 2, h - 4);
                g.fillRect(x + w - 2, y + 2, 2, h - 4);
            }
        }
    }

    private class PopupPanel
    extends JPanel {
        private JColorChooser chooser;

        PopupPanel(Color col) {
            super(new BorderLayout());
            this.setOpaque(true);
            this.chooser = new JColorChooser();
            if (col != null) {
                this.chooser.setColor(col);
            }
            this.add((Component)this.chooser, "Center");
            this.chooser.setPreviewPanel(new JPanel());
            this.chooser.getSelectionModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ev) {
                    ColorSelectionModel cm = PopupPanel.this.chooser.getSelectionModel();
                    Color c = cm.getSelectedColor();
                    PopupColorPicker.this.setColor(c);
                }
            });
        }

        public void setColor(Color col) {
            if (col != null) {
                this.chooser.setColor(col);
            }
        }
    }
}

