/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;

public class NullableActionButton
extends JButton {
    private Icon origIcon;
    private Icon grayIcon;
    private List<ActionListener> listeners;
    private boolean actionsEnabled = true;
    private boolean inTransition = false;

    public NullableActionButton() {
    }

    public NullableActionButton(Icon icon) {
        super(icon);
    }

    public NullableActionButton(String text) {
        super(text);
    }

    public NullableActionButton(String text, Icon icon) {
        super(text, icon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActionEnabled(boolean enabled) {
        if (this.actionsEnabled == enabled) {
            return;
        }
        try {
            this.inTransition = true;
            this.actionsEnabled = enabled;
            if (enabled) {
                this.enableActions();
                this.restoreIcon();
            } else {
                this.disableActions();
                this.greyOutIcon();
            }
        }
        finally {
            this.inTransition = false;
        }
    }

    private void enableActions() {
        ArrayList<ActionListener> working = new ArrayList<ActionListener>(this.listeners);
        if (working != null) {
            for (ActionListener listener : working) {
                this.addActionListener(listener);
            }
        }
        this.listeners = null;
    }

    private void disableActions() {
        this.listeners = new ArrayList<EventListener>(Arrays.asList(this.getListeners(ActionListener.class)));
        ArrayList<ActionListener> working = new ArrayList<ActionListener>(this.listeners);
        if (working != null) {
            for (ActionListener listener : working) {
                this.removeActionListener(listener);
            }
        }
    }

    private void greyOutIcon() {
        if (this.grayIcon == null) {
            this.grayIcon = this.getDisabledIcon();
        }
        if (this.grayIcon != null) {
            this.setIcon(this.grayIcon);
        }
        this.repaint();
    }

    private void restoreIcon() {
        if (this.origIcon != null) {
            this.setIcon(this.origIcon);
        }
        this.repaint();
    }

    @Override
    public void setIcon(Icon defaultIcon) {
        if (this.origIcon != null) {
            if (this.grayIcon != null) {
                if (this.grayIcon != defaultIcon && this.origIcon != defaultIcon) {
                    this.grayIcon = null;
                    this.origIcon = defaultIcon;
                }
            } else if (this.origIcon != defaultIcon) {
                this.origIcon = defaultIcon;
            }
        } else {
            this.origIcon = defaultIcon;
        }
        super.setIcon(defaultIcon);
    }

    @Override
    public void addActionListener(ActionListener l) {
        if (this.actionsEnabled) {
            super.addActionListener(l);
        } else if (this.listeners != null) {
            this.listeners.add(l);
        }
    }

    @Override
    public void removeActionListener(ActionListener l) {
        if (this.actionsEnabled || this.inTransition) {
            super.removeActionListener(l);
        } else if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }
}

