/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import com.elluminate.gui.FontUtils;
import com.elluminate.gui.component.MultilineLabel;
import com.elluminate.gui.component.ProgressWheelUI;
import com.elluminate.gui.component.RollOverButton;
import com.elluminate.gui.component.StringsProperties;
import com.elluminate.gui.event.ModalDialogAsyncEvent;
import com.elluminate.gui.event.ModalDialogAsyncListener;
import com.elluminate.gui.event.ModalDialogAsyncRequest;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.event.EventListenerList;

public class NotificationWindow
extends JWindow {
    private static final DateFormat timeFormat = DateFormat.getTimeInstance(3);
    private static final Font plainFont = FontUtils.setFontStyle(null, 0);
    private static final Font boldFont = FontUtils.setFontStyle(null, 1);
    private JLabel icon;
    private MultilineLabel messageField;
    private MultilineLabel explanationField;
    private JLabel timeLabel;
    private JProgressBar timeoutWheel;
    private JLabel countLabel;
    private JButton dismissAllButton;
    private JButton dismissButton;
    private EventListenerList listeners = new EventListenerList();
    private Point anchor;
    private I18n i18n = I18n.create((Object)this);
    private final ArrayList<Notification> notifications = new ArrayList();
    private NotificationTimer timer = new NotificationTimer(new NotificationTimerTask());

    public NotificationWindow() {
        this.setAlwaysOnTop(true);
        JPanel c = (JPanel)this.getContentPane();
        c.setLayout(new BorderLayout());
        if (Platform.getOS() != 202) {
            c.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
        }
        JPanel p = new JPanel(new GridBagLayout());
        p.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        c.add((Component)p, "Center");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 3;
        gbc.anchor = 11;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets.top = 0;
        gbc.insets.left = 0;
        this.icon = new JLabel();
        p.add((Component)this.icon, gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets.top = 0;
        gbc.insets.left = 8;
        this.messageField = new MultilineLabel("");
        p.add((Component)this.messageField, gbc);
        ++gbc.gridy;
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets.top = 8;
        gbc.insets.left = 8;
        this.explanationField = new MultilineLabel("");
        p.add((Component)this.explanationField, gbc);
        ++gbc.gridy;
        gbc.gridx = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets.top = 8;
        gbc.insets.left = 8;
        this.timeLabel = new JLabel();
        this.timeLabel.setFont(this.timeLabel.getFont().deriveFont(9.0f));
        if (Platform.getLAF() == 503) {
            this.timeLabel.setForeground(SystemColor.inactiveCaption);
        } else {
            this.timeLabel.setForeground(Color.GRAY);
        }
        p.add((Component)this.timeLabel, gbc);
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 13;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets.top = 8;
        gbc.insets.left = 8;
        this.timeoutWheel = new JProgressBar(){
            private JProgressBar.AccessibleJProgressBar accessibleContext;

            @Override
            public void updateUI() {
                super.updateUI();
                this.setUI(new ProgressWheelUI());
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                if (this.accessibleContext == null) {
                    this.accessibleContext = new JProgressBar.AccessibleJProgressBar(){

                        @Override
                        public Number getCurrentAccessibleValue() {
                            return null;
                        }
                    };
                }
                return this.accessibleContext;
            }
        };
        if (Platform.getLAF() == 503) {
            this.timeoutWheel.setForeground(SystemColor.inactiveCaption);
        } else {
            this.timeoutWheel.setForeground(Color.LIGHT_GRAY);
        }
        p.add((Component)this.timeoutWheel, gbc);
        ShadowedPanel sp = new ShadowedPanel();
        sp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY), BorderFactory.createEmptyBorder(4, 8, 4, 4)));
        c.add((Component)sp, "South");
        gbc = new GridBagConstraints();
        gbc.insets.left = 0;
        this.countLabel = new JLabel();
        sp.add((Component)this.countLabel, gbc);
        gbc.insets.left = 0;
        sp.add(Box.createHorizontalGlue(), gbc);
        gbc.insets.left = 0;
        this.dismissAllButton = new RollOverButton(this.i18n.getString((PropertiesEnum)StringsProperties.NOTIFICATIONWINDOW_DISMISSALL));
        sp.add((Component)this.dismissAllButton, gbc);
        gbc.insets.left = 6;
        this.dismissButton = new RollOverButton(this.i18n.getString((PropertiesEnum)StringsProperties.NOTIFICATIONWINDOW_DISMISS));
        sp.add((Component)this.dismissButton, gbc);
        this.countLabel.setFont(this.dismissButton.getFont());
        Dimension ps = sp.getPreferredSize();
        sp.setPreferredSize(new Dimension(ps.width + 40, ps.height));
        this.messageField.setText("lorem\nipsum");
        this.messageField.setSize(250, Integer.MAX_VALUE);
        this.explanationField.setVisible(false);
        this.countLabel.setText("2 notifications");
        this.timeLabel.setText("0:30");
        this.pack();
        this.dismissButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotificationWindow.this.endNotification();
            }
        });
        this.dismissAllButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList arrayList = NotificationWindow.this.notifications;
                synchronized (arrayList) {
                    for (int i = NotificationWindow.this.notifications.size() - 1; i > 0; --i) {
                        NotificationWindow.this.notifications.remove(i);
                    }
                    NotificationWindow.this.endNotification();
                }
            }
        });
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                NotificationWindow.this.anchor = e.getPoint();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                NotificationWindow.this.endNotification();
            }
        };
        MouseMotionAdapter mml = new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Point pt = e.getPoint();
                Point pos = NotificationWindow.this.getLocation();
                NotificationWindow.this.setLocation(pt.x - ((NotificationWindow)NotificationWindow.this).anchor.x + pos.x, pt.y - ((NotificationWindow)NotificationWindow.this).anchor.y + pos.y);
            }
        };
        c.addMouseListener(ml);
        c.addMouseMotionListener(mml);
        sp.addMouseListener(ml);
        sp.addMouseMotionListener(mml);
        this.icon.addMouseListener(ml);
        this.icon.addMouseMotionListener(mml);
        this.messageField.addMouseListener(ml);
        this.messageField.addMouseMotionListener(mml);
        this.explanationField.addMouseListener(ml);
        this.explanationField.addMouseMotionListener(mml);
        this.timeLabel.addMouseListener(ml);
        this.timeLabel.addMouseMotionListener(mml);
    }

    public void place() {
        GraphicsDevice gd;
        Rectangle windowBounds = this.getBounds();
        int area = 0;
        GraphicsConfiguration screenConfig = null;
        Rectangle screenBounds = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gds = ge.getScreenDevices();
        for (int i = 0; i < gds.length; ++i) {
            GraphicsDevice gd2 = gds[i];
            GraphicsConfiguration gc = gd2.getDefaultConfiguration();
            Rectangle gb = gc.getBounds();
            Rectangle xb = gb.intersection(windowBounds);
            int a = xb.width * xb.height;
            if (screenConfig != null && a <= area) continue;
            area = a;
            screenConfig = gc;
            screenBounds = gb;
        }
        if ((screenConfig == null || screenBounds == null) && (gd = ge.getDefaultScreenDevice()) != null) {
            screenConfig = gd.getDefaultConfiguration();
            screenBounds = screenConfig.getBounds();
        }
        if (screenConfig != null && screenBounds != null) {
            Insets ins = Toolkit.getDefaultToolkit().getScreenInsets(screenConfig);
            screenBounds = new Rectangle(screenBounds.x + ins.left, screenBounds.y + ins.top, screenBounds.width - ins.left - ins.right, screenBounds.height - ins.top - ins.bottom);
            if (windowBounds.x + windowBounds.width > screenBounds.x + screenBounds.width) {
                windowBounds.x = screenBounds.x + screenBounds.width - windowBounds.width;
            }
            if (windowBounds.y + windowBounds.height > screenBounds.y + screenBounds.height) {
                windowBounds.y = screenBounds.y + screenBounds.height - windowBounds.height;
            }
            if (windowBounds.x < screenBounds.x) {
                windowBounds.x = screenBounds.x;
            }
            if (windowBounds.y < screenBounds.y) {
                windowBounds.y = screenBounds.y;
            }
            this.setBounds(windowBounds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModalDialogAsyncRequest queueNotification(String path, Icon icon, String message, String explanation, int timeout, long when) {
        ArrayList<Notification> arrayList = this.notifications;
        synchronized (arrayList) {
            Notification notif = new Notification(path, icon, message, explanation, timeout, when);
            this.notifications.add(notif);
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    NotificationWindow.this.updateNotificationCount();
                }
            });
            if (!this.isVisible()) {
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        NotificationWindow.this.showNextNotification();
                    }
                });
            }
            return notif;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(String path) {
        ArrayList<Notification> arrayList = this.notifications;
        synchronized (arrayList) {
            LinkedList<Notification> remove = null;
            for (Notification n : this.notifications) {
                if (!n.getPath().equals(path)) continue;
                if (remove == null) {
                    remove = new LinkedList<Notification>();
                }
                remove.addFirst(n);
            }
            if (remove != null) {
                for (Notification n : remove) {
                    n.cancel();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endNotification() {
        ArrayList<Notification> arrayList = this.notifications;
        synchronized (arrayList) {
            if (!this.timer.isScheduled()) {
                return;
            }
            this.timer.cancel();
            if (this.notifications.size() > 0) {
                Notification notif = this.notifications.remove(0);
                this.fireAsyncRequestEvent(notif, ModalDialogAsyncEvent.EventType.DISMISSED);
            }
            this.updateNotificationCount();
            if (this.notifications.size() > 0) {
                this.showNextNotification();
            } else {
                this.setVisible(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showNextNotification() {
        ArrayList<Notification> arrayList = this.notifications;
        synchronized (arrayList) {
            Notification notif = this.notifications.get(0);
            int timeout = notif.getTimeout();
            String expl = notif.getExplanation();
            if (expl != null && expl.length() != 0) {
                this.messageField.setFont(boldFont);
                this.explanationField.setVisible(true);
            } else {
                this.messageField.setFont(plainFont);
                this.explanationField.setVisible(false);
            }
            this.timeoutWheel.setVisible(timeout > 0);
            this.icon.setIcon(notif.getIcon());
            this.messageField.setText(notif.getMessage());
            this.explanationField.setText(expl);
            Date time = notif.getTime();
            String timeText = time == null ? "" : timeFormat.format(time);
            this.timeLabel.setText(timeText);
            this.timeoutWheel.setValue(0);
            this.timeoutWheel.setMaximum(timeout);
            this.messageField.setSize(250, Integer.MAX_VALUE);
            this.explanationField.setSize(250, Integer.MAX_VALUE);
            this.pack();
            this.place();
            this.setVisible(true);
            this.repaint();
            if (timeout > 0) {
                this.timer.scheduleEvery(1000L, timeout * 1000);
            }
            this.fireAsyncRequestEvent(notif, ModalDialogAsyncEvent.EventType.SHOWN);
        }
    }

    private void updateNotificationCount() {
        int count = this.notifications.size();
        if (count > 1) {
            this.dismissAllButton.setVisible(true);
            this.countLabel.setText(this.i18n.getString((PropertiesEnum)StringsProperties.NOTIFICATIONWINDOW_NOTIFICATIONCOUNT, new Object[]{String.valueOf(count)}));
        } else {
            this.dismissAllButton.setVisible(false);
            this.countLabel.setText(null);
        }
    }

    private void fireAsyncRequestEvent(ModalDialogAsyncRequest notification, ModalDialogAsyncEvent.EventType type) {
        ModalDialogAsyncEvent e = new ModalDialogAsyncEvent(notification, type);
        Object[] ls = this.listeners.getListenerList();
        block4: for (int i = ls.length - 2; i >= 0; i -= 2) {
            if (ls[i] != ModalDialogAsyncListener.class) continue;
            ModalDialogAsyncListener l = (ModalDialogAsyncListener)ls[i + 1];
            switch (type) {
                case SHOWN: {
                    l.dialogShown(e);
                    continue block4;
                }
                case DISMISSED: {
                    l.dialogDismissed(e);
                }
            }
        }
    }

    private class Notification
    implements ModalDialogAsyncRequest {
        private String path;
        private Date time;
        private Icon icon;
        private String message;
        private String explanation;
        private int timeout;

        public Notification(String path, Icon icon, String message, String explanation, int timeout, long when) {
            this.time = when > 0L ? new Date(when) : null;
            this.icon = icon;
            this.message = message;
            this.explanation = explanation;
            this.timeout = timeout;
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public Date getTime() {
            return this.time;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public String getMessage() {
            return this.message;
        }

        public String getExplanation() {
            return this.explanation;
        }

        public int getTimeout() {
            return this.timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            ArrayList arrayList = NotificationWindow.this.notifications;
            synchronized (arrayList) {
                if (this.isShowing()) {
                    NotificationWindow.this.endNotification();
                } else {
                    NotificationWindow.this.notifications.remove(this);
                    NotificationWindow.this.updateNotificationCount();
                }
            }
        }

        @Override
        public boolean isCompleted() {
            return !NotificationWindow.this.notifications.contains(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isShowing() {
            ArrayList arrayList = NotificationWindow.this.notifications;
            synchronized (arrayList) {
                return !NotificationWindow.this.notifications.isEmpty() && NotificationWindow.this.notifications.get(0) == this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isWaiting() {
            ArrayList arrayList = NotificationWindow.this.notifications;
            synchronized (arrayList) {
                return !NotificationWindow.this.notifications.isEmpty() && NotificationWindow.this.notifications.get(0) != this;
            }
        }

        @Override
        public Object getResult() {
            return null;
        }

        @Override
        public void addListener(ModalDialogAsyncListener l) {
            NotificationWindow.this.listeners.add(ModalDialogAsyncListener.class, l);
        }

        @Override
        public void removeListener(ModalDialogAsyncListener l) {
            NotificationWindow.this.listeners.remove(ModalDialogAsyncListener.class, l);
        }
    }

    private class NotificationTimer
    extends LightweightTimer {
        private NotificationTimerTask task;

        public NotificationTimer(NotificationTimerTask task) {
            super((byte)2, (Runnable)task);
            this.task = task;
        }

        public void scheduleEvery(long interval, long timeout) {
            this.task.init(timeout);
            super.scheduleEvery(interval);
        }
    }

    private class NotificationTimerTask
    implements Runnable {
        private long timeout;
        private long startTime;

        private NotificationTimerTask() {
        }

        public void init(long timeout) {
            this.timeout = timeout;
            this.startTime = System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList arrayList = NotificationWindow.this.notifications;
            synchronized (arrayList) {
                long now = System.currentTimeMillis();
                NotificationWindow.this.timeoutWheel.setValue((int)((now - this.startTime + 499L) / 1000L));
                if (now - this.startTime > this.timeout) {
                    NotificationWindow.this.endNotification();
                }
            }
        }
    }

    private static class ShadowedPanel
    extends JToolBar {
        private GradientPaint paint;

        public ShadowedPanel() {
            this.setFloatable(false);
            float factor = 0.4f;
            Color c = this.getBackground();
            int r = c.getRed();
            int g = c.getGreen();
            int b = c.getBlue();
            Color topColor = new Color((int)((float)r * (1.0f - factor)), (int)((float)g * (1.0f - factor)), (int)((float)b * (1.0f - factor)));
            Color bottomColor = new Color(r + (int)((float)(255 - r) * factor), g + (int)((float)(255 - g) * factor), b + (int)((float)(255 - b) * factor));
            this.paint = new GradientPaint(0.0f, 0.0f, topColor, 0.0f, 7.0f, bottomColor);
        }

        @Override
        protected void paintComponent(Graphics g1) {
            Graphics2D g2 = (Graphics2D)g1;
            Dimension s = this.getSize();
            g2.setPaint(this.paint);
            g2.fillRect(0, 0, s.width, s.height);
        }
    }
}

