/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import com.elluminate.gui.FontUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class LabeledBorder
extends AbstractBorder {
    protected String title;
    protected Icon icon;
    protected Border border;
    protected Font titleFont;
    protected Color titleColor;
    private boolean haloShown = false;
    private Color haloColor = null;
    protected static final int TEXT_BORDER_V = 4;
    protected static final int TEXT_INSET_H = 8;
    protected static final int ICON_TEXT_SPACING = 4;

    public LabeledBorder(Icon icon) {
        this(icon, null);
    }

    public LabeledBorder(Icon icon, String title) {
        this.icon = icon;
        this.setTitle(title);
    }

    public boolean isHaloShown() {
        return this.haloShown;
    }

    public void setHaloShown(boolean b) {
        this.haloShown = b;
    }

    public Color getHaloColor() {
        if (this.haloColor == null) {
            this.haloColor = new Color(255, 255, 31, 127);
        }
        return this.haloColor;
    }

    public void setHaloColor(Color c) {
        this.haloColor = c;
    }

    private void paintHalo(Component c, Graphics g, int x, int y, int width, int height) {
        Insets ins = this.getBorderInsets(c);
        g.fillRect(x, y, width, ins.top);
        g.fillRect(x, y + ins.top, ins.left, height - ins.top);
        g.fillRect(x + width - ins.right, y + ins.top, ins.right, height - ins.top);
        g.fillRect(x + ins.left, y + height - ins.bottom, width - ins.left - ins.right, ins.bottom);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Font oldFont = g.getFont();
        Color oldColor = g.getColor();
        Border border = this.getBorder();
        Icon icon = this.getIcon();
        String title = this.getTitle();
        if (border != null && this.haloShown) {
            g.setColor(this.getHaloColor());
            this.paintHalo(c, g, x, y, width, height);
            g.setColor(oldColor);
        }
        g.setFont(this.getFont(c));
        FontMetrics fm = g.getFontMetrics();
        int ascent = fm.getAscent();
        Insets insets = border != null ? border.getBorderInsets(c) : new Insets(0, 0, 0, 0);
        Point labelLoc = new Point();
        labelLoc.y = y + 4 + ascent;
        labelLoc.x = x + 8 + insets.left;
        if (border != null) {
            border.paintBorder(c, g, x, y, width, height);
        }
        if (icon != null || title != null) {
            Color co = LabeledBorder.darkenColor(c.getBackground(), 0.15);
            Color topColor = LabeledBorder.lightenColor(co, 0.4);
            Color bottomColor = co;
            Rectangle b = new Rectangle(x + insets.left, y + insets.top, width - insets.left - insets.right, 8 + fm.getAscent() + fm.getDescent());
            int midy = b.height / 2;
            g.setColor(topColor);
            g.fillRect(b.x, b.y, b.width, midy);
            g.setColor(bottomColor);
            g.fillRect(b.x, b.y + midy, b.width, b.height - midy);
            g.setColor(Color.GRAY);
            g.drawLine(b.x, b.height - 1, b.width - 1, b.height - 1);
        }
        if (icon != null) {
            int icony = labelLoc.y - ascent / 2 - icon.getIconHeight() / 2;
            icon.paintIcon(c, g, labelLoc.x, icony);
        }
        if (title != null) {
            int titlex = labelLoc.x;
            if (icon != null) {
                titlex += icon.getIconWidth() + 4;
            }
            g.setColor(new Color(224, 224, 224));
            g.drawString(title, titlex, labelLoc.y + 1);
            g.setColor(this.getTitleColor());
            g.drawString(title, titlex, labelLoc.y);
        }
        g.setFont(oldFont);
        g.setColor(oldColor);
    }

    private static Color lightenColor(Color color, double factor) {
        return new Color(color.getRed() + (int)((double)(255 - color.getRed()) * factor), color.getGreen() + (int)((double)(255 - color.getGreen()) * factor), color.getBlue() + (int)((double)(255 - color.getBlue()) * factor));
    }

    private static Color darkenColor(Color color, double factor) {
        return new Color((int)((double)color.getRed() * (1.0 - factor)), (int)((double)color.getGreen() * (1.0 - factor)), (int)((double)color.getBlue() * (1.0 - factor)));
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        Font font;
        FontMetrics fm;
        Border border = this.getBorder();
        if (border != null) {
            if (border instanceof AbstractBorder) {
                ((AbstractBorder)border).getBorderInsets(c, insets);
            } else {
                Insets i = border.getBorderInsets(c);
                insets.top = i.top;
                insets.right = i.right;
                insets.bottom = i.bottom;
                insets.left = i.left;
            }
        } else {
            insets.bottom = 0;
            insets.right = 0;
            insets.top = 0;
            insets.left = 0;
        }
        if (c != null && (this.getIcon() != null || this.getTitle() != null) && (fm = c.getFontMetrics(font = this.getFont(c))) != null) {
            insets.top += 8 + fm.getAscent() + fm.getDescent();
        }
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public String getTitle() {
        return this.title;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public Border getBorder() {
        Border b = this.border;
        if (b == null) {
            b = BorderFactory.createMatteBorder(0, 0, 1, 1, Color.GRAY);
        }
        return b;
    }

    public Font getTitleFont() {
        Font f = this.titleFont;
        if (f == null) {
            f = UIManager.getFont("Label.font");
        }
        return f;
    }

    public Color getTitleColor() {
        Color c = this.titleColor;
        if (c == null) {
            c = UIManager.getColor("Label.foreground");
        }
        return c;
    }

    public void setTitle(String title) {
        this.title = title.length() == 0 ? null : title;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public void setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
    }

    public void setTitleColor(Color titleColor) {
        this.titleColor = titleColor;
    }

    public Dimension getMinimumSize(Component c) {
        Icon icon;
        Insets insets = this.getBorderInsets(c);
        Dimension minSize = new Dimension(insets.right + insets.left, insets.top + insets.bottom);
        Font font = this.getFont(c);
        FontMetrics fm = c.getFontMetrics(font);
        String title = this.getTitle();
        if (title != null) {
            minSize.width += fm.stringWidth(title);
        }
        if (title != null && this.icon != null) {
            minSize.width += 4;
        }
        if ((icon = this.getIcon()) != null) {
            minSize.width += icon.getIconWidth();
        }
        return minSize;
    }

    protected Font getFont(Component c) {
        Font font = this.getTitleFont();
        if (font != null) {
            return font;
        }
        if (c != null && (font = c.getFont()) != null) {
            return font;
        }
        return FontUtils.setFontStyleAndSize(null, 0, 12);
    }

    private static boolean computeIntersection(Rectangle dest, int rx, int ry, int rw, int rh) {
        int x1 = Math.max(rx, dest.x);
        int x2 = Math.min(rx + rw, dest.x + dest.width);
        int y1 = Math.max(ry, dest.y);
        int y2 = Math.min(ry + rh, dest.y + dest.height);
        dest.x = x1;
        dest.y = y1;
        dest.width = x2 - x1;
        dest.height = y2 - y1;
        return dest.width > 0 && dest.height > 0;
    }
}

