/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import com.elluminate.gui.GUIDebug;
import com.elluminate.gui.GuiUtils;
import com.elluminate.gui.component.StringsProperties;
import com.elluminate.gui.swing.CMenu;
import com.elluminate.gui.swing.CPopupMenu;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;

public class KeyConfigPanel
extends JPanel {
    private static final int[] KEY_CODES = new int[]{KeyConfigPanel.findKeyCode("VK_ACCEPT"), KeyConfigPanel.findKeyCode("VK_AGAIN"), 8, 3, 12, KeyConfigPanel.findKeyCode("VK_COPY"), KeyConfigPanel.findKeyCode("VK_CUT"), 127, 35, 10, 27, 24, 156, 36, 155, 34, 33, KeyConfigPanel.findKeyCode("VK_PASTE"), 19, 154, 145, 9, KeyConfigPanel.findKeyCode("VK_UNDO"), 38, 40, 37, 39};
    private static final int[] PF_KEY_CODES = new int[]{112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, KeyConfigPanel.findKeyCode("VK_F13"), KeyConfigPanel.findKeyCode("VK_F14"), KeyConfigPanel.findKeyCode("VK_F15"), KeyConfigPanel.findKeyCode("VK_F16"), KeyConfigPanel.findKeyCode("VK_F17"), KeyConfigPanel.findKeyCode("VK_F18"), KeyConfigPanel.findKeyCode("VK_F19"), KeyConfigPanel.findKeyCode("VK_F20"), KeyConfigPanel.findKeyCode("VK_F21"), KeyConfigPanel.findKeyCode("VK_F22"), KeyConfigPanel.findKeyCode("VK_F23"), KeyConfigPanel.findKeyCode("VK_F24")};
    private static final int[] NUMPAD_KEY_CODES = new int[]{96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 107, 109, 106, 111, 110, KeyConfigPanel.findKeyCode("VK_SEPARATOR"), KeyConfigPanel.findKeyCode("VK_KP_DOWN"), KeyConfigPanel.findKeyCode("VK_KP_LEFT"), KeyConfigPanel.findKeyCode("VK_KP_RIGHT"), KeyConfigPanel.findKeyCode("VK_KP_UP"), 144};
    private static final int[] MODIFIER_KEY_CODES = new int[]{18, 65406, 17, 157, 16};
    protected static I18n i18n = I18n.create((Object)new Object(){});
    protected JTextField keyField = new JTextField();
    protected JButton keyMenuBtn = new JButton(i18n.getIcon("KeyConfigPanel.keyMenuIcon"));
    protected JPopupMenu keyPopupMenu = new CPopupMenu(i18n.getString((PropertiesEnum)StringsProperties.KEYCONFIGPANEL_KEYMENU));
    protected JCheckBox metaKey = null;
    protected JCheckBox shiftKey = null;
    protected JCheckBox controlKey = null;
    protected JCheckBox altKey = null;
    protected int keyCode = 0;

    private static final int findKeyCode(String name) {
        try {
            return KeyEvent.class.getField(name).getInt(null);
        }
        catch (Throwable t) {
            return 0;
        }
    }

    public static boolean isModifierKey(int code) {
        if (code == 16) {
            return true;
        }
        if (code == 17) {
            return true;
        }
        if (code == 18) {
            return true;
        }
        return code == 157;
    }

    public KeyConfigPanel(int code, int mods, boolean includeModifierKeys) {
        super.setLayout(new BoxLayout(this, 1));
        this.initKeyConfigPanel(includeModifierKeys);
        this.setKeyCode(code);
        this.setKeyMods(mods);
    }

    public KeyConfigPanel(int code, int mods) {
        this(code, mods, false);
    }

    public KeyConfigPanel(boolean includeModifierKeys) {
        this(0, 0, includeModifierKeys);
    }

    public KeyConfigPanel() {
        this(0, 0, false);
    }

    public Component getPrimaryComponent() {
        return this.keyField;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public int getKeyModifiers() {
        int mods = 0;
        if (this.metaKey.isSelected()) {
            mods |= 4;
        }
        if (this.shiftKey.isSelected()) {
            mods |= 1;
        }
        if (this.controlKey.isSelected()) {
            mods |= 2;
        }
        if (this.altKey.isSelected()) {
            mods |= 8;
        }
        return mods;
    }

    public void setKeyCode(int code) {
        this.keyCode = code;
        String keyName = null;
        keyName = code == 0 ? i18n.getString((PropertiesEnum)StringsProperties.KEYCONFIGPANEL_NOKEYNAME) : GuiUtils.getKeyName(code);
        this.keyField.setText(keyName);
        this.keyField.setCaretPosition(keyName.length());
    }

    public void setKeyMods(int mods) {
        this.metaKey.setSelected((mods & 4) != 0);
        this.shiftKey.setSelected((mods & 1) != 0);
        this.controlKey.setSelected((mods & 2) != 0);
        this.altKey.setSelected((mods & 8) != 0);
    }

    private void initKeyConfigPanel(boolean includeModKeys) {
        this.shiftKey = new JCheckBox(i18n.getString((PropertiesEnum)StringsProperties.KEYCONFIGPANEL_SHIFTKEYCHECKBOX));
        this.shiftKey.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.KEYCONFIGPANEL_SHIFTKEYCHECKBOXTIP));
        this.controlKey = new JCheckBox(i18n.getString((PropertiesEnum)StringsProperties.KEYCONFIGPANEL_CONTROLKEYCHECKBOX));
        this.controlKey.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.KEYCONFIGPANEL_CONTROLKEYCHECKBOXTIP));
        if (Platform.getPlatform() == 2) {
            this.metaKey = new JCheckBox(i18n.getString((PropertiesEnum)StringsProperties.KEYCONFIGPANEL_MAC_METAKEYCHECKBOX));
            this.metaKey.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.KEYCONFIGPANEL_MAC_METAKEYCHECKBOXTIP));
            this.altKey = new JCheckBox(i18n.getString((PropertiesEnum)StringsProperties.KEYCONFIGPANEL_MAC_ALTKEYCHECKBOX));
            this.altKey.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.KEYCONFIGPANEL_MAC_ALTKEYCHECKBOXTIP));
        } else if (Platform.getPlatform() == 1) {
            this.metaKey = new JCheckBox(i18n.getString((PropertiesEnum)StringsProperties.KEYCONFIGPANEL_WIN_METAKEYCHECKBOX));
            this.metaKey.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.KEYCONFIGPANEL_WIN_METAKEYCHECKBOXTIP));
            this.altKey = new JCheckBox(i18n.getString((PropertiesEnum)StringsProperties.KEYCONFIGPANEL_ALTKEYCHECKBOX));
            this.altKey.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.KEYCONFIGPANEL_ALTKEYCHECKBOXTIP));
        } else {
            this.metaKey = new JCheckBox(i18n.getString((PropertiesEnum)StringsProperties.KEYCONFIGPANEL_METAKEYCHECKBOX));
            this.metaKey.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.KEYCONFIGPANEL_METAKEYCHECKBOXTIP));
            this.altKey = new JCheckBox(i18n.getString((PropertiesEnum)StringsProperties.KEYCONFIGPANEL_ALTKEYCHECKBOX));
            this.altKey.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.KEYCONFIGPANEL_ALTKEYCHECKBOXTIP));
        }
        if (Platform.getLAF() == 502) {
            this.keyMenuBtn.setMargin(new Insets(7, 6, 7, 6));
        } else {
            this.keyMenuBtn.setMargin(new Insets(1, 1, 1, 1));
        }
        this.keyMenuBtn.setFocusPainted(true);
        this.keyMenuBtn.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.KEYCONFIGPANEL_KEYMENUTIP));
        this.keyMenuBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ButtonModel mod = KeyConfigPanel.this.keyMenuBtn.getModel();
                if (mod.isArmed() && !KeyConfigPanel.this.keyPopupMenu.isVisible()) {
                    int x = KeyConfigPanel.this.keyMenuBtn.getWidth() - 2;
                    int y = KeyConfigPanel.this.keyMenuBtn.getHeight() / 2;
                    KeyConfigPanel.this.keyPopupMenu.show(KeyConfigPanel.this.keyMenuBtn, x, y);
                }
            }
        });
        KeyAdapter keyHandler = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (GUIDebug.KEY_CFG_EVENT.show()) {
                    LogSupport.message((Object)this, (String)"keyPressed", (String)e.paramString());
                }
                final int key = e.getKeyCode();
                final int mod = e.getModifiers();
                if (key == 0) {
                    KeyConfigPanel.this.setKeyCode(0);
                    KeyConfigPanel.this.setKeyMods(0);
                } else {
                    if (key == 10 && mod == 0) {
                        return;
                    }
                    if (key == 27 && mod == 0) {
                        return;
                    }
                    if (!KeyConfigPanel.isModifierKey(key)) {
                        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                KeyConfigPanel.this.setKeyCode(key);
                                KeyConfigPanel.this.setKeyMods(mod);
                            }
                        });
                    }
                }
                e.consume();
            }
        };
        this.keyField.setKeymap(null);
        this.keyField.setColumns(12);
        this.keyField.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.KEYCONFIGPANEL_KEYFIELDTIP));
        this.keyField.addKeyListener(keyHandler);
        this.keyField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent ev) {
                this.checkPopup(ev);
            }

            @Override
            public void mouseReleased(MouseEvent ev) {
                this.checkPopup(ev);
            }

            private void checkPopup(MouseEvent ev) {
                if (ev.isPopupTrigger() && !KeyConfigPanel.this.keyPopupMenu.isVisible()) {
                    int x = KeyConfigPanel.this.keyMenuBtn.getWidth() - 2;
                    int y = KeyConfigPanel.this.keyMenuBtn.getHeight() / 2;
                    KeyConfigPanel.this.keyPopupMenu.show(KeyConfigPanel.this.keyMenuBtn, x, y);
                }
            }
        });
        this.addMenuKey(this.keyPopupMenu, 0);
        for (int ix = 0; ix < KEY_CODES.length; ++ix) {
            int itemKeyCode = KEY_CODES[ix];
            if (itemKeyCode == 0) continue;
            this.addMenuKey(this.keyPopupMenu, itemKeyCode);
        }
        boolean hasSep = false;
        boolean hasPFs = false;
        CMenu pfKeyMenu = new CMenu(i18n.getString((PropertiesEnum)StringsProperties.KEYCONFIGPANEL_FUNCTIONKEYMENU));
        for (int ix = 0; ix < PF_KEY_CODES.length; ++ix) {
            int itemKeyCode = PF_KEY_CODES[ix];
            if (itemKeyCode == 0 || !this.addMenuKey(pfKeyMenu, itemKeyCode)) continue;
            hasPFs = true;
        }
        if (hasPFs) {
            if (!hasSep) {
                this.keyPopupMenu.addSeparator();
                hasSep = true;
            }
            this.keyPopupMenu.add(pfKeyMenu);
        }
        boolean hasPadKeys = false;
        CMenu padKeyMenu = new CMenu(i18n.getString((PropertiesEnum)StringsProperties.KEYCONFIGPANEL_NUMPADKEYMENU));
        for (int ix = 0; ix < NUMPAD_KEY_CODES.length; ++ix) {
            int itemKeyCode = NUMPAD_KEY_CODES[ix];
            if (itemKeyCode == 0 || !this.addMenuKey(padKeyMenu, itemKeyCode)) continue;
            hasPadKeys = true;
        }
        if (hasPadKeys) {
            if (!hasSep) {
                this.keyPopupMenu.addSeparator();
                hasSep = true;
            }
            this.keyPopupMenu.add(padKeyMenu);
        }
        if (includeModKeys) {
            boolean hasModKeys = false;
            CMenu modKeyMenu = new CMenu(i18n.getString((PropertiesEnum)StringsProperties.KEYCONFIGPANEL_MODKEYMENU));
            for (int ix = 0; ix < MODIFIER_KEY_CODES.length; ++ix) {
                int itemKeyCode = MODIFIER_KEY_CODES[ix];
                if (itemKeyCode == 0 || !this.addMenuKey(modKeyMenu, itemKeyCode)) continue;
                hasModKeys = true;
            }
            if (hasModKeys) {
                if (!hasSep) {
                    this.keyPopupMenu.addSeparator();
                    hasSep = true;
                }
                this.keyPopupMenu.add(modKeyMenu);
            }
        }
        JPanel keyPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(8, 3, 12, 3);
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        keyPanel.add((Component)this.keyMenuBtn, gbc);
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        keyPanel.add((Component)this.keyField, gbc);
        gbc.insets = new Insets(0, 3, 0, 3);
        keyPanel.add((Component)this.metaKey, gbc);
        keyPanel.add((Component)this.shiftKey, gbc);
        keyPanel.add((Component)this.controlKey, gbc);
        keyPanel.add((Component)this.altKey, gbc);
        this.add(keyPanel);
    }

    private boolean addMenuKey(JPopupMenu menu, int itemKeyCode) {
        String nm = KeyConfigPanel.getKeyName(itemKeyCode);
        if (nm == null) {
            return false;
        }
        this.addListener(menu.add(nm), itemKeyCode);
        return true;
    }

    private boolean addMenuKey(JMenu menu, int itemKeyCode) {
        String nm = KeyConfigPanel.getKeyName(itemKeyCode);
        if (nm == null) {
            return false;
        }
        this.addListener(menu.add(nm), itemKeyCode);
        return true;
    }

    private static String getKeyName(int itemKeyCode) {
        String nm = null;
        try {
            nm = itemKeyCode == 0 ? i18n.getString((PropertiesEnum)StringsProperties.KEYCONFIGPANEL_NOKEYNAME) : GuiUtils.getKeystrokeText(itemKeyCode, 0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return nm;
    }

    private void addListener(JMenuItem item, final int code) {
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                KeyConfigPanel.this.setKeyCode(code);
            }
        });
    }
}

