/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import com.elluminate.util.log.LogSupport;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import javax.swing.JPanel;

public class HHarbour
extends JPanel {
    FlowLayout flowLayout1 = new FlowLayout();
    private Dimension oldDimension = new Dimension(0, 0);
    private boolean sizing = false;
    private boolean visible = false;

    public HHarbour() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"HHarbour", (Throwable)ex, (boolean)true);
        }
    }

    private void jbInit() throws Exception {
        this.addContainerListener(new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent e) {
                HHarbour.this.this_componentAdded(e);
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                HHarbour.this.this_componentRemoved(e);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                HHarbour.this.this_componentResized(e);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                HHarbour.this.this_componentMoved(e);
            }
        });
        this.setMinimumSize(new Dimension(1, 1));
        this.setPreferredSize(new Dimension(1, 1));
        this.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(0);
        this.flowLayout1.setHgap(0);
        this.flowLayout1.setVgap(0);
        this.visible = super.isVisible();
    }

    public void setAlignment(int align) {
        this.flowLayout1.setAlignment(align);
    }

    public void setHgap(int hgap) {
        this.flowLayout1.setHgap(hgap);
    }

    public void setVgap(int vgap) {
        this.flowLayout1.setVgap(vgap);
    }

    private void setHarbourSize() {
        int maxBandHeight = 0;
        if (this.sizing) {
            return;
        }
        this.sizing = true;
        super.setVisible(false);
        this.validate();
        for (int i = 0; i < this.getComponentCount(); ++i) {
            maxBandHeight = Math.max(maxBandHeight, this.getComponent((int)i).getBounds().y + this.getComponent((int)i).getBounds().height);
        }
        Dimension panelSize = new Dimension(this.getBounds().width, maxBandHeight);
        if (!this.oldDimension.equals(panelSize)) {
            this.setMinimumSize(panelSize);
            this.setMaximumSize(panelSize);
            this.setPreferredSize(panelSize);
            this.setSize(panelSize);
        }
        this.oldDimension = panelSize;
        super.setVisible(this.visible);
        this.sizing = false;
    }

    public boolean getVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean vis) {
        this.visible = vis;
        if (!this.sizing) {
            super.setVisible(this.visible);
            this.setHarbourSize();
        }
    }

    void this_componentResized(ComponentEvent e) {
        if (!this.sizing) {
            this.setHarbourSize();
        }
    }

    void this_componentAdded(ContainerEvent e) {
        this.setHarbourSize();
    }

    void this_componentRemoved(ContainerEvent e) {
        this.setHarbourSize();
    }

    void this_componentHidden(ComponentEvent e) {
        if (!this.sizing) {
            this.setHarbourSize();
        }
    }

    void this_componentMoved(ComponentEvent e) {
        if (!this.sizing) {
            this.setHarbourSize();
        }
    }

    public void resizeHarbour(int width, int height) {
        if (!this.sizing) {
            if (width != this.getSize().width && height != this.getSize().height) {
                this.oldDimension.width = 0;
            }
            this.setSize(width, height);
            this.setHarbourSize();
        }
    }
}

