/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.border.AbstractBorder;

public class FlaggedBorder
extends AbstractBorder {
    public static final int DEFAULT_WIDTH = 3;
    public static final Color DEFAULT_COLOR = Color.RED;
    private int width = 3;
    private int margin = 4;
    private int radius = 7;
    private boolean flagged = false;
    private Color[] flagColors = null;
    private boolean fade = true;

    public FlaggedBorder() {
        this(DEFAULT_COLOR, 3, true);
    }

    public FlaggedBorder(int w) {
        this(DEFAULT_COLOR, w, true);
    }

    public FlaggedBorder(Color c) {
        this(c, 3, true);
    }

    public FlaggedBorder(Color c, int w) {
        this(c, w, true);
    }

    public FlaggedBorder(Color c, boolean fade) {
        this(c, 3, fade);
    }

    public FlaggedBorder(Color c, int w, boolean fade) {
        this(c, w, w + 1, w + 4, fade);
    }

    public FlaggedBorder(Color c, int w, int m, int r, boolean fade) {
        this.width = Math.max(1, w);
        this.margin = Math.max(w, m);
        this.radius = Math.max(0, r);
        this.setFlagColor(c, fade);
    }

    public int getWidth() {
        return this.width;
    }

    public int getMargin() {
        return this.margin;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setWidth(int w) {
        this.setWidth(w, w + 1, w + 4);
    }

    public void setWidth(int w, int r) {
        this.setWidth(w, w + 1, r);
    }

    public void setWidth(int w, int m, int r) {
        if (this.width == w && this.margin == m && this.radius == r) {
            return;
        }
        Color c = this.getFlagColor();
        this.width = Math.max(1, w);
        this.margin = Math.max(w, m);
        this.radius = Math.max(0, r);
        this.setFlagColor(c, this.fade);
    }

    public Color getFlagColor() {
        if (this.flagColors == null) {
            return DEFAULT_COLOR;
        }
        if (this.flagColors.length < 1) {
            return DEFAULT_COLOR;
        }
        if (this.flagColors[0] == null) {
            return DEFAULT_COLOR;
        }
        return this.flagColors[0];
    }

    public void setFlagColor(Color c, boolean fade) {
        if (c == null) {
            c = DEFAULT_COLOR;
        }
        this.fade = fade;
        Color[] colors = new Color[this.width];
        colors[0] = c;
        int alpha = c.getAlpha();
        for (int ix = 1; ix < this.width; ++ix) {
            if (fade) {
                alpha = (alpha + 1) / 2;
                colors[ix] = new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
                continue;
            }
            colors[ix] = c;
        }
        this.flagColors = colors;
    }

    public boolean isFlagged() {
        return this.flagged;
    }

    public void setFlagged(boolean b) {
        this.flagged = b;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets ins) {
        ins.set(this.margin, this.margin, this.margin, this.margin);
        return ins;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.margin, this.margin, this.margin, this.margin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color[] colors = this.flagColors;
        if (this.flagged && colors != null) {
            Graphics2D g2 = null;
            try {
                g2 = (Graphics2D)g.create();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                for (int ix = 0; ix < colors.length; ++ix) {
                    g2.setColor(colors[colors.length - ix - 1]);
                    g2.drawRoundRect(x + ix, y + ix, width - ix * 2 - 1, height - ix * 2 - 1, this.radius - ix, this.radius - ix);
                }
            }
            finally {
                if (g2 != null) {
                    g2.dispose();
                }
            }
        }
    }
}

