/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.Arrays;
import javax.swing.border.AbstractBorder;

public class DropShadowBorder
extends AbstractBorder {
    public static final Color DEFAULT_COLOR = Color.BLACK;
    public static final float DEFAULT_ALPHA = 0.75f;
    public static final int DEFAULT_OFFSET_X = 3;
    public static final int DEFAULT_OFFSET_Y = 4;
    public static final int DEFAULT_BLUR = 7;
    public static final int MAX_BLUR = 64;
    private static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    private Color colour;
    private float alpha;
    private final int offsetX;
    private final int offsetY;
    private final int blurWidth;
    private final float[] blurMatrix;

    public DropShadowBorder() {
        this(DEFAULT_COLOR, 0.75f, 3, 4, 7);
    }

    public DropShadowBorder(Color colour) {
        this(colour, 0.75f, 3, 4, 7);
    }

    public DropShadowBorder(float alpha) {
        this(DEFAULT_COLOR, alpha, 3, 4, 7);
    }

    public DropShadowBorder(Color colour, int blurWidth) {
        this(colour, 0.75f, 3, 4, blurWidth);
    }

    public DropShadowBorder(float alpha, int blurWidth) {
        this(DEFAULT_COLOR, alpha, 3, 4, blurWidth);
    }

    public DropShadowBorder(Color colour, float alpha) {
        this(colour, alpha, 3, 4, 7);
    }

    public DropShadowBorder(Color colour, float alpha, int blurWidth) {
        this(colour, alpha, 3, 4, blurWidth);
    }

    public DropShadowBorder(Color colour, int offsetX, int offsetY) {
        this(colour, 0.75f, offsetX, offsetY, 7);
    }

    public DropShadowBorder(Color colour, float alpha, int offsetX, int offsetY) {
        this(colour, alpha, offsetX, offsetY, 7);
    }

    public DropShadowBorder(Color colour, double angle, int distance) {
        this(colour, 0.75f, angle, distance, 7);
    }

    public DropShadowBorder(float alpha, double angle, int distance) {
        this(DEFAULT_COLOR, alpha, angle, distance, 7);
    }

    public DropShadowBorder(Color colour, float alpha, double angle, int distance) {
        this(colour, alpha, angle, distance, 7);
    }

    public DropShadowBorder(Color colour, float alpha, double angle, int distance, int blurWidth) {
        this(colour, alpha, (int)Math.round(Math.cos(Math.toRadians(angle)) * (double)distance), (int)Math.round(Math.sin(Math.toRadians(angle)) * (double)distance), blurWidth);
    }

    public DropShadowBorder(Color colour, float alpha, int offsetX, int offsetY, int blurWidth) {
        this.colour = colour;
        this.alpha = alpha;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.blurWidth = Math.max(0, Math.min(blurWidth, 64));
        this.blurMatrix = new float[blurWidth];
        Arrays.fill(this.blurMatrix, 1.0f / (float)blurWidth);
    }

    public Color getColor() {
        return this.colour;
    }

    public void setColor(Color c) {
        this.colour = c;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float a) {
        this.alpha = a;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public int getBlurWidth() {
        return this.blurWidth;
    }

    protected Shape getShadowShape(Component c, int x, int y, int w, int h) {
        Shape result = null;
        if (c instanceof ShadowShape) {
            result = ((ShadowShape)((Object)c)).getShadowShape(x, y, w, h);
        }
        if (result == null) {
            result = new Rectangle(x, y, w, h);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image shapeToImage(Shape shape, int width, int height) {
        if (shape == null) {
            return null;
        }
        Rectangle bounds = shape.getBounds();
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g = null;
        try {
            g = image.createGraphics();
            g.setComposite(AlphaComposite.Src);
            g.setColor(TRANSPARENT);
            g.fillRect(0, 0, width, height);
            g.setColor(this.colour);
            g.fill(shape);
        }
        finally {
            if (g != null) {
                g.dispose();
            }
        }
        if (this.blurWidth > 0) {
            ConvolveOp blur = new ConvolveOp(new Kernel(1, this.blurWidth, this.blurMatrix), 0, null);
            BufferedImage tmp = blur.filter(image, null);
            blur = new ConvolveOp(new Kernel(this.blurWidth, 1, this.blurMatrix), 0, null);
            image.flush();
            image = blur.filter(tmp, image);
            tmp.flush();
        }
        return image;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets ins) {
        ins.set(this.offsetY >= 0 ? Math.max(0, this.blurWidth - this.offsetY) : this.blurWidth - this.offsetY, this.offsetX >= 0 ? Math.max(0, this.blurWidth - this.offsetX) : this.blurWidth - this.offsetX, this.offsetY >= 0 ? this.offsetY + this.blurWidth : Math.max(0, this.blurWidth + this.offsetY), this.offsetX >= 0 ? this.offsetX + this.blurWidth : Math.max(0, this.blurWidth + this.offsetX));
        return ins;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = null;
        Insets ins = this.getBorderInsets(c);
        int w = width - ins.left - ins.right;
        int h = height - ins.top - ins.bottom;
        int componentX = ins.left;
        int componentY = ins.top;
        int shadowX = componentX + this.offsetX;
        int shadowY = componentY + this.offsetY;
        Shape shape = this.getShadowShape(c, shadowX, shadowY, w, h);
        Image shadow = this.shapeToImage(shape, width + 1, height + 1);
        try {
            g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setComposite(AlphaComposite.getInstance(10, this.alpha));
            g2.drawImage(shadow, x, y, c);
        }
        finally {
            if (g2 != null) {
                g2.dispose();
            }
            if (shadow != null) {
                shadow.flush();
            }
        }
    }

    public static interface ShadowShape {
        public Shape getShadowShape(int var1, int var2, int var3, int var4);
    }
}

