/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class DisabledIcon
implements Icon {
    private static final Color TRANSPARENT_FILL = new Color(0, true);
    private Icon icon = null;

    public static Icon getDisabledIcon(Icon icn, JComponent cmp) {
        Icon result = null;
        if (icn == null) {
            return null;
        }
        LookAndFeel laf = UIManager.getLookAndFeel();
        result = laf.getDisabledIcon(cmp, icn);
        if (result == null) {
            result = new DisabledIcon(icn);
        }
        return result;
    }

    private DisabledIcon(Icon srcIcon) {
        this.icon = srcIcon;
    }

    @Override
    public int getIconHeight() {
        if (this.icon == null) {
            return 0;
        }
        return this.icon.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        if (this.icon == null) {
            return 0;
        }
        return this.icon.getIconWidth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.icon == null) {
            return;
        }
        Graphics2D g2 = null;
        Image img = null;
        int w = this.icon.getIconWidth();
        int h = this.icon.getIconHeight();
        if (w < 1 || h < 1) {
            return;
        }
        try {
            img = new BufferedImage(w, h, 2);
            try {
                g2 = ((BufferedImage)img).createGraphics();
                g2.setColor(TRANSPARENT_FILL);
                g2.fillRect(0, 0, w, h);
                this.icon.paintIcon(c, g2, 0, 0);
            }
            finally {
                if (g2 != null) {
                    g2.dispose();
                }
            }
            DisabledIcon.dechromifyImage((BufferedImage)img, w, h);
            g.drawImage(img, x, y, c);
        }
        finally {
            if (img != null) {
                img.flush();
            }
        }
    }

    public String toString() {
        return "DisabledIcon: icon={" + this.icon + "}";
    }

    private static void dechromifyImage(BufferedImage img, int w, int h) {
        int[] pixels = new int[w * h];
        img.getRGB(0, 0, w, h, pixels, 0, w);
        for (int ix = 0; ix < pixels.length; ++ix) {
            pixels[ix] = DisabledIcon.dechromifyPixel(pixels[ix]);
        }
        img.setRGB(0, 0, w, h, pixels, 0, w);
    }

    private static int dechromifyPixel(int rgb) {
        if ((rgb & 0xFF000000) == 0) {
            return 0;
        }
        int gray = (int)((0.3 * (double)(rgb >> 16 & 0xFF) + 0.59 * (double)(rgb >> 8 & 0xFF) + 0.11 * (double)(rgb & 0xFF)) / 3.0);
        if ((gray = 255 - (255 - gray) / 2) < 0) {
            gray = 0;
        }
        if (gray > 255) {
            gray = 255;
        }
        return rgb & 0xFF000000 | gray << 16 | gray << 8 | gray << 0;
    }
}

