/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import com.elluminate.gui.component.EasyDialog;
import com.elluminate.gui.component.InvalidPreferenceSettingException;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.util.Preferences;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public abstract class AbstractPreferencesPanel
extends JPanel {
    public static final String SETTINGS_MODIFIED = "settingsModified";
    private PreferencesPanelOwner owner;
    private String title;
    private boolean modified = false;
    private boolean contentCreated = false;
    private boolean settingsValid = true;

    public AbstractPreferencesPanel(PreferencesPanelOwner owner, String title) {
        this.owner = owner;
        this.title = title;
        Insets ins = EasyDialog.getStandardInsets();
        this.setBorder(BorderFactory.createEmptyBorder(ins.top, ins.left, ins.bottom, ins.right));
    }

    public final PreferencesPanelOwner getOwner() {
        return this.owner;
    }

    public final String getOwnerPrefix() {
        return this.owner.getPrefix();
    }

    public final String getTitle() {
        return this.title;
    }

    public boolean hasStore() {
        return false;
    }

    public Object getStore(boolean copy) {
        return null;
    }

    public void setStore(Object store) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void populateSettings(Object settings) {
        AbstractPreferencesPanel abstractPreferencesPanel = this;
        synchronized (abstractPreferencesPanel) {
            if (!this.contentCreated) {
                this.createContent();
                this.contentCreated = true;
            }
        }
        if (settings instanceof Preferences) {
            this.populate((Preferences)settings);
        } else {
            this.populate(settings);
        }
    }

    protected abstract void createContent();

    protected void populate(Preferences preferences) {
    }

    protected void populate(Object store) {
    }

    public final void applySettings(Object settings) throws InvalidPreferenceSettingException {
        if (settings instanceof Preferences) {
            this.apply((Preferences)settings);
        } else {
            this.apply(settings);
        }
    }

    protected void apply(Preferences preferences) throws InvalidPreferenceSettingException {
    }

    protected void apply(Object store) throws InvalidPreferenceSettingException {
    }

    public final void resetSettings(Object settings) {
        if (settings instanceof Preferences) {
            this.reset((Preferences)settings);
        } else {
            this.reset(settings);
        }
    }

    protected void reset(Preferences preferences) {
    }

    protected void reset(Object store) {
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        boolean oldModified = this.modified;
        this.modified = modified;
        if (modified != oldModified) {
            this.firePropertyChange(SETTINGS_MODIFIED, oldModified, modified);
        }
    }
}

