/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui;

import com.elluminate.gui.GUIDebug;
import com.elluminate.platform.PlatformIssues;
import com.elluminate.util.SerializerThread;
import com.elluminate.util.SwingRunner;
import com.elluminate.util.ThreadUtils;
import com.elluminate.util.UtilDebug;
import com.elluminate.util.log.ExTRASupport;
import com.elluminate.util.log.LogSupport;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

public class SwingRunnerExecute
implements SwingRunner {
    private static final ThreadGroup creatorGroup = PlatformIssues.JWS_HAS_MULTIPLE_CONTEXTS ? Thread.currentThread().getThreadGroup() : null;
    private SerializerThread serializer;

    public SwingRunnerExecute() throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.serializer = PlatformIssues.JWS_HAS_MULTIPLE_CONTEXTS ? new SerializerThread() : null;
    }

    public boolean isEventThread() {
        return SwingUtilities.isEventDispatchThread();
    }

    public void invokeLater(Runnable r) {
        final SwingWrapper r2 = new SwingWrapper(r);
        if (PlatformIssues.JWS_HAS_MULTIPLE_CONTEXTS && !this.checkContext(Thread.currentThread())) {
            Runnable r3 = new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(r2);
                }
            };
            this.serializer.invokeLater(r3);
            return;
        }
        SwingUtilities.invokeLater(r2);
    }

    public void invokeAndWait(Runnable r) throws InterruptedException {
        SwingWrapper r2 = new SwingWrapper(r);
        if (PlatformIssues.JWS_HAS_MULTIPLE_CONTEXTS && !this.checkContext(Thread.currentThread())) {
            DeferAndWait r3 = new DeferAndWait(r, r2);
            try {
                this.serializer.invokeAndWait((Runnable)r3);
            }
            catch (InvocationTargetException itx) {
                LogSupport.exception((Object)this, (String)"invokeAndWait", (Throwable)itx, (boolean)false, (String)("Processing: " + r));
            }
            if (r3.deferredInterruption != null) {
                throw r3.deferredInterruption;
            }
            return;
        }
        if (this.isEventThread()) {
            r2.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r2);
            }
            catch (InvocationTargetException itx) {
                Throwable cause = itx.getCause();
                if (cause instanceof InterruptedException) {
                    throw (InterruptedException)cause;
                }
                if (cause != null) {
                    LogSupport.exception((Object)this, (String)"invokeAndWait", (Throwable)cause, (boolean)false, (String)("Processing: " + r));
                }
                LogSupport.exception((Object)this, (String)"invokeAndWait", (Throwable)itx, (boolean)false, (String)("Processing: " + r));
            }
        }
    }

    public void invokeOnEventThread(Runnable r) {
        final SwingWrapper r2 = new SwingWrapper(r);
        if (PlatformIssues.JWS_HAS_MULTIPLE_CONTEXTS && !this.checkContext(Thread.currentThread())) {
            Runnable r3 = new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(r2);
                }
            };
            this.serializer.invokeLater(r3);
            return;
        }
        if (this.isEventThread()) {
            r2.run();
        } else {
            SwingUtilities.invokeLater(r2);
        }
    }

    private boolean checkContext(Thread t) {
        ThreadGroup tGrp = t.getThreadGroup();
        boolean correctContext = creatorGroup.parentOf(tGrp);
        if (!correctContext && GUIDebug.JWS_CONTEXT.show()) {
            LogSupport.message((Object)this, (String)"checkContext", (String)("Wrong thread group for " + t + ": " + tGrp + " vs. " + creatorGroup + "\n" + ThreadUtils.getStackTrace((Thread)t, (String)"  @ ")));
        }
        return correctContext;
    }

    public boolean isEventDispatchThread() {
        return SwingUtilities.isEventDispatchThread();
    }

    private static class DeferAndWait
    implements Runnable {
        private Runnable wrapper;
        private Runnable original;
        private InterruptedException deferredInterruption;

        DeferAndWait(Runnable orig, Runnable wrap) {
            this.original = orig;
            this.wrapper = wrap;
            this.deferredInterruption = null;
        }

        @Override
        public void run() {
            try {
                SwingUtilities.invokeAndWait(this.wrapper);
            }
            catch (InterruptedException intx) {
                this.deferredInterruption = intx;
            }
            catch (InvocationTargetException itx) {
                LogSupport.exception((Object)this, (String)"run (for SwingRunnerExecute.invokeAndWait)", (Throwable)itx, (boolean)false, (String)("Processing: " + this.original));
            }
        }
    }

    private class SwingWrapper
    implements Runnable {
        Runnable r;
        long timestamp;
        String threadInfo = null;

        public SwingWrapper(Runnable r) {
            if (r == null) {
                throw new NullPointerException();
            }
            this.r = r;
            this.threadInfo = "On behalf of: " + Thread.currentThread();
            if (GUIDebug.SWING_RUNNER_TRACE.show()) {
                String IGNORE_ME_PREFIX = this.getClass().getName();
                boolean skipping = true;
                StringBuilder trace = new StringBuilder();
                for (StackTraceElement frm : Thread.currentThread().getStackTrace()) {
                    if (skipping) {
                        String name = frm.getClassName();
                        if (name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("com.sun.") || name.startsWith(IGNORE_ME_PREFIX)) continue;
                        skipping = false;
                    }
                    trace.append("\n  at " + frm);
                }
                this.threadInfo = this.threadInfo + trace.toString();
            }
            this.timestamp = System.currentTimeMillis();
            if (UtilDebug.SWING_INVOKE.show()) {
                LogSupport.message((Object)this, (String)"<init>", (String)("Queuing: " + this));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ExTRASupport.ExceptionListener extraListener = new ExTRASupport.ExceptionListener(){

                public void exceptionReported(ExTRASupport.ExceptionEvent ev) {
                    if (SwingRunnerExecute.this.isEventThread()) {
                        ev.getExtraFields().put("originalThread", SwingWrapper.this.threadInfo);
                    }
                }
            };
            try {
                if (UtilDebug.SWING_INVOKE.show()) {
                    LogSupport.message((Object)this, (String)"run", (String)("Starting: " + this));
                }
                ExTRASupport.addExceptionListener((ExTRASupport.ExceptionListener)extraListener);
                this.r.run();
                ExTRASupport.removeExceptionListener((ExTRASupport.ExceptionListener)extraListener);
            }
            catch (Throwable t) {
                ExTRASupport.removeExceptionListener((ExTRASupport.ExceptionListener)extraListener);
                LogSupport.exception((Object)this.r, (String)"run", (Throwable)t, (boolean)true);
            }
            finally {
                if (UtilDebug.SWING_INVOKE.show()) {
                    LogSupport.message((Object)this, (String)"run", (String)("Finished: " + this));
                }
            }
        }

        public String toString() {
            return "age=" + (System.currentTimeMillis() - this.timestamp) + " " + this.r.getClass().getName() + "@" + System.identityHashCode(this.r);
        }
    }
}

