/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui;

import com.elluminate.gui.GUIDebug;
import com.elluminate.gui.GuiUtils;
import com.elluminate.platform.Platform;
import com.elluminate.util.log.LogSupport;
import java.awt.AWTException;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;

public class ScreenSnapshot {
    private static final boolean IS_MAC = Platform.getPlatform() == 2;
    private static final boolean IS_WIN = Platform.getPlatform() == 1;
    private static final boolean IS_VIRTUAL_SPACE = IS_MAC || IS_WIN;
    private static final boolean MAC_BOT_BUG = IS_MAC;
    private static boolean isOK = true;
    private static boolean forceGC = false;
    private BufferedImage image = null;
    private Rectangle bounds = new Rectangle();
    private long timeStamp = 0L;

    public String toString() {
        return this.getClass().getName() + " time=" + this.timeStamp + " (" + (System.currentTimeMillis() - this.timeStamp) + " msec ago) bounds=" + this.bounds + " image=" + this.image;
    }

    public static boolean isAvailable() {
        return isOK;
    }

    public boolean hasSnapshot() {
        return !this.bounds.isEmpty() && this.image != null;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public long getSnapTime() {
        return this.timeStamp;
    }

    public void clear() {
        this.bounds.setBounds(0, 0, 0, 0);
        if (this.image != null) {
            this.image.flush();
        }
        this.image = null;
        this.timeStamp = 0L;
    }

    public boolean takeSnapshot() {
        return this.takeSnapshot(GuiUtils.getDesktopBounds());
    }

    public boolean takeSnapshot(Rectangle area) {
        boolean success = false;
        try {
            BufferedImage oldImg = this.image;
            BufferedImage newImage = null;
            Class<?> lock = this.getClass();
            newImage = ScreenSnapshot.captureAllScreens(area);
            if (newImage == null) {
                return false;
            }
            this.image = newImage;
            this.bounds.setBounds(area);
            success = true;
            this.timeStamp = System.currentTimeMillis();
            if (oldImg != null) {
                oldImg.flush();
            }
        }
        catch (Exception ex) {
            this.clear();
            success = false;
            LogSupport.exception((Object)this, (String)"takeSnapshot", (Throwable)ex, (boolean)true, (String)("area=" + area));
        }
        return success;
    }

    public Image getImage() {
        if (this.bounds.isEmpty() || this.image == null) {
            return null;
        }
        return this.image;
    }

    public Image getImage(Rectangle area) {
        if (this.bounds.isEmpty() || this.image == null) {
            return null;
        }
        Rectangle clip = this.bounds.intersection(area);
        if (clip.isEmpty()) {
            return null;
        }
        if (clip.equals(this.bounds)) {
            return this.image;
        }
        Point loc = this.bounds.getLocation();
        clip.translate(-loc.x, -loc.y);
        return this.image.getSubimage(clip.x, clip.y, clip.width, clip.height);
    }

    public Image getScaledImage(Rectangle area, int width, int height) {
        return this.getScaledImage(area, width, height, false);
    }

    public Image getScaledImage(Rectangle area, int width, int height, boolean fast) {
        if (this.bounds.isEmpty() || this.image == null) {
            return null;
        }
        Rectangle clip = this.bounds.intersection(area);
        if (clip.isEmpty()) {
            return null;
        }
        Point loc = this.bounds.getLocation();
        clip.translate(-loc.x, -loc.y);
        if (width <= 0 || height <= 0) {
            return null;
        }
        BufferedImage srcImage = this.image;
        if (srcImage == null) {
            return null;
        }
        int[] pixels = new int[width * height];
        double xScale = (double)clip.width / (double)width;
        double yScale = (double)clip.height / (double)height;
        int pix = 0;
        boolean startRow = false;
        for (int y = 0; y < height; ++y) {
            double yImg = (double)y * yScale;
            int yInt = (int)(yImg + 0.5);
            for (int x = 0; x < width; ++x) {
                int val;
                double xImg = (double)x * xScale;
                int xInt = (int)(xImg + 0.5);
                if (fast) {
                    val = srcImage.getRGB(clip.x + xInt, clip.y + yInt);
                } else {
                    int yNext;
                    int xNext = (int)((double)(x + 1) * xScale + 0.5);
                    if (xNext >= clip.width) {
                        xNext = clip.width - 1;
                    }
                    if ((yNext = (int)((double)(y + 1) * yScale + 0.5)) >= clip.height) {
                        yNext = clip.height - 1;
                    }
                    int xCount = xNext - xInt;
                    int yCount = yNext - yInt;
                    if (xCount < 1) {
                        xCount = 1;
                    }
                    if (yCount < 1) {
                        yCount = 1;
                    }
                    int total = xCount * yCount;
                    int red = 0;
                    int grn = 0;
                    int blu = 0;
                    for (int iy = 0; iy < yCount; ++iy) {
                        for (int ix = 0; ix < xCount; ++ix) {
                            int cur = srcImage.getRGB(clip.x + xInt + ix, clip.y + yInt + iy);
                            red += cur >> 16 & 0xFF;
                            grn += cur >> 8 & 0xFF;
                            blu += cur & 0xFF;
                        }
                    }
                    red = (red + total / 2) / total & 0xFF;
                    grn = (grn + total / 2) / total & 0xFF;
                    blu = (blu + total / 2) / total & 0xFF;
                    val = 0xFF000000 | red << 16 | grn << 8 | blu;
                }
                pixels[pix++] = val;
            }
        }
        BufferedImage result = new BufferedImage(width, height, 1);
        result.setRGB(0, 0, width, height, pixels, 0, width);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized BufferedImage captureAllScreens(Rectangle area) throws AWTException {
        if (GUIDebug.APP_SNAP.show()) {
            LogSupport.message(ScreenSnapshot.class, (String)"captureAllScreens", (String)("Capture desktop: " + area));
        }
        if (forceGC) {
            forceGC = false;
            LogSupport.message(ScreenSnapshot.class, (String)"captureAllScreens", (String)"Forcing GC...");
            System.gc();
            if (GUIDebug.APP_SNAP.show()) {
                LogSupport.message(ScreenSnapshot.class, (String)"captureAllScreens", (String)("After GC: " + Platform.getMemoryStatus()));
            }
        }
        Robot robot = new Robot();
        robot.delay(100);
        robot.waitForIdle();
        BufferedImage result = null;
        try {
            result = new BufferedImage(area.width, area.height, 1);
        }
        catch (OutOfMemoryError oome) {
            LogSupport.error(ScreenSnapshot.class, (String)"captureAllScreens", (String)("Failed to create " + area.width + "x" + area.height + " snapshot image: " + oome));
            System.gc();
            forceGC = true;
            return null;
        }
        Graphics2D gc = null;
        try {
            gc = result.createGraphics();
            if (!ScreenSnapshot.compositeAllScreens(area, gc)) {
                result.flush();
                BufferedImage bufferedImage = null;
                return bufferedImage;
            }
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
        }
        if (GUIDebug.APP_SNAP.show()) {
            LogSupport.message(ScreenSnapshot.class, (String)"captureAllScreens", (String)("Memory: " + Platform.getMemoryStatus()));
        }
        return result;
    }

    private static boolean compositeAllScreens(Rectangle area, Graphics2D gc) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice mainScreen = ge.getDefaultScreenDevice();
        GraphicsDevice[] screens = ge.getScreenDevices();
        Robot displayBot = null;
        for (int ix = 0; ix < screens.length; ++ix) {
            int translateX = 0;
            int translateY = 0;
            boolean isMain = mainScreen == screens[ix];
            GraphicsConfiguration gConfig = screens[ix].getDefaultConfiguration();
            Rectangle bounds = gConfig.getBounds();
            if (bounds == null) {
                if (!GUIDebug.APP_SNAP.show()) continue;
                LogSupport.message(ScreenSnapshot.class, (String)"compositeAllScreens", (String)("Config has no bounds: " + gConfig));
                continue;
            }
            if (GUIDebug.APP_SNAP.show()) {
                LogSupport.message(ScreenSnapshot.class, (String)"compositeAllScreens", (String)("Default config: " + gConfig + " " + bounds));
            }
            if (!isMain && bounds.x == 0 && bounds.y == 0) {
                if (!GUIDebug.APP_SNAP.show()) continue;
                LogSupport.message(ScreenSnapshot.class, (String)"compositeAllScreens", (String)("Skipping display overlapping in virtual space: " + screens[ix].getIDstring() + " [" + bounds.x + "," + bounds.y + "] " + bounds.width + "x" + bounds.height));
                continue;
            }
            try {
                Rectangle capArea;
                if (IS_VIRTUAL_SPACE && !MAC_BOT_BUG) {
                    if (displayBot == null) {
                        displayBot = new Robot();
                    }
                    translateX = 0;
                    translateY = 0;
                } else {
                    displayBot = isMain ? new Robot() : new Robot(screens[ix]);
                    translateX = bounds.x;
                    translateY = bounds.y;
                }
                if (GUIDebug.APP_SNAP.show()) {
                    LogSupport.message(ScreenSnapshot.class, (String)"compositeAllScreens", (String)("Capturing " + screens[ix].getIDstring() + (screens[ix] == mainScreen ? " (Main)" : "") + " [" + bounds.x + "," + bounds.y + "] " + bounds.width + "x" + bounds.height));
                }
                if (GUIDebug.APP_SNAP.show()) {
                    LogSupport.message(ScreenSnapshot.class, (String)"compositeAllScreens", (String)("Intersecting display with " + area));
                }
                if ((capArea = area.intersection(bounds)).isEmpty()) {
                    if (!GUIDebug.APP_SNAP.show()) continue;
                    LogSupport.message(ScreenSnapshot.class, (String)"compositeAllScreens", (String)("Screen capture area is empty: " + capArea + " / " + area));
                    continue;
                }
                int posX = capArea.x - area.x;
                int posY = capArea.y - area.y;
                if (GUIDebug.APP_SNAP.show()) {
                    LogSupport.message(ScreenSnapshot.class, (String)"compositeAllScreens", (String)("Desktop capture area: " + capArea));
                }
                capArea.x -= translateX;
                capArea.y -= translateY;
                if (GUIDebug.APP_SNAP.show()) {
                    LogSupport.message(ScreenSnapshot.class, (String)"compositeAllScreens", (String)("Device capture area: " + capArea));
                }
                BufferedImage screenCap = displayBot.createScreenCapture(capArea);
                if (GUIDebug.APP_SNAP.show()) {
                    LogSupport.message(ScreenSnapshot.class, (String)"compositeAllScreens", (String)("Compositing image at " + posX + "," + posY));
                }
                gc.drawImage((Image)screenCap, posX, posY, null);
                screenCap.flush();
                continue;
            }
            catch (Throwable ex) {
                String message = "while capturing display " + screens[ix].getIDstring() + " @ " + bounds.x + "," + bounds.y + " for " + bounds.width + "x" + bounds.height + " in desktop " + area.x + "," + area.y + " " + area.width + "x" + area.height;
                if (ex instanceof OutOfMemoryError) {
                    LogSupport.message(ScreenSnapshot.class, (String)"compositeAllScreens", (String)(ex + ": " + message));
                    forceGC = true;
                } else {
                    LogSupport.exception(ScreenSnapshot.class, (String)"compositeAllScreens", (Throwable)ex, (boolean)true, (String)message);
                }
                return false;
            }
        }
        return true;
    }
}

