/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui;

import com.elluminate.gui.GUIDebug;
import com.elluminate.gui.PlatformTheme;
import com.elluminate.util.StringComparator;
import com.elluminate.util.log.LogSupport;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.TreeMap;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

public class NativeTheme
extends PlatformTheme {
    ColorUIResource txt;
    ColorUIResource hiTxt;
    ColorUIResource menuFG;
    ColorUIResource winBG;
    ColorUIResource winFG;
    ColorUIResource txtHighlight;

    public NativeTheme() {
        UIDefaults defaults = null;
        LookAndFeel system = null;
        try {
            LookAndFeel saved = UIManager.getLookAndFeel();
            String sysName = UIManager.getSystemLookAndFeelClassName();
            Class<?> sysClass = Class.forName(sysName);
            system = (LookAndFeel)sysClass.newInstance();
            system.initialize();
            defaults = system.getDefaults();
            if (GUIDebug.THEMES.show()) {
                TreeMap<String, Object> sorted = new TreeMap<String, Object>((Comparator<String>)new StringComparator(false));
                boolean done = false;
                while (!done) {
                    String key = null;
                    try {
                        Enumeration i = defaults.keys();
                        while (i.hasMoreElements()) {
                            key = (String)i.nextElement();
                            Object value = defaults.get(key);
                            sorted.put(key, value);
                        }
                        done = true;
                    }
                    catch (Throwable t) {
                        sorted.put(key, null);
                    }
                }
                LogSupport.message((Object)this, (String)"<init>", (String)"Look and feel defaults:");
                for (String key : sorted.keySet()) {
                    Object val = sorted.get(key);
                    if (val == null) {
                        LogSupport.message((String)("  " + key + " = null"));
                        continue;
                    }
                    LogSupport.message((String)("  " + key + " = " + val));
                }
                LogSupport.message((String)"");
            }
        }
        catch (Throwable t) {
            if (GUIDebug.THEMES.show()) {
                LogSupport.exception((Object)this, (String)"<init>", (Throwable)t, (boolean)true);
            }
            throw new RuntimeException();
        }
        finally {
            try {
                if (system != null) {
                    system.uninitialize();
                }
            }
            catch (Throwable ignored) {}
        }
        this.secondary[3] = new ColorUIResource(defaults.getColor("Button.background"));
        this.secondary[2] = new ColorUIResource(defaults.getColor("Button.shadow"));
        this.secondary[1] = new ColorUIResource(defaults.getColor("Button.darkShadow"));
        this.secondary[0] = new ColorUIResource(this.secondary[1].darker());
        this.primary[3] = new ColorUIResource(defaults.getColor("MenuItem.selectionBackground"));
        this.primary[2] = new ColorUIResource(this.primary[3].darker());
        this.primary[1] = new ColorUIResource(this.primary[2].darker());
        this.primary[0] = new ColorUIResource(this.primary[1].darker());
        this.txt = new ColorUIResource(defaults.getColor("Button.foreground"));
        this.hiTxt = new ColorUIResource(defaults.getColor("TextArea.selectionForeground"));
        this.menuFG = new ColorUIResource(defaults.getColor("Menu.foreground"));
        this.winBG = new ColorUIResource(defaults.getColor("TextArea.background"));
        this.winFG = new ColorUIResource(defaults.getColor("TextArea.foreground"));
        this.txtHighlight = new ColorUIResource(defaults.getColor("TextArea.selectionBackground"));
        if (this.txt == null || this.hiTxt == null || this.menuFG == null || this.winBG == null || this.winFG == null) {
            throw new RuntimeException();
        }
        for (int i = 0; i < 4; ++i) {
            if (this.primary[i] != null && this.secondary[i] != null) continue;
            throw new RuntimeException();
        }
    }

    @Override
    public ColorUIResource getMenuSelectedForeground() {
        return this.hiTxt;
    }

    @Override
    public ColorUIResource getMenuForeground() {
        return this.menuFG;
    }

    @Override
    public ColorUIResource getSystemTextColor() {
        return this.txt;
    }

    @Override
    public ColorUIResource getControlTextColor() {
        return this.txt;
    }

    @Override
    public ColorUIResource getWindowBackground() {
        return this.winBG;
    }

    @Override
    public ColorUIResource getUserTextColor() {
        return this.winFG;
    }

    @Override
    public ColorUIResource getHighlightedTextColor() {
        return this.hiTxt;
    }

    @Override
    public ColorUIResource getTextHighlightColor() {
        return this.txtHighlight;
    }
}

